/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule.ftp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.custom.ftp.FTPHandler;
import jet.server.log.ServiceLogger;
import jet.server.schedule.ftp.ExplicitFTPSHandler;
import jet.server.schedule.ftp.FTPConnectionInfo;
import jet.server.schedule.ftp.FTPExporter;
import jet.server.schedule.ftp.FTPSConnectionInfo;
import jet.server.schedule.ftp.ImplicitFTPSHandler;
import jet.server.schedule.ftp.SCPHandler;
import jet.server.schedule.ftp.SFTPConnectionInfo;
import jet.server.schedule.ftp.SFTPHandler;
import jet.server.schedule.ftp.StandardFTPHandler;

public class FTPUtils {
    private static String QOIV = ServerEnv.temporaryPath;
    private static int append;

    private static synchronized int QOIV() {
        return ++append;
    }

    private static String getCanonicalPath(String string) {
        try {
            File file = new File(string);
            if (!file.exists()) {
                if (!file.mkdirs()) {
                    return null;
                }
            } else {
                File[] fileArray = file.listFiles();
                boolean bl = true;
                if (fileArray != null) {
                    int n = 0;
                    while (n < fileArray.length) {
                        bl = fileArray[n].isDirectory() ? (bl &= FTPUtils.deleteFile(fileArray[n])) : (bl &= fileArray[n].delete());
                        ++n;
                    }
                }
                if (!bl && ServiceLogger.isLoggable(4, 6)) {
                    ServiceLogger.logDebug(6600172, new String[]{string}, 6);
                }
            }
            return file.getCanonicalPath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getUniquePath() {
        String string = QOIV + FTPUtils.QOIV();
        return FTPUtils.getCanonicalPath(string);
    }

    public static int checkValidation(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            ServiceLogger.logError(2600191, 2);
            return 100;
        }
        String string = properties.getProperty("jrs.ftpHdlCls");
        FTPConnectionInfo fTPConnectionInfo = FTPUtils.getFTPConnectionInfo(properties);
        String string2 = (String)properties.get("jrs.ftpLoc");
        return FTPUtils.append(fTPConnectionInfo, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static int append(FTPConnectionInfo fTPConnectionInfo, String string, String string2) {
        FTPHandler fTPHandler = FTPUtils.close(fTPConnectionInfo, string);
        if (fTPHandler == null) {
            ServiceLogger.logError(2600174, new Object[]{string, new Integer(fTPConnectionInfo.getProto())}, 2);
            return 100;
        }
        int n = FTPUtils.changeDirectory(fTPConnectionInfo, fTPHandler, string2, true);
        Object var7_6 = null;
        try {
            fTPHandler.logout();
            fTPHandler.disconnect();
        }
        catch (Exception exception) {
            ServiceLogger.logError(2600179, new String[]{exception.getMessage()}, 2);
        }
        return n;
        catch (Exception exception) {
            ServiceLogger.logError(2600192, 2);
            int n2 = 100;
            Object var7_7 = null;
            {
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    try {
                        fTPHandler.logout();
                        fTPHandler.disconnect();
                    }
                    catch (Exception exception2) {
                        ServiceLogger.logError(2600179, new String[]{exception2.getMessage()}, 2);
                    }
                    throw throwable;
                }
            }
            try {
                fTPHandler.logout();
                fTPHandler.disconnect();
            }
            catch (Exception exception3) {
                ServiceLogger.logError(2600179, new String[]{exception3.getMessage()}, 2);
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int changeDirectory(FTPConnectionInfo fTPConnectionInfo, FTPHandler fTPHandler, String string, boolean bl) throws IOException {
        block17: {
            Object object;
            fTPHandler.connect(fTPConnectionInfo.getHost(), fTPConnectionInfo.getPort());
            boolean bl2 = false;
            String string2 = fTPConnectionInfo.getAccount();
            bl2 = string2 != null ? fTPHandler.login(fTPConnectionInfo.getUsername(), fTPConnectionInfo.getPassword(), string2) : fTPHandler.login(fTPConnectionInfo.getUsername(), fTPConnectionInfo.getPassword());
            string = FTPUtils.getValidFTPPath(string);
            if (!bl2) {
                ServiceLogger.logError(2600175, new Object[]{fTPConnectionInfo}, 2);
                return 300;
            }
            if (fTPConnectionInfo.getProto() == 2) {
                return 200;
            }
            if (string != null && string.length() > 0 && !fTPHandler.changeDirectory(string)) {
                if (!fTPHandler.makeDirectory(string)) {
                    boolean bl3 = true;
                    object = new StringTokenizer(string, "/", false);
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string3 = ((StringTokenizer)object).nextToken();
                        if (fTPHandler.changeDirectory(string3)) continue;
                        bl3 &= fTPHandler.makeDirectory(string3);
                        bl3 &= fTPHandler.changeDirectory(string3);
                    }
                    if (!bl3) {
                        ServiceLogger.logError(2600233, new String[]{string}, 2);
                        return 400;
                    }
                } else {
                    fTPHandler.changeDirectory(string);
                }
                if (ServiceLogger.isLoggable(4, 6)) {
                    ServiceLogger.logDebug(6600234, new String[]{string}, 6);
                }
            }
            if (bl) {
                block15: {
                    int n;
                    block16: {
                        String string4 = null;
                        if (QOIV != null) {
                            string4 = new File(QOIV).getParent();
                        }
                        object = null;
                        try {
                            object = File.createTempFile("ftp_", null, new File(string4));
                            if (fTPHandler.uploadFile(string4, ((File)object).getName())) break block15;
                            if (ServiceLogger.isLoggable(4, 6)) {
                                ServiceLogger.logDebug(6600193, new String[]{fTPHandler.getCurrentDirectory()}, 6);
                            }
                            n = 300;
                            Object var10_11 = null;
                            if (object == null) break block16;
                            ((File)object).delete();
                        }
                        catch (Throwable throwable) {
                            Object var10_13 = null;
                            if (object != null) {
                                ((File)object).delete();
                            }
                            throw throwable;
                        }
                    }
                    return n;
                }
                fTPHandler.deleteFile(((File)object).getName());
                Object var10_12 = null;
                if (object == null) break block17;
                ((File)object).delete();
                {
                }
            }
        }
        return 200;
    }

    private static FTPHandler close(FTPConnectionInfo fTPConnectionInfo, String string) {
        FTPHandler fTPHandler = null;
        if (string == null || string.length() == 0) {
            int n = fTPConnectionInfo.getProto();
            if (n == 0) {
                fTPHandler = new StandardFTPHandler();
            } else if (n == 3 || n == 4) {
                FTPSConnectionInfo fTPSConnectionInfo = (FTPSConnectionInfo)fTPConnectionInfo;
                String string2 = fTPSConnectionInfo.getSecureProtString();
                if (fTPSConnectionInfo.getConnectionType() == 1) {
                    fTPHandler = new ImplicitFTPSHandler(string2);
                } else if (fTPSConnectionInfo.getConnectionType() == 0) {
                    fTPHandler = new ExplicitFTPSHandler(string2);
                }
                ExplicitFTPSHandler explicitFTPSHandler = (ExplicitFTPSHandler)fTPHandler;
                explicitFTPSHandler.setAbleToFallbackFTP(fTPSConnectionInfo.isEnableNoSecurity());
                explicitFTPSHandler.setKeyManager(FTPUtils.connect(fTPSConnectionInfo));
                explicitFTPSHandler.setTrustManager(FTPUtils.getTrustManager(fTPSConnectionInfo));
                explicitFTPSHandler.setUsePssvMode(fTPSConnectionInfo.getTransferMode() == 0);
            } else if (n == 1 || n == 2) {
                SFTPConnectionInfo sFTPConnectionInfo = (SFTPConnectionInfo)fTPConnectionInfo;
                fTPHandler = n == 2 ? new SCPHandler() : new SFTPHandler();
                SCPHandler sCPHandler = (SCPHandler)fTPHandler;
                sCPHandler.setKnownHosts(FTPUtils.createTempFile(sFTPConnectionInfo));
                sCPHandler.setConnectionConfigs(FTPUtils.delete(sFTPConnectionInfo));
            }
        } else {
            try {
                fTPHandler = (FTPHandler)Class.forName(string).newInstance();
            }
            catch (ClassCastException classCastException) {
                ServiceLogger.logError(2600173, new String[]{string}, 2);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return fTPHandler;
    }

    public static boolean uploadFiles(FTPExporter fTPExporter) {
        String string = fTPExporter.getLocalPath();
        String string2 = fTPExporter.getHandlerClass();
        boolean bl = true;
        int n = 0;
        while (n < fTPExporter.getSiteNumber()) {
            String string3 = fTPExporter.getRemotePath(n);
            FTPConnectionInfo fTPConnectionInfo = fTPExporter.getConnInfo(n);
            if (!FTPUtils.uploadFiles(string, fTPConnectionInfo, string3, string2)) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean uploadFiles(String var0, FTPConnectionInfo var1_1, String var2_2, String var3_3) {
        block19: {
            var4_4 = FTPUtils.close(var1_1, var3_3);
            if (var4_4 == null || var0 == null) {
                ServiceLogger.logError(2600174, new Object[]{var3_3, new Integer(var1_1.getProto())}, 2);
                return false;
            }
            var5_5 = true;
            try {
                block20: {
                    try {
                        var6_6 = FTPUtils.changeDirectory(var1_1, var4_4, var2_2, false);
                        if (var6_6 != 200) {
                            if (ServiceLogger.isLoggable(4, 6)) {
                                ServiceLogger.logDebug(6600194, new Integer(var6_6), 6);
                            }
                            var7_8 = false;
                            var11_11 = null;
                            break block19;
                        }
                        if (var1_1.getProto() != 2 && ServiceLogger.isLoggable(4, 6)) {
                            ServiceLogger.logDebug(6600177, new String[]{var4_4.getCurrentDirectory()}, 6);
                        }
                        if ((var8_19 = (var7_9 = new File(var0)).list()) != null) {
                            if (var1_1.getProto() == 2) {
                                if ((var2_2 = FTPUtils.getValidFTPPath(var2_2)) == null) {
                                    var2_2 = "";
                                }
                                var2_2 = "/" + var2_2;
                                var9_20 = 0;
                                while (var9_20 < var8_19.length) {
                                    var5_5 &= var4_4.uploadFile(var0, var8_19[var9_20], var2_2 + "/" + var8_19[var9_20]);
                                    ++var9_20;
                                }
                            } else {
                                var9_21 = 0;
                                while (var9_21 < var8_19.length) {
                                    var5_5 &= var4_4.uploadFile(var0, var8_19[var9_21]);
                                    ++var9_21;
                                }
                            }
                        }
                        if (!var5_5 || !ServiceLogger.isLoggable(4, 6)) break block20;
                        ServiceLogger.logDebug(6600178, 6);
                    }
                    catch (Exception var6_7) {
                        ServiceLogger.logError(2600179, new String[]{var6_7.getMessage()}, 2);
                        ServiceLogger.logError(var6_7);
                        var7_10 = false;
                        var11_13 = null;
                        ** try [egrp 2[TRYBLOCK] [5 : 372->390)] { 
lbl43:
                        // 1 sources

                        var4_4.logout();
                        var4_4.disconnect();
                        return var7_10;
lbl47:
                        // 1 sources

                        catch (IOException var12_17) {
                            ServiceLogger.logError(2600179, new String[]{var12_17.getMessage()}, 2);
                        }
                        return var7_10;
                    }
                }
                var11_12 = null;
                try {
                    var4_4.logout();
                    var4_4.disconnect();
                    return var5_5;
                }
                catch (IOException var12_16) {
                    ServiceLogger.logError(2600179, new String[]{var12_16.getMessage()}, 2);
                    return var5_5;
                }
            }
            catch (Throwable var10_22) {
                var11_14 = null;
                ** try [egrp 2[TRYBLOCK] [5 : 372->390)] { 
lbl65:
                // 1 sources

                var4_4.logout();
                var4_4.disconnect();
                throw var10_22;
lbl69:
                // 1 sources

                catch (IOException var12_18) {
                    ServiceLogger.logError(2600179, new String[]{var12_18.getMessage()}, 2);
                }
                throw var10_22;
            }
        }
        ** try [egrp 2[TRYBLOCK] [5 : 372->390)] { 
lbl74:
        // 1 sources

        var4_4.logout();
        var4_4.disconnect();
        return var7_8;
lbl78:
        // 1 sources

        catch (IOException var12_15) {
            ServiceLogger.logError(2600179, new String[]{var12_15.getMessage()}, 2);
        }
        return var7_8;
    }

    public static FTPConnectionInfo getFTPConnectionInfo(Hashtable hashtable) {
        FTPConnectionInfo fTPConnectionInfo = null;
        int n = CSUtil.parseInt((String)hashtable.get("jrs.ftpProt"), 0);
        fTPConnectionInfo = n == 3 || n == 4 ? new FTPSConnectionInfo(hashtable) : (n == 1 || n == 2 ? new SFTPConnectionInfo(hashtable) : new FTPConnectionInfo(hashtable));
        return fTPConnectionInfo;
    }

    private static KeyManager connect(FTPSConnectionInfo fTPSConnectionInfo) {
        String string = fTPSConnectionInfo.getKeyStoreType();
        String string2 = fTPSConnectionInfo.getKeyStoreFile();
        String string3 = fTPSConnectionInfo.getKeyStorePsd();
        String string4 = fTPSConnectionInfo.getKeyManAlg();
        if (string == null) {
            string = ServerEnv.getFTPSSettings().getProperty("ftps.keystore.type");
        }
        if (string2 == null) {
            string2 = ServerEnv.getFTPSSettings().getProperty("ftps.keystore.file");
        }
        if (string3 == null) {
            string3 = ServerEnv.getFTPSSettings().getProperty("ftps.keystore.password");
        }
        if (string4 == null) {
            string4 = ServerEnv.getFTPSSettings().getProperty("ftps.keymanager.algorithm");
        }
        if (string != null) {
            try {
                KeyStore keyStore = KeyStore.getInstance(string);
                FileInputStream fileInputStream = null;
                if (string2 != null) {
                    fileInputStream = new FileInputStream(string2);
                }
                char[] cArray = string3 != null ? string3.toCharArray() : null;
                keyStore.load(fileInputStream, cArray);
                fileInputStream.close();
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string4);
                keyManagerFactory.init(keyStore, cArray);
                return keyManagerFactory.getKeyManagers()[0];
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 2);
            }
        }
        return null;
    }

    private static TrustManager getTrustManager(FTPSConnectionInfo fTPSConnectionInfo) {
        String string = fTPSConnectionInfo.getTrustStoreType();
        String string2 = fTPSConnectionInfo.getTrustStoreFile();
        String string3 = fTPSConnectionInfo.getTrustStorePsd();
        String string4 = fTPSConnectionInfo.getTrustManAlg();
        if (string == null) {
            string = ServerEnv.getFTPSSettings().getProperty("ftps.truststore.type");
        }
        if (string2 == null) {
            string2 = ServerEnv.getFTPSSettings().getProperty("ftps.truststore.file");
        }
        if (string3 == null) {
            string3 = ServerEnv.getFTPSSettings().getProperty("ftps.truststore.password");
        }
        if (string4 == null) {
            string4 = ServerEnv.getFTPSSettings().getProperty("ftps.trustmanager.algorithm");
        }
        if (string != null) {
            try {
                KeyStore keyStore = KeyStore.getInstance(string);
                FileInputStream fileInputStream = null;
                if (string2 != null) {
                    fileInputStream = new FileInputStream(string2);
                }
                char[] cArray = string3 != null ? string3.toCharArray() : null;
                keyStore.load(fileInputStream, cArray);
                fileInputStream.close();
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(string4);
                trustManagerFactory.init(keyStore);
                return trustManagerFactory.getTrustManagers()[0];
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 2);
            }
        }
        return null;
    }

    private static String createTempFile(SFTPConnectionInfo sFTPConnectionInfo) {
        File file;
        String string = sFTPConnectionInfo.getKnownHosts();
        if (string == null) {
            string = ServerEnv.getFTPSSettings().getProperty("ssh.knownhosts.file");
        }
        if (string != null) {
            file = new File(string);
            if (file.exists() && file.isFile()) {
                string = file.getAbsolutePath();
            } else {
                if (ServiceLogger.isLoggable(2, 3)) {
                    ServiceLogger.logError(2600245, string, 3);
                }
                string = null;
            }
        }
        if (string == null && (file = new File(System.getProperty("user.home"), ".ssh/known_hosts")).exists() && file.isFile()) {
            string = file.getAbsolutePath();
        }
        if (string == null && (file = new File("/etc/ssh/ssh_known_hosts")).exists() && file.isFile()) {
            string = file.getAbsolutePath();
        }
        return string;
    }

    private static Hashtable delete(SFTPConnectionInfo sFTPConnectionInfo) {
        String string = sFTPConnectionInfo.getStrictHKChecking();
        String string2 = sFTPConnectionInfo.getHkAlgs();
        String string3 = sFTPConnectionInfo.getKexAlgs();
        String string4 = sFTPConnectionInfo.getC2sCipherAlgs();
        String string5 = sFTPConnectionInfo.getS2cCipherAlgs();
        String string6 = sFTPConnectionInfo.getC2sMacAlgs();
        String string7 = sFTPConnectionInfo.getS2cMacAlgs();
        String string8 = sFTPConnectionInfo.getC2sCmpAlgs();
        String string9 = sFTPConnectionInfo.getS2cMacAlgs();
        String string10 = sFTPConnectionInfo.getC2sLang();
        String string11 = sFTPConnectionInfo.getS2cLang();
        if (string == null) {
            string = ServerEnv.getFTPSSettings().getProperty("ssh.nostricthkchecking");
        }
        if (string2 == null) {
            string2 = ServerEnv.getFTPSSettings().getProperty("ssh.hk.algorithms");
        }
        if (string3 == null) {
            string3 = ServerEnv.getFTPSSettings().getProperty("ssh.kex.algorithms");
        }
        if (string4 == null) {
            string4 = ServerEnv.getFTPSSettings().getProperty("ssh.c2s.cipher.algorithms");
        }
        if (string5 == null) {
            string5 = ServerEnv.getFTPSSettings().getProperty("ssh.s2c.cipher.algorithms");
        }
        if (string6 == null) {
            string6 = ServerEnv.getFTPSSettings().getProperty("ssh.c2s.mac.algorithms");
        }
        if (string7 == null) {
            string7 = ServerEnv.getFTPSSettings().getProperty("ssh.s2c.mac.algorithms");
        }
        if (string8 == null) {
            string8 = ServerEnv.getFTPSSettings().getProperty("ssh.c2s.compression.algorithms");
        }
        if (string9 == null) {
            string9 = ServerEnv.getFTPSSettings().getProperty("ssh.s2c.compression.algorithms");
        }
        if (string10 == null) {
            string10 = ServerEnv.getFTPSSettings().getProperty("ssh.c2s.language");
        }
        if (string11 == null) {
            string11 = ServerEnv.getFTPSSettings().getProperty("ssh.s2c.language");
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (string != null) {
            string = string.equalsIgnoreCase("yes") ? "yes" : "no";
            hashtable.put("StrictHostKeyChecking", string);
        }
        if (string2 != null) {
            hashtable.put("server_host_key", string2);
        }
        if (string3 != null) {
            hashtable.put("kex", string3);
        }
        if (string4 != null) {
            hashtable.put("cipher.c2s", string4);
        }
        if (string5 != null) {
            hashtable.put("cipher.s2c", string5);
        }
        if (string6 != null) {
            hashtable.put("mac.c2s", string6);
        }
        if (string7 != null) {
            hashtable.put("mac.s2c", string7);
        }
        if (string8 != null) {
            hashtable.put("compression.c2s", string8);
        }
        if (string9 != null) {
            hashtable.put("compression.s2c", string9);
        }
        if (string10 != null) {
            hashtable.put("lang.c2s", string10);
        }
        if (string11 != null) {
            hashtable.put("lang.s2c", string11);
        }
        return hashtable;
    }

    public static boolean deleteTempFiles(String string) {
        return FTPUtils.deleteTempFiles(string, true);
    }

    public static boolean deleteTempFiles(String string, boolean bl) {
        if (string == null) {
            return false;
        }
        try {
            return FTPUtils.disconnect(new File(string), bl);
        }
        catch (Exception exception) {
            if (ServiceLogger.isLoggable(2, 3)) {
                ServiceLogger.logError(exception, 3);
            }
            return false;
        }
    }

    private static boolean deleteFile(File file) throws Exception {
        return FTPUtils.disconnect(file, true);
    }

    private static boolean disconnect(File file, boolean bl) throws Exception {
        boolean bl2 = true;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                bl2 = fileArray[n].isDirectory() ? (bl2 &= FTPUtils.deleteFile(fileArray[n])) : (bl2 &= fileArray[n].delete());
                ++n;
            }
        }
        if (bl) {
            bl2 &= file.delete();
        }
        return bl2;
    }

    public static String getValidFTPPath(String string) {
        if (string == null) {
            return null;
        }
        string = string.replace('\\', '/');
        while (string.startsWith("/")) {
            string = string.substring(1);
        }
        while (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    static {
        if (QOIV == null) {
            QOIV = System.getProperty("user.home");
        }
        if (QOIV == null) {
            QOIV = File.separator;
        }
        if (!QOIV.endsWith(File.separator)) {
            QOIV = QOIV + File.separator;
        }
        QOIV = QOIV + "ftp_";
    }
}

