/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule.jrtasks;

import guitools.toolkit.JDebug;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;
import jet.cs.TaskIntf;
import jet.cs.util.APIUtil;
import jet.server.ServerEnv;
import jet.server.api.monitor.FinishedReportTable;
import jet.server.api.monitor.RunningReport;
import jet.server.api.monitor.RunningReportTable;
import jet.server.jrserver.monitor.JRFinishedReport;
import jet.server.jrserver.monitor.JRFinishedReportTable;
import jet.server.jrserver.monitor.JRRunningReport;
import jet.server.jrserver.monitor.JRRunningReportTable;
import jet.server.log.ServiceLogger;
import jet.server.schedule.Launchable;
import jet.server.schedule.LaunchableObj;
import jet.server.schedule.jrtasks.RunRptTaskRoot;

public class MonitorThread
extends Thread {
    private JRFinishedReportTable QOIV = new JRFinishedReportTable();
    private JRRunningReportTable WARNING = new JRRunningReportTable();
    private long addElement = (long)ServerEnv.getMonitorInterval() * 100L;
    private boolean addToFinishedReport = false;
    private long addToRunningReport = 0L;
    private Vector append;
    private Vector currentTimeMillis;
    private Vector delRunningReportTo;

    public MonitorThread() {
        if (this.addElement > 600000L) {
            this.addElement = 600000L;
        }
        this.currentTimeMillis = new Vector();
        this.append = new Vector();
        this.delRunningReportTo = new Vector();
        this.start();
    }

    public void run() {
        if (ServiceLogger.isLoggable(3, 5)) {
            ServiceLogger.logEvent("MonitorRunner started!\tinterval: " + this.addElement, 5);
        }
        while (!this.addToFinishedReport) {
            try {
                Thread.sleep(this.addElement);
                if (this.currentTimeMillis.size() > 0) {
                    this.addElement();
                }
                if (this.delRunningReportTo.size() > 0) {
                    this.QOIV();
                }
                if (this.append.size() > 0) {
                    this.WARNING();
                }
                if (!this.addToFinishedReport) continue;
                break;
            }
            catch (Throwable throwable) {
                JDebug.WARNING((Throwable)throwable);
            }
        }
    }

    public void destroy() {
        this.append.removeAllElements();
        this.currentTimeMillis.removeAllElements();
        this.addToFinishedReport = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyaddFinishedReport(String string, String string2, int n, String string3, String string4, String string5, String string6, String string7, String string8, Vector vector, Vector vector2, int n2, String string9, long l, long l2, long l3, long l4, String string10, String string11, String string12) {
        JRFinishedReport jRFinishedReport = new JRFinishedReport(string, string2, n, string3, string4, string5, string6, string7, string8, vector, vector2, n2, string9, l, l2, l3, l4, string10, string11, string12);
        Vector vector3 = this.append;
        synchronized (vector3) {
            int n3 = this.append.size();
            int n4 = 0;
            while (n4 < n3) {
                JRFinishedReport jRFinishedReport2 = (JRFinishedReport)this.append.elementAt(n4);
                if (jRFinishedReport2.getEndTime() > jRFinishedReport.getEndTime()) {
                    this.append.insertElementAt(jRFinishedReport, n4);
                    break;
                }
                ++n4;
            }
            if (n4 == n3) {
                this.append.addElement(jRFinishedReport);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAddRunningReport(int n, String string, Date date, Date date2, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        JRRunningReport jRRunningReport = new JRRunningReport(n, string, date, date2, string2, string3, string4, string5, string6, string7, string8, string9);
        Vector vector = this.currentTimeMillis;
        synchronized (vector) {
            int n2 = this.currentTimeMillis.size();
            int n3 = 0;
            while (n3 < n2) {
                JRRunningReport jRRunningReport2 = (JRRunningReport)this.currentTimeMillis.elementAt(n3);
                if (APIUtil.parseLong(jRRunningReport2.getSubmitedTime().toString()) > APIUtil.parseLong(jRRunningReport.getSubmitedTime().toString())) {
                    this.currentTimeMillis.insertElementAt(jRRunningReport, n3);
                    break;
                }
                ++n3;
            }
            if (n3 == n2) {
                this.currentTimeMillis.addElement(jRRunningReport);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAddRunningReport(Launchable launchable) {
        Serializable serializable;
        LaunchableObj launchableObj = (LaunchableObj)launchable;
        TaskIntf taskIntf = null;
        taskIntf = launchableObj.getTask();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (taskIntf instanceof RunRptTaskRoot) {
            serializable = (RunRptTaskRoot)taskIntf;
            string = ((RunRptTaskRoot)serializable).getCatalog();
            string2 = ((RunRptTaskRoot)serializable).getReport();
            string4 = ((RunRptTaskRoot)serializable).getRunName();
            string5 = ((RunRptTaskRoot)serializable).getRunPort();
            string6 = ((RunRptTaskRoot)serializable).getPublishType();
        }
        serializable = new JRRunningReport(launchableObj.getLaunchType(), taskIntf.getClass().getName(), new Date(launchableObj.getStartTime()), new Date(launchableObj.getSubmitTime()), launchableObj.getUid(), string, string2, string3, taskIntf.getId(), string4, string5, string6);
        Vector vector = this.currentTimeMillis;
        synchronized (vector) {
            int n = this.currentTimeMillis.size();
            int n2 = 0;
            while (n2 < n) {
                JRRunningReport jRRunningReport = (JRRunningReport)this.currentTimeMillis.elementAt(n2);
                if (APIUtil.parseLong(jRRunningReport.getSubmitedTime().toString()) > APIUtil.parseLong(((JRRunningReport)serializable).getSubmitedTime().toString())) {
                    this.currentTimeMillis.insertElementAt(serializable, n2);
                    break;
                }
                ++n2;
            }
            if (n2 == n) {
                this.currentTimeMillis.addElement(serializable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDelRunningReport(String string) {
        Vector vector = this.delRunningReportTo;
        synchronized (vector) {
            int n = this.delRunningReportTo.size();
            this.delRunningReportTo.addElement(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAddQueueReport(String string, long l) {
        RunningReport runningReport = this.WARNING.getRunningReportByTaskID(string);
        if (runningReport != null) {
            ((JRRunningReport)runningReport).setTimeInRun(l);
        } else {
            Vector vector = this.currentTimeMillis;
            synchronized (vector) {
                int n = this.currentTimeMillis.size();
                int n2 = 0;
                while (n2 < n) {
                    JRRunningReport jRRunningReport = (JRRunningReport)this.currentTimeMillis.elementAt(n2);
                    if (jRRunningReport.getTaskID().equalsIgnoreCase(string)) {
                        jRRunningReport.setTimeInRun(l);
                        break;
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAddRunPort(String string, String string2, String string3) {
        RunningReport runningReport = this.WARNING.getRunningReportByTaskID(string);
        if (runningReport != null) {
            ((JRRunningReport)runningReport).setRunPort(string2);
            ((JRRunningReport)runningReport).setRunHost(string3);
        } else {
            Vector vector = this.currentTimeMillis;
            synchronized (vector) {
                int n = this.currentTimeMillis.size();
                int n2 = 0;
                while (n2 < n) {
                    JRRunningReport jRRunningReport = (JRRunningReport)this.currentTimeMillis.elementAt(n2);
                    if (jRRunningReport.getTaskID().equalsIgnoreCase(string)) {
                        jRRunningReport.setRunPort(string2);
                        jRRunningReport.setRunHost(string3);
                        break;
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void QOIV() throws Exception {
        long l = System.currentTimeMillis();
        Vector vector = this.delRunningReportTo;
        synchronized (vector) {
            int n = this.delRunningReportTo.size();
            String string = null;
            JRRunningReport jRRunningReport = null;
            int n2 = 0;
            while (n2 < n) {
                string = (String)this.delRunningReportTo.elementAt(n2);
                jRRunningReport = (JRRunningReport)this.WARNING.getRunningReportByTaskID(string);
                if (jRRunningReport != null && l - APIUtil.parseLong(jRRunningReport.getSubmitedTime().toString()) >= this.addElement) {
                    this.delRunningReportTo.removeElementAt(n2);
                    --n;
                    this.delRunningReportTo(string);
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void WARNING() throws Exception {
        long l = System.currentTimeMillis();
        JRFinishedReport jRFinishedReport = null;
        Vector vector = this.append;
        synchronized (vector) {
            int n = this.append.size();
            int n2 = 0;
            while (n2 < n) {
                jRFinishedReport = (JRFinishedReport)this.append.elementAt(n2);
                if (l - jRFinishedReport.getEndTime() >= this.addElement) {
                    this.append.removeElementAt(n2);
                    --n;
                    this.addToFinishedReport(jRFinishedReport);
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addElement() throws Exception {
        long l = System.currentTimeMillis();
        JRRunningReport jRRunningReport = null;
        Vector vector = this.currentTimeMillis;
        synchronized (vector) {
            int n = this.currentTimeMillis.size();
            int n2 = 0;
            while (n2 < n) {
                jRRunningReport = (JRRunningReport)this.currentTimeMillis.elementAt(n2);
                if (l - APIUtil.parseLong(jRRunningReport.getSubmitedTime().toString()) >= this.addElement) {
                    this.currentTimeMillis.removeElementAt(n2);
                    --n;
                    this.addToRunningReport(jRRunningReport);
                }
                ++n2;
            }
        }
    }

    public void addToFinishedReport(JRFinishedReport jRFinishedReport) {
        this.QOIV.registerFinishedReport(jRFinishedReport.getTaskID(), jRFinishedReport.getTaskClass(), jRFinishedReport.getLaunchType(), jRFinishedReport.getUserID(), jRFinishedReport.getRemoteHost(), jRFinishedReport.getCatalog(), jRFinishedReport.getReport(), jRFinishedReport.getParamFile(), jRFinishedReport.getParamValuesString(), jRFinishedReport.getInputDirAndName(), jRFinishedReport.getResultFile(), jRFinishedReport.getTotalPageNumber(), jRFinishedReport.getReason(), jRFinishedReport.getSubmitTime(), jRFinishedReport.getStartRunTime(), jRFinishedReport.getEndTime(), jRFinishedReport.getWaitTimeInRun(), jRFinishedReport.getRunName(), jRFinishedReport.getRunPort(), jRFinishedReport.getPublishType());
    }

    public FinishedReportTable getFinishedReportTable() {
        this.QOIV.removeFinishedReportIfOverFlow();
        return this.QOIV;
    }

    public void addToRunningReport(JRRunningReport jRRunningReport) {
        this.WARNING.registerRunningReport(jRRunningReport.getLaunchType(), jRRunningReport.getTaskClass(), jRRunningReport.getStartedTime(), jRRunningReport.getSubmitedTime(), jRRunningReport.getUserID(), jRRunningReport.getCatalog(), jRRunningReport.getReport(), jRRunningReport.getParamFile(), jRRunningReport.getTaskID(), jRRunningReport.getRunName(), jRRunningReport.getRunPort(), jRRunningReport.getPublishType());
    }

    public void delRunningReportTo(String string) {
        if (string != null) {
            this.WARNING.removeRunningReportByTaskID(string);
        }
    }

    public RunningReportTable getRunningReportTable() {
        return this.WARNING;
    }
}

