/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule.jrtasks;

import guitools.toolkit.JDebug;
import java.io.File;
import java.sql.Connection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import jet.bean.JREngine;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.RptServerException;
import jet.server.api.TooManyReportsException;
import jet.server.api.admin.cfg.ConfigurationPrecisionMapping;
import jet.server.api.cluster.ClusterException;
import jet.server.api.cluster.ClusterService;
import jet.server.api.cluster.Member;
import jet.server.api.http.HttpUtil;
import jet.server.intf.engine.EngineContext;
import jet.server.intf.engine.ReportSetEngine;
import jet.server.jrc.engine.EngineManager;
import jet.server.jrc.engine.RemoteEngineMsgListener;
import jet.server.jrc.resource.nls.NLSUtil;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;
import jet.server.schedule.ParameterManager;
import jet.server.schedule.SchdTools;
import jet.server.schedule.bursting.MultiBurstingExecutor;
import jet.server.schedule.jrtasks.JRTUtil;
import jet.server.schedule.jrtasks.JRTask;
import jet.server.schedule.jrtasks.ReportSheetRunner;
import jet.server.schedule.jrtasks.RunningReportSheets;

public abstract class RunRptTaskRoot
extends JRTask
implements RemoteEngineMsgListener {
    protected String uid = null;
    protected String taskName = null;
    protected String cat = null;
    protected String rpt = null;
    protected int catVerNum = 0;
    protected int rptVerNum = 0;
    private boolean _createEngineContext = false;
    protected String lang = null;
    protected String coun = null;
    protected String enc = null;
    protected int fromEncoding = 2;
    protected int toEncoding = 0;
    protected boolean hasConvertEncoding = false;
    protected boolean hasStyle = false;
    protected String styleGroup = null;
    protected String dParamFile = null;
    protected String paramFile = null;
    protected String paramValues = null;
    protected String namedWherePortion = null;
    protected String wherePortion = null;
    protected String whereClause = null;
    protected String dbUser = null;
    protected String dbPswd = null;
    protected String dbJdbcUrl = null;
    protected String dbJdbcDriver = null;
    protected String rhost = null;
    protected String eqID = null;
    protected Connection userDbConnection = null;
    protected boolean dbGetSupportInfo = false;
    protected String publishType = null;
    protected boolean deleteParamFile = false;
    protected String run_task_id = null;
    protected boolean errId = false;
    protected boolean isThrowExcp = false;
    protected Throwable thrdThrow = null;
    protected List engineErrors = new Vector();
    protected EngineContext engineContext = null;
    protected ReportSetEngine reportSetEngine = null;
    protected EngineManager manager = null;
    protected String engMsgs = null;
    protected String errmsg = null;
    protected String taskID = null;
    protected int launchType = 0;
    protected String taskClass = null;
    protected Date subTime = null;
    protected long waitTime = 0L;
    protected String runName = "";
    protected String runPort = "";
    protected boolean hasPreferredServer = false;
    protected String preferredServerName = null;
    protected Properties triggerParams = null;
    protected boolean hasCheckedSheets = false;
    protected RunningReportSheets runningRptSheets = null;
    protected String currentReport = null;
    protected Hashtable dsInfos = new Hashtable();
    protected String sequenceID = null;
    protected boolean hasStopped = false;
    private ConfigurationPrecisionMapping addFailedTaskToMonitor = null;
    ReportSheetRunner[] S = null;
    Thread[] A = null;
    String[] E = null;
    protected String uiLanguage;
    protected Properties htmlNavNLS = null;
    private int canRunReport = 0;
    protected String _cat = null;
    protected String _rpt = null;
    private EngineContext createEngineContext = null;
    private boolean createParamFile = false;
    private boolean createTempFile = false;
    private boolean currentTimeMillis = false;
    private MultiBurstingExecutor engineExit;

    public String getSequenceID() {
        return this.sequenceID;
    }

    public void init(Properties properties) throws Exception {
        Object object;
        super.init(properties);
        this.uid = (String)properties.get("jrs.uid");
        this.taskName = (String)properties.get("jrs.schedule_name");
        if (this.taskName == null) {
            this.taskName = (String)properties.get("jrs.task_name");
        }
        this.rhost = (String)properties.get("jrs.remote_host");
        this.eqID = (String)properties.get("jrs.ext_qrybl_id");
        this._createEngineContext = CSUtil.getBoolean((String)properties.get("jrs.enable_nls"), false);
        if (this._createEngineContext) {
            this.lang = (String)properties.get("jrs.rpt_language");
            this.coun = (String)properties.get("jrs.rpt_country");
            if (this.lang != null && this.lang.length() > 0) {
                this.htmlNavNLS = NLSUtil.getHtmlNavNLS(new Locale(this.lang, this.coun == null ? "" : this.coun));
            }
        }
        this.enc = (String)properties.get("jrs.rpt_encoding");
        this.hasStyle = CSUtil.getBoolean((String)properties.get("jrs.has_style"), false);
        this.styleGroup = (String)properties.get("jrs.style_group");
        this.hasConvertEncoding = CSUtil.getBoolean((String)properties.get("jrs.has_convert_enc"), false);
        this.fromEncoding = CSUtil.parseInt((String)properties.get("jrs.from_encoding"), 2);
        this.toEncoding = CSUtil.parseInt((String)properties.get("jrs.to_encoding"), 0);
        this.paramValues = (String)properties.get("jrs.param_values");
        this.namedWherePortion = (String)properties.get("jrs.named_wp");
        this.wherePortion = (String)properties.get("jrs.wp");
        this.whereClause = (String)properties.get("jrs.wc");
        this.cat = (String)properties.get("jrs.catalog");
        this.catVerNum = CSUtil.parseInt((String)properties.get("jrs.cat_version"), 0);
        this.rptVerNum = CSUtil.parseInt((String)properties.get("jrs.rpt_version"), 0);
        this.preferredServerName = (String)properties.get("jrs.the_name_of_preferred_server");
        if (this.preferredServerName != null) {
            this.hasPreferredServer = this.preferredServerName.length() > 0;
        }
        this.sequenceID = properties.getProperty("sequence_ID");
        this.deleteParamFile = CSUtil.getBoolean((String)properties.get("jrs.del_param_file"), false);
        this.dbJdbcUrl = (String)properties.get("jrs.jdbc_url");
        this.dbJdbcDriver = (String)properties.get("jrs.jdbc_driver");
        if (!CSUtil.getBoolean((String)properties.get("jrs.use_def_db_user"), false)) {
            this.dbUser = (String)properties.get("jrs.db_user");
            this.dbPswd = (String)properties.get("jrs.db_pswd");
            if (CSUtil.getBoolean((String)properties.get("jrs.use_new_db_pswd"), false)) {
                this.dbPswd = (String)properties.get("jrs.new_db_pswd");
            }
        }
        if ((this.dbPswd == null || this.dbPswd == "null") && properties.containsKey("jrs.db_pswd")) {
            this.dbPswd = "";
        }
        if ((object = properties.get("jrs.jdbc_connection_object")) != null && object instanceof Connection) {
            this.userDbConnection = (Connection)object;
        }
        this.dbGetSupportInfo = CSUtil.getBoolean((String)properties.get("jrs.jdbc_get_support_info"), false);
        this.rpt = (String)properties.get("jrs.report");
        if (this.rpt != null) {
            this.getParameterFile(properties);
        }
        this._createEngineContext(properties);
        this.taskID = (String)properties.get("jrs.task_id");
        this.launchType = CSUtil.parseInt((String)properties.get("jrs.launch_type"));
        this.taskClass = (String)properties.get("jrs.task_class");
        long l = CSUtil.parseLong((String)properties.get("jrs.submit_time"));
        this.subTime = new Date(l);
        this.run_task_id = SchdTools.getIdBase();
        Enumeration<Object> enumeration = properties.keys();
        String string = null;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.startsWith("TRGDATA_")) {
                this.triggerParams = (Properties)properties.get(string2);
                continue;
            }
            if (!string2.startsWith("jrs.ds_prop")) continue;
            string = string2.substring("jrs.ds_prop".length());
            this.dsInfos.put(string, (String)properties.get(string2));
        }
        this.addFailedTaskToMonitor = HttpUtil.getHttpRptServer().getAdminService().getConfigService().getConfigurationPrecisionMapping();
    }

    public ReportSheetRunner getRunRptThread(String string) {
        int n = 0;
        while (n < this.E.length) {
            if (this.E[n].equals(string)) {
                return this.S[n];
            }
            ++n;
        }
        return null;
    }

    protected void getParameterFile(Properties properties) throws Exception {
        String string = JRTUtil.getRealPath(this.uid, this.rpt, this.getJRTaskManager().getResourceManager());
        File file = new File(string);
        if (string == null || string.trim().length() == 0 || !file.exists()) {
            throw new RptServerException(600020, (Object[])new String[]{this.uid, this.cat, this.rpt}, null);
        }
        if (JRTUtil.hasParameter(properties)) {
            String string2 = null;
            string2 = ParameterManager.usedParamGen(properties) ? ".dparam" : ".param";
            this.paramFile = JRTUtil.createParamFile(SchdTools.createTempFile(this.getJRTaskManager().getResourceManager().getHistDir(), CSUtil.getNameWithoutExt(string) + "_", string2), properties);
        }
    }

    public String getTaskID() {
        return this.taskID;
    }

    public int getLaunchType() {
        return this.launchType;
    }

    public String getTaskClass() {
        return this.taskClass;
    }

    public Date getSubmitTime() {
        return this.subTime;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public String getRunName() {
        return this.runName;
    }

    public String getRunPort() {
        return this.runPort;
    }

    public String getUid() {
        return this.uid;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getRemoteHost() {
        return this.rhost;
    }

    public String getDBUser() {
        return this.dbUser;
    }

    public String getDBPassword() {
        return this.dbPswd;
    }

    public String getDBJdbcUrl() {
        return this.dbJdbcUrl;
    }

    public String getDBJdbcDriver() {
        return this.dbJdbcDriver;
    }

    public Connection getUserDBConnection() {
        return this.userDbConnection;
    }

    public boolean isGetJDBCSupportInfo() {
        return this.dbGetSupportInfo;
    }

    public String getPublishType() {
        return this.publishType;
    }

    public String getCatalog() {
        return this.cat;
    }

    public String getReport() {
        return this.rpt;
    }

    public String getLanguage() {
        return this.lang;
    }

    public String getCountry() {
        return this.coun;
    }

    public String getEncoding() {
        return this.enc;
    }

    public int getFromEncoding() {
        return this.fromEncoding;
    }

    public int getToEncoding() {
        return this.toEncoding;
    }

    public boolean hasConvertEncoding() {
        return this.hasConvertEncoding;
    }

    public boolean hasStyleGroup() {
        return this.hasStyle;
    }

    public String getStyleGroup() {
        return this.styleGroup;
    }

    public String getParamFile() {
        return this.paramFile;
    }

    public String getDParamFile() {
        return this.dParamFile;
    }

    public String getParamValues() {
        return this.paramValues;
    }

    public String getNamedWherePortion() {
        return this.namedWherePortion;
    }

    public String getWherePortion() {
        return this.wherePortion;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public boolean hasError() {
        return this.errId;
    }

    public void setErrorId(boolean bl) {
        this.errId = bl;
    }

    public String getRunTaskId() {
        return this.run_task_id;
    }

    public String getRunTaskKey() {
        return this.getClass().getName() + "@" + this.hashCode() + "#ID=" + this.getId() + "(" + this.getRunTaskId() + ")";
    }

    public boolean isThrowExcp() {
        return this.isThrowExcp;
    }

    public void setThrow(boolean bl) {
        this.isThrowExcp = bl;
    }

    public void appendError(String string) {
        this.errId = true;
        this.errmsg = this.errmsg != null ? this.errmsg + "\r\n" + string : string;
        ServiceLogger.logError(this + "\r\n" + string);
    }

    public void removeError() {
        this.errId = false;
    }

    public String getErrorMsg() {
        return this.errmsg;
    }

    public String getEngMsgs() {
        return this.engMsgs;
    }

    public Throwable getThrdThrow() {
        return this.thrdThrow;
    }

    public List getEngineErrors() {
        return this.engineErrors;
    }

    public void started() {
        this.waitTime = System.currentTimeMillis();
        this.getJRTaskManager().notifyAddQueueToMonitor(this.getTaskID(), this.waitTime);
        try {
            ServiceLogger.logEngine(6600001, this.engineContext, 6);
        }
        catch (Throwable throwable) {
            JDebug.WARNING((Throwable)throwable);
        }
    }

    public void finished() {
        try {
            ServiceLogger.logEngine(6600002, this.engineContext, 6);
        }
        catch (Throwable throwable) {
            JDebug.WARNING((Throwable)throwable);
        }
    }

    public void engineMassage(String string) {
        try {
            ServiceLogger.logEngine(6600003, this.engineContext, 6);
        }
        catch (Throwable throwable) {
            JDebug.WARNING((Throwable)throwable);
        }
        if (this.engineContext != null) {
            this.engMsgs = this.engMsgs == null ? string : this.engMsgs + " | " + string;
        }
    }

    public void ThreadException(Thread thread, Throwable throwable) {
        this.thrdThrow = throwable;
        try {
            ServiceLogger.logEngine(6600004, new Object[]{SchdTools.getStackTraceString(throwable), this.engineContext}, 6);
        }
        catch (Throwable throwable2) {
            JDebug.WARNING((Throwable)throwable2);
        }
        ServiceLogger.logError("ThreadException: " + thread);
        ServiceLogger.logError(throwable);
    }

    public void ThreadException(String string, Throwable throwable) {
        this.thrdThrow = throwable;
        try {
            ServiceLogger.logEngine(6600004, new Object[]{SchdTools.getStackTraceString(throwable), this.engineContext}, 6);
        }
        catch (Throwable throwable2) {
            JDebug.WARNING((Throwable)throwable2);
        }
        ServiceLogger.logError("ThreadException: " + string);
        ServiceLogger.logError(throwable);
    }

    public void noteError(String string, Throwable throwable) {
        this.engineErrors.add(throwable);
    }

    public void addRunTimeValueToProperties(Properties properties) {
        Properties properties2 = properties;
        if (properties2 == null) {
            properties2 = new Properties();
        }
        if (this.getEngMsgs() != null) {
            properties2.put("jrs.engine_message", this.getEngMsgs());
        }
        if (this.getErrorMsg() != null) {
            properties2.put("jrs.error", this.getErrorMsg());
        }
        if (this.hasError() || this.getErrorMsg() != null) {
            properties2.put("jrs.is_successful", "false");
        } else {
            properties2.put("jrs.is_successful", "true");
        }
    }

    public Properties toProperties(Properties properties) {
        String string;
        Properties properties2 = super.toProperties(properties);
        if (properties2 == null) {
            properties2 = new Properties();
        }
        properties2.put("jrs.task_id", this.getId());
        if (this.uid != null) {
            properties2.put("jrs.uid", this.uid);
        }
        if (this.taskName != null) {
            properties2.put("jrs.schedule_name", this.taskName);
        }
        Enumeration enumeration = this.dsInfos.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            properties2.put(string, HttpUtil.decodeEsc((String)this.dsInfos.get(string)));
        }
        if (this.dbUser != null) {
            properties2.put("jrs.db_user", this.dbUser);
        }
        if (this.dbPswd != null) {
            properties2.put("jrs.db_pswd", this.dbPswd);
        }
        if (this.dbJdbcUrl != null) {
            properties2.put("jrs.jdbc_url", this.dbJdbcUrl);
        }
        if (this.dbJdbcDriver != null) {
            properties2.put("jrs.jdbc_driver", this.dbJdbcDriver);
        }
        if (this.dbGetSupportInfo) {
            properties2.put("jrs.jdbc_get_support_info", "true");
        }
        if (this.cat != null) {
            properties2.put("jrs.catalog", this.cat);
        }
        if (this.rpt != null) {
            properties2.put("jrs.report", this.rpt);
        }
        if (this.lang != null) {
            properties2.put("jrs.rpt_language", this.lang);
        }
        if (this.coun != null) {
            properties2.put("jrs.rpt_country", this.coun);
        }
        if (this.enc != null) {
            properties2.put("jrs.rpt_encoding", this.enc);
        }
        properties2.put("jrs.has_style", String.valueOf(this.hasStyle));
        if (this.styleGroup != null) {
            properties2.put("jrs.style_group", this.styleGroup);
        }
        properties2.put("jrs.has_convert_enc", String.valueOf(this.hasConvertEncoding));
        properties2.put("jrs.from_encoding", String.valueOf(this.fromEncoding));
        properties2.put("jrs.to_encoding", String.valueOf(this.toEncoding));
        if (this.rhost != null) {
            properties2.put("jrs.remote_host", this.rhost);
        }
        if (this.eqID != null) {
            properties2.put("jrs.ext_qrybl_id", this.eqID);
        }
        if (this.paramFile != null) {
            properties2.put("jrs.param_file", this.paramFile);
        }
        if (this.paramValues != null) {
            properties2.put("jrs.param_values", this.paramValues);
        }
        if (this.namedWherePortion != null) {
            properties2.put("jrs.named_wp", this.namedWherePortion);
        }
        if (this.wherePortion != null) {
            properties2.put("jrs.wp", this.wherePortion);
        }
        if (this.whereClause != null) {
            properties2.put("jrs.wc", this.whereClause);
        }
        if ((string = this.getEngMsgs()) != null) {
            properties2.put("jrs.engine_message", string);
        }
        if ((string = this.getErrorMsg()) != null) {
            properties2.put("jrs.error", string);
        }
        if (this.userDbConnection != null) {
            properties2.put("jrs.jdbc_connection_object", this.userDbConnection);
        }
        if (this.getSubmitTime() != null) {
            properties2.put("jrs.submit_time", String.valueOf(this.getSubmitTime()));
        }
        return properties2;
    }

    public String toString() {
        return super.toString() + "\r\nuser=" + this.uid + "\r\nremote host=" + this.rhost + "\r\nJRExternalQueryRunner=" + this.eqID + "\r\ntask name=" + this.taskName + "\r\ncatalog=" + this.cat + "\r\nreport=" + this.rpt + "\r\nreport language=" + this.lang + "\r\nreport country=" + this.coun + "\r\nreport encoding=" + this.enc + "\r\nreport encoding before converting=" + this.fromEncoding + "\r\nreport encoding after converting=" + this.toEncoding + "\r\nreport style group=" + this.styleGroup + "\r\nparameter file=" + this.paramFile + "\r\nstring of parameter values=" + this.paramValues + "\r\nwhere clause=" + this.whereClause + "\r\nnamed where portion=" + this.namedWherePortion + "\r\nwhere portion=" + this.wherePortion + "\r\ndbJdbcUrl=" + this.dbJdbcUrl + "\r\ndbJdbcDriver=" + this.dbJdbcDriver + "\r\ndbGetSupportInfo=" + this.dbGetSupportInfo + "\r\nuserDbConnection=" + this.userDbConnection;
    }

    public void stopExec() {
        this.stopExec(false);
    }

    public synchronized void stopExec(boolean bl) {
        int n;
        this.hasStopped = true;
        if (this.S != null) {
            n = 0;
            while (n < this.S.length) {
                this.S[n].stopExec(bl);
                ++n;
            }
        }
        if (this.A != null) {
            n = 0;
            while (n < this.A.length) {
                if (this.A[n].isAlive()) {
                    this.A[n].stop();
                }
                ++n;
            }
        }
        if (this.engineContext != null) {
            try {
                this.engineContext.engineExit(true, !bl);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            ServiceLogger.logDebug(6600005, this.engineContext, 6);
        }
        this.getJRTaskManager().addFailedTaskToMonitor(this.getSequenceID(), this.getId(), "The task has been stoped!");
    }

    public void createEngineContext() throws TooManyReportsException {
        this.createEngineContext(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createEngineContext(boolean bl) throws TooManyReportsException {
        boolean bl2 = bl;
        ClusterService clusterService = this.getJRTaskManager().getClusterService();
        Member member = null;
        if (clusterService == null || !ServerEnv.isLoadBalance()) {
            bl2 = true;
        } else if (clusterService != null) {
            member = clusterService.getLocalMember();
        }
        boolean bl3 = false;
        if (clusterService != null) {
            bl3 = this.LINE(clusterService);
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        if (!bl2) {
            Member[] memberArray;
            if (!this.hasPreferredServer || !bl3) {
                memberArray = clusterService.getMember();
                if (memberArray == null) throw new TooManyReportsException(600021, (Object[])new String[]{String.valueOf(JRTask.getMaxReports())}, null);
                string = memberArray.getServerName();
                string2 = memberArray.getHost();
                string3 = memberArray.getPort();
                bl2 = memberArray.equals(member);
            } else {
                try {
                    memberArray = clusterService.getAllMembers();
                    int n = memberArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        if (memberArray[n2].getServerName().equalsIgnoreCase(this.preferredServerName)) {
                            Member member2 = memberArray[n2];
                            string = member2.getServerName();
                            string2 = member2.getHost();
                            string3 = member2.getPort();
                            bl2 = member2.equals(member);
                            this.hasPreferredServer = false;
                            break;
                        }
                        ++n2;
                    }
                }
                catch (ClusterException clusterException) {
                    ServiceLogger.logError(clusterException);
                }
            }
        } else {
            if (member != null) {
                string = member.getServerName();
                string2 = member.getHost();
                string3 = member.getPort();
            } else {
                string = "local";
            }
            if (string2 == null || string2.trim().length() == 0) {
                string2 = ServerEnv.getLocalHostName();
            }
            if (string3 == null || string3.trim().length() == 0) {
                string3 = String.valueOf(ServerEnv.getActiveRMIPort());
            }
        }
        if (bl2 && !this.getJRTaskManager().canRunReport()) {
            throw new TooManyReportsException(600021, (Object[])new String[]{String.valueOf(JRTask.getMaxReports())}, null);
        }
        ServiceLogger.logEngine(6600006, new Object[]{this.engineContext, string, string2, string3}, 6);
        this.engMsgs = this.engMsgs == null ? string : this.engMsgs + " | " + string;
        this.runName = string2;
        this.runPort = string3;
        this.getJRTaskManager().notifyAddRunPort(this.getTaskID(), this.runPort, this.runName);
        try {
            this._createEngineContext(bl2, string2, string3);
            return;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            if (this.canRunReport++ < 2) {
                this.createEngineContext(bl);
                return;
            }
            if (this.canRunReport != 2) return;
            this.createEngineContext(true);
        }
    }

    protected void _createEngineContext(boolean bl, String string, String string2) throws Exception {
        String string3 = null;
        String string4 = null;
        if (bl) {
            this.manager = this.getJRTaskManager().getEngineManager();
            if (!this.getIsSubBurstingTask() || this.getIsLocalSubTask() || this.getIsNonBurstingResult()) {
                this.engineContext = this.manager.createEngineContext();
            } else {
                string3 = this.getMainEngine().getHost();
                string4 = this.getMainEngine().getPort();
                this.engineContext = this.manager.createEngineContext(string3, string4);
            }
        } else {
            ClusterService clusterService = this.getJRTaskManager().getClusterService();
            this.manager = (EngineManager)RemoteObjectFactory.getRemoteObject(string, Integer.parseInt(string2), "EngineManager");
            string3 = clusterService.getLocalMember().getHost();
            string4 = clusterService.getLocalMember().getPort();
            this.engineContext = this.manager.createEngineContext(string3, string4);
        }
    }

    private boolean LINE(ClusterService clusterService) {
        block5: {
            try {
                Member[] memberArray = clusterService.getAllMembers();
                int n = memberArray.length;
                if (this.preferredServerName != null) {
                    int n2 = 0;
                    while (n2 < n) {
                        if (this.preferredServerName.equals(memberArray[n2].getServerName())) {
                            return true;
                        }
                        ++n2;
                    }
                    break block5;
                }
                return false;
            }
            catch (ClusterException clusterException) {
                ServiceLogger.logError(clusterException);
            }
        }
        return false;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public static String filterReportScript(Hashtable hashtable, boolean bl) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        Vector<String> vector = new Vector<String>();
        CSUtil.appendScript(vector, hashtable, "jrs.report", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.rpt_version", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.catalog", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.cat_version", true, bl);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!(k instanceof String) || !(string = (String)k).startsWith("jrs.param$")) continue;
            CSUtil.appendScript(vector, hashtable, string, true, bl);
        }
        CSUtil.appendScript(vector, hashtable, "jrs.param_values", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.has_style", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.style_group", true, bl);
        boolean bl2 = CSUtil.getBoolean((String)CSUtil.getHashtableValue(hashtable, "jrs.has_convert_enc", bl), false);
        string = (String)CSUtil.getHashtableValue(hashtable, "jrs.from_encoding", bl);
        String string2 = (String)CSUtil.getHashtableValue(hashtable, "jrs.to_encoding", bl);
        if (bl2) {
            vector.add("jrs.has_convert_enc=" + String.valueOf(bl2));
            vector.add("jrs.from_encoding=" + string);
            vector.add("jrs.to_encoding=" + string2);
        }
        CSUtil.appendScript(vector, hashtable, "jrs.rpt_encoding", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.rpt_language", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.rpt_country", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.use_def_db_user", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.db_user", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.db_pswd", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.jdbc_url", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.jdbc_driver", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.jdbc_get_support_info", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.jdbc_connection_object", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.remote_host", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.named_wp", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.wp", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.wc", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.engine_message", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.error", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.path", true, bl);
        int n = 0;
        while (n < vector.size()) {
            stringBuffer.append((String)vector.get(n)).append(CSUtil.LINE);
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getRealCat() throws Exception {
        if (this._cat == null && this.cat != null) {
            this._cat = JRTUtil.getRealPath(this.uid, this.cat, this.getJRTaskManager().getResourceManager());
        }
        return this._cat;
    }

    public String getRealRpt() throws Exception {
        if (this._rpt == null) {
            this._rpt = JRTUtil.getRealPath(this.uid, this.rpt, this.getJRTaskManager().getResourceManager());
        }
        return this._rpt;
    }

    public void setMutilDataSourceConn() throws Exception {
        ServiceLogger.logDebug(6600167, 6);
        Enumeration enumeration = this.dsInfos.keys();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = true;
        String string6 = null;
        Properties properties = null;
        while (enumeration.hasMoreElements()) {
            string6 = (String)enumeration.nextElement();
            properties = CSUtil.parseQuery(HttpUtil.decodeEsc((String)this.dsInfos.get(string6)));
            String string7 = (String)properties.get("jrs.use_def_ds_pswd");
            bl = CSUtil.getBoolean(string7, true);
            string = (String)properties.get("jrs.ds_user");
            string2 = (String)properties.get("jrs.ds_pswd");
            boolean bl2 = CSUtil.getBoolean((String)properties.get("jrs.use_new_ds_pswd"), false);
            if (bl2) {
                string2 = (String)properties.get("jrs.new_ds_pswd");
            }
            string3 = (String)properties.get("jrs.jndi_datasource");
            string4 = (String)properties.get("jrs._ds_url");
            string5 = (String)properties.get("jrs._ds_driver");
            Object var12_12 = null;
            if (string6.equals("default") || string6.equals("Data Source 1")) {
                string6 = "";
            }
            if (bl) {
                String[] stringArray;
                String[] stringArray2 = stringArray = this.getRealCat() != null ? JREngine.getUserInfo((String)this.getRealCat(), (String)string6) : JREngine.getUserInfoByReport((String)this.getReport(), (String)string6);
                if (stringArray != null) {
                    string = stringArray[0];
                    string2 = stringArray[1];
                }
            }
            if (string3 != null) {
                ServiceLogger.logDebug(6600007, new Object[]{this.engineContext, string6, string3}, 6);
                this.engineContext.setJndiConnection(string6, string3, string, string2);
                ServiceLogger.logDebug(6600008, this.engineContext, 6);
                continue;
            }
            if (string4 != null) {
                ServiceLogger.logDebug(6600009, new Object[]{this.engineContext, string6, string4, string5}, 6);
                this.engineContext.setConnection(string6, string4, string5, string, string2);
                ServiceLogger.logDebug(6600008, this.engineContext, 6);
                continue;
            }
            if (bl) continue;
            ServiceLogger.logDebug(6600010, new Object[]{this.engineContext, string6}, 6);
            this.engineContext.setConnection(string6, string, string2);
            ServiceLogger.logDebug(6600011, this.engineContext, 6);
        }
    }

    public RunningReportSheets getRunningReportSheets() {
        return this.runningRptSheets;
    }

    public String getCurrentReport() {
        return this.currentReport;
    }

    private void _createEngineContext(Properties properties) {
        this.runningRptSheets = new RunningReportSheets(properties);
        this.hasCheckedSheets = this.runningRptSheets.hasReportSheets();
    }

    protected int getPrecision(int n, String string) {
        int n2 = 0;
        if (n == 0 || n == 8) {
            n2 = CSUtil.parseInt(string, 0);
        }
        switch (n2) {
            case 1: 
            case 2: {
                return n2;
            }
        }
        return this.addFailedTaskToMonitor.getPrecision(n);
    }

    public static int counPermission(boolean bl, int n, int n2, int n3, int n4) {
        int n5 = 0;
        if (bl) {
            if (n == 1) {
                n = 4;
            } else if (n == 2) {
                n = 2052;
            }
            if (n2 == 1) {
                n2 = 1024;
            } else if (n2 == 2) {
                n2 = 256;
            } else if (n2 == 3) {
                n2 = 32;
            } else if (n2 == 4) {
                n2 = 40;
            }
            if (n3 == 1 && n4 == 0) {
                n5 = n == 0 && n2 == 0 ? 16 : (n == 0 ? n2 | 0x10 : (n2 == 0 ? n | 0x10 : n | n2 | 0x10));
            } else if (n3 == 0 && n4 == 1) {
                n5 = n == 0 && n2 == 0 ? 512 : (n == 0 ? n2 | 0x200 : (n2 == 0 ? n | 0x200 : n | n2 | 0x200));
            } else if (n3 == 0 && n4 == 0) {
                n5 = n == 0 && n2 == 0 ? 0 : (n == 0 ? n2 : (n2 == 0 ? n : n | n2));
            } else if (n3 == 1 && n4 == 1) {
                n5 = n == 0 && n2 == 0 ? 528 : (n == 0 ? n2 | 0x10 | 0x200 : (n2 == 0 ? n | 0x10 | 0x200 : n | n2 | 0x10 | 0x200));
            }
        } else {
            if (n == 1) {
                n = 4;
            }
            if (n2 == 2) {
                n2 = 8;
            } else if (n2 == 3) {
                n2 = 32;
            } else if (n2 == 4) {
                n2 = 40;
            }
            n5 = n3 == 1 ? (n == 0 && n2 == 0 ? 16 : (n == 0 ? n2 | 0x10 : (n2 == 0 ? n | 0x10 : n | n2 | 0x10))) : (n == 0 && n2 == 0 ? 0 : (n == 0 ? n2 : (n2 == 0 ? n : n | n2)));
        }
        return n5;
    }

    public EngineContext getMainEngine() {
        return this.createEngineContext;
    }

    public boolean getIsLocalSubTask() {
        return this.createParamFile;
    }

    public boolean getIsSubBurstingTask() {
        return this.createTempFile;
    }

    public void setIsSubBurstingTask(boolean bl) {
        this.createTempFile = bl;
    }

    public void setIsLocalSubTask(boolean bl) {
        this.createParamFile = bl;
    }

    public void setMainEngine(EngineContext engineContext) {
        this.createEngineContext = engineContext;
    }

    public boolean getIsNonBurstingResult() {
        return this.currentTimeMillis;
    }

    public void setIsNonBurstingResult(boolean bl) {
        this.currentTimeMillis = bl;
    }

    public MultiBurstingExecutor getBurstingExecutor() {
        return this.engineExit;
    }

    public void setBurstingExecutor(MultiBurstingExecutor multiBurstingExecutor) {
        this.engineExit = multiBurstingExecutor;
    }
}

