/*
 * Decompiled with CFR 0.152.
 */
package jet.server.servlets;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import jet.JCliResource;
import jet.JSvrResource;
import jet.cs.CSUtil;
import jet.cs.util.APIUtil;
import jet.server.api.BurstingSchemaInfo;
import jet.server.api.ExportedFileList;
import jet.server.api.PathInfo;
import jet.server.api.ReportInfo;
import jet.server.api.ReportSheetInfo;
import jet.server.api.RptServerException;
import jet.server.api.TooManyReportsException;
import jet.server.api.http.HttpUtil;
import jet.server.jrc.resource.PathInfoImpl;
import jet.server.jrserver.JRRptServer;
import jet.server.jrserver.http.JRStringBufferPrintWriter;
import jet.server.log.ServiceLogger;
import jet.server.schedule.JRServerEnv;
import jet.server.schedule.SchdTools;
import jet.server.schedule.jrtasks.JRTUtil;
import jet.server.schedule.jrtasks.ReportInfoCache;
import jet.server.servlets.JRServlet;
import jet.server.servlets.OperationBase;
import jet.server.servlets.ServletUtil;

public class ViewerOperation1
extends OperationBase {
    public ViewerOperation1(JRServlet jRServlet) {
        super(jRServlet);
    }

    public void returnNodeInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        File file;
        PathInfo pathInfo = null;
        pathInfo = this.I.getHttpRptServer().getResourceManager().getPathInfo(this.I.getUser(httpServletRequest), this.I.getPathInfo(httpServletRequest));
        httpServletResponse.setStatus(200);
        ServiceLogger.logAccessSuccessEvent(this.I.getHttpRptServer().getResourceManager().getRealm(), this.I.getUser(httpServletRequest), this.I.getSessionId(httpServletRequest), 6680023, pathInfo.getPath(), 6);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.I.getWriter(httpServletResponse);
        PathInfoImpl pathInfoImpl = (PathInfoImpl)pathInfo;
        String string = "jrs.node_name=" + pathInfoImpl.getName() + "&" + "jrs.node_share" + "=" + pathInfoImpl.isShared() + "&" + "jrs.node_type" + "=" + pathInfoImpl.getNodeType() + "&isSelf=" + pathInfoImpl.isSelfContainReport() + "&isDynamic=" + pathInfoImpl.isDynamic();
        boolean bl = false;
        if (pathInfoImpl.isDir() && this.I.getHttpRptServer().getResourceManager().getSubnodes(this.I.getUser(httpServletRequest), pathInfoImpl.getPath()) != null) {
            bl = true;
        }
        string = string + "&hasSubnodes=" + bl;
        String string2 = pathInfoImpl.getRealPath();
        long l = 0L;
        if (string2 != null && (file = new File(string2)).exists()) {
            l = file.lastModified();
        }
        string = string + "&lastModifiedTime=" + l;
        jRStringBufferPrintWriter.print(string);
        jRStringBufferPrintWriter.println("jrs.node_desc=" + pathInfoImpl.getDescription());
        jRStringBufferPrintWriter.close();
    }

    public void returnNodeReferInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string;
        Object object;
        PathInfo pathInfo = null;
        try {
            pathInfo = this.I.getHttpRptServer().getResourceManager().getPathInfo(this.I.getUser(httpServletRequest), this.I.getPathInfo(httpServletRequest));
            object = pathInfo.getRealPath();
            object = object == null || ((String)object).length() == 0 ? "0" : (pathInfo.isDir() ? "1" : (pathInfo.isFile() ? "2" : "0"));
            Vector vector = this.I.getHttpRptServer().getResourceManager().getSubnodes(this.I.getUser(httpServletRequest), this.I.getPathInfo(httpServletRequest));
            string = (String)object + (vector == null || vector.size() == 0 ? "0" : "1");
        }
        catch (RptServerException rptServerException) {
            string = "/?e?/" + rptServerException.getMessage();
        }
        httpServletResponse.setStatus(200);
        object = this.I.getWriter(httpServletResponse);
        ((JRStringBufferPrintWriter)object).println(string);
        ((JRStringBufferPrintWriter)object).close();
        ServiceLogger.logAccessSuccessEvent(this.I.getHttpRptServer().getResourceManager().getRealm(), this.I.getUser(httpServletRequest), this.I.getSessionId(httpServletRequest), 6680024, string, 6);
    }

    public void returnSubFileDirs(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        Vector vector = null;
        String string = null;
        String string2 = this.I.getPathInfo(httpServletRequest);
        String string3 = this.I.getUser(httpServletRequest);
        try {
            vector = this.I.getHttpRptServer().getResourceManager().getSubpaths(string3, string2);
        }
        catch (RptServerException rptServerException) {
            string = rptServerException.getMessage();
        }
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.I.getWriter(httpServletResponse);
        if (string != null) {
            jRStringBufferPrintWriter.print("/?e?/");
            jRStringBufferPrintWriter.print(string);
            jRStringBufferPrintWriter.println();
        } else {
            PathInfo pathInfo = null;
            int n = vector == null ? 0 : vector.size();
            jRStringBufferPrintWriter.println(n);
            int n2 = 0;
            while (n2 < n) {
                Vector vector2;
                pathInfo = (PathInfo)vector.elementAt(n2);
                boolean bl = false;
                if (pathInfo.isDir() && (vector2 = this.I.getHttpRptServer().getResourceManager().getSubpaths(string3, pathInfo.getPath())) != null && vector2.size() > 0) {
                    bl = true;
                }
                jRStringBufferPrintWriter.print(pathInfo.getName() + (char)(pathInfo.isFile() ? 50 : (pathInfo.isDir() ? 49 : 48)) + (bl ? (char)'1' : '0'));
                jRStringBufferPrintWriter.println();
                ++n2;
            }
        }
        jRStringBufferPrintWriter.close();
    }

    public void returnRealPath(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = null;
        String string2 = null;
        PathInfo pathInfo = null;
        try {
            pathInfo = this.I.getHttpRptServer().getResourceManager().getPathInfo(this.I.getUser(httpServletRequest), this.I.getPathInfo(httpServletRequest));
            string2 = pathInfo.getRealPath();
        }
        catch (RptServerException rptServerException) {
            string = rptServerException.getMessage();
        }
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.I.getWriter(httpServletResponse);
        if (string != null) {
            jRStringBufferPrintWriter.print("/?e?/");
            jRStringBufferPrintWriter.print(string);
            jRStringBufferPrintWriter.println();
        } else {
            if (string2 != null && string2.length() > 0) {
                jRStringBufferPrintWriter.print(string2);
            }
            jRStringBufferPrintWriter.println();
        }
        jRStringBufferPrintWriter.close();
    }

    public void returnRptParams(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        ServiceLogger.logDebug("ViewerOperation1.returnRptParams: ht=" + hashtable);
        String string = this.I.checkCatRpt(httpServletRequest, httpServletResponse, hashtable);
        if (string != null) {
            this.I.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, string, hashtable);
            return;
        }
        String string2 = (String)hashtable.get("jrs.report");
        String string3 = (String)hashtable.get("jrs.catalog");
        String string4 = (String)hashtable.get("jrs.cat_version");
        String string5 = (String)hashtable.get("jrs.rpt_version");
        int n = string4 == null ? this.I.getHttpRptServer().getResourceManager().getLatestVersionNumber(string3) : CSUtil.parseInt(string4);
        int n2 = string5 == null ? this.I.getHttpRptServer().getResourceManager().getLatestVersionNumber(string2) : CSUtil.parseInt(string5);
        String string6 = this.I.getUser(httpServletRequest);
        ReportInfo reportInfo = null;
        reportInfo = hashtable.get("jrs.jdbc_driver") != null ? this.I.getHttpRptServer().getReportInfo(string6, string3, n, string2, n2, (Properties)hashtable) : this.I.getHttpRptServer().getReportInfo(string6, string3, n, string2, n2);
        Vector vector = reportInfo.getParamInfos(2);
        String string7 = JRTUtil.getParamsString(vector, reportInfo.getAvailableGroupFields(), reportInfo.getOrderOfParams(), true);
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.I.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        if (string7.length() > 0) {
            jRStringBufferPrintWriter.print(string7);
        }
        jRStringBufferPrintWriter.println();
        jRStringBufferPrintWriter.close();
    }

    public void returnBooleanNames(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string;
        String string2 = this.I.checkCatRpt(httpServletRequest, httpServletResponse, hashtable);
        if (string2 != null) {
            this.I.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, string2, hashtable);
            return;
        }
        String string3 = (String)hashtable.get("jrs.report");
        String string4 = (String)hashtable.get("jrs.catalog");
        String string5 = (String)hashtable.get("jrs.cat_version");
        String string6 = (String)hashtable.get("jrs.rpt_version");
        int n = string5 == null ? this.I.getHttpRptServer().getResourceManager().getLatestVersionNumber(string4) : CSUtil.parseInt(string5);
        int n2 = string6 == null ? this.I.getHttpRptServer().getResourceManager().getLatestVersionNumber(string3) : CSUtil.parseInt(string6);
        Vector vector = this.I.getHttpRptServer().getReportInfo(this.I.getUser(httpServletRequest), string4, n, string3, n2).getBooleanColumns();
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.I.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        if (vector != null && (string = APIUtil.VectorToURLEncodedString(vector)) != null && string.length() > 0) {
            jRStringBufferPrintWriter.println(string);
        }
        jRStringBufferPrintWriter.close();
    }

    public void returnAvailableLanguages(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string;
        String string2;
        String string3 = this.I.checkCatRpt(httpServletRequest, httpServletResponse, hashtable);
        if (string3 != null) {
            this.I.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, string3, hashtable);
            return;
        }
        String string4 = (String)hashtable.get("jrs.report");
        if (string4 != null) {
            string4 = HttpUtil.decodeEsc(string4);
        }
        if ((string2 = (String)hashtable.get("jrs.catalog")) != null) {
            string2 = HttpUtil.decodeEsc(string2);
        }
        String string5 = this.I.getUser(httpServletRequest);
        String string6 = (String)hashtable.get("jrs.cat_version");
        String string7 = (String)hashtable.get("jrs.rpt_version");
        int n = string6 == null ? this.I.getHttpRptServer().getResourceManager().getLatestVersionNumber(string2) : CSUtil.parseInt(string6);
        int n2 = string7 == null ? this.I.getHttpRptServer().getResourceManager().getLatestVersionNumber(string4) : CSUtil.parseInt(string7);
        Vector vector = this.I.getHttpRptServer().getReportInfo(string5, string2, n, string4, n2).getAvailableLanguages();
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.I.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        if (vector != null && vector.size() > 0 && (string = APIUtil.VectorToURLEncodedString(vector)) != null && string.length() > 0) {
            jRStringBufferPrintWriter.println(string);
        }
        jRStringBufferPrintWriter.close();
    }

    public void returnRptStyleGroups(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string;
        String string2;
        String string3 = this.I.checkCatRpt(httpServletRequest, httpServletResponse, hashtable);
        if (string3 != null) {
            this.I.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, string3, hashtable);
            return;
        }
        String string4 = (String)hashtable.get("jrs.report");
        if (string4 != null) {
            string4 = HttpUtil.decodeEsc(string4);
        }
        if ((string2 = (String)hashtable.get("jrs.catalog")) != null) {
            string2 = HttpUtil.decodeEsc(string2);
        }
        String string5 = (String)hashtable.get("jrs.cat_version");
        String string6 = (String)hashtable.get("jrs.rpt_version");
        int n = string5 == null ? this.I.getHttpRptServer().getResourceManager().getLatestVersionNumber(string2) : CSUtil.parseInt(string5);
        int n2 = string6 == null ? this.I.getHttpRptServer().getResourceManager().getLatestVersionNumber(string4) : CSUtil.parseInt(string6);
        String string7 = (String)hashtable.get("jrs.uid");
        Vector vector = this.I.getHttpRptServer().getReportInfo(string7, string2, n, string4, n2).getStyleGroupInfos();
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.I.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        if (vector != null && vector.size() > 0 && (string = APIUtil.VectorToURLEncodedString(vector)) != null && string.length() > 0) {
            jRStringBufferPrintWriter.println(string);
        }
        jRStringBufferPrintWriter.close();
    }

    public void returnRptSheets(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string;
        String string2 = this.I.checkCatRpt(httpServletRequest, httpServletResponse, hashtable);
        if (string2 != null) {
            this.I.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, string2, hashtable);
            return;
        }
        String string3 = (String)hashtable.get("jrs.report");
        if (string3 != null) {
            string3 = HttpUtil.decodeEsc(string3);
        }
        if ((string = (String)hashtable.get("jrs.catalog")) != null) {
            string = HttpUtil.decodeEsc(string);
        }
        String string4 = (String)hashtable.get("jrs.cat_version");
        String string5 = (String)hashtable.get("jrs.rpt_version");
        int n = string4 == null ? this.I.getHttpRptServer().getResourceManager().getLatestVersionNumber(string) : CSUtil.parseInt(string4);
        int n2 = string5 == null ? this.I.getHttpRptServer().getResourceManager().getLatestVersionNumber(string3) : CSUtil.parseInt(string5);
        String string6 = (String)hashtable.get("jrs.uid");
        Vector vector = this.I.getHttpRptServer().getReportInfo(string6, string, n, string3, n2).getReportSheetInfos();
        String string7 = JRTUtil.getReportSheetsString(vector);
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.I.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        if (string7.length() > 0) {
            jRStringBufferPrintWriter.print(string7);
        }
        jRStringBufferPrintWriter.println();
        jRStringBufferPrintWriter.close();
    }

    public void returnRptSheetsFromRst(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = this.I.checkCatRpt(httpServletRequest, httpServletResponse, hashtable);
        if (string != null) {
            this.I.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, string, hashtable);
            return;
        }
        String string2 = (String)hashtable.get("jrs.file");
        string2 = this.I.getHttpRptServer().getResourceManager().getHistDir() + string2;
        Vector vector = this.I.getHttpRptServer().getRstResultInfo(string2).getReportSheetInfos();
        String string3 = JRTUtil.getReportSheetsString(vector);
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.I.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        if (string3.length() > 0) {
            jRStringBufferPrintWriter.print(string3);
        }
        jRStringBufferPrintWriter.println();
        jRStringBufferPrintWriter.close();
    }

    public void returnCatReportLstNew(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = HttpUtil.getUser(httpServletRequest);
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.I.getWriter(httpServletResponse);
        String string2 = (String)hashtable.get("jrs.path");
        if (string2 == null) {
            string2 = this.I.getPathInfo(httpServletRequest).trim();
        }
        if (string2 != null) {
            string2 = HttpUtil.decodeEsc(string2);
        }
        Object var7_7 = null;
        Vector vector = this.I.getHttpRptServer().getResourceManager().getSubnodes(string, string2);
        int n = vector.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            PathInfoImpl pathInfoImpl = (PathInfoImpl)vector.get(n2);
            if (pathInfoImpl.isAdhocReport()) {
                vector.removeElementAt(n2);
            }
            --n2;
        }
        n = vector.size();
        jRStringBufferPrintWriter.println(new Integer(n).toString());
        int n3 = 0;
        while (n3 < n) {
            File file;
            PathInfoImpl pathInfoImpl = (PathInfoImpl)vector.get(n3);
            String string3 = "jrs.node_name=" + CSUtil.escapeURLPath(pathInfoImpl.getName()) + "&" + "jrs.node_share" + "=" + pathInfoImpl.isShared() + "&" + "jrs.node_type" + "=" + pathInfoImpl.getNodeType() + "&isSelf=" + pathInfoImpl.isSelfContainReport();
            boolean bl = false;
            if (pathInfoImpl.isDir() && this.I.getHttpRptServer().getResourceManager().getSubnodes(string, pathInfoImpl.getPath()) != null) {
                bl = true;
            }
            string3 = string3 + "&hasSubnodes=" + bl;
            String string4 = pathInfoImpl.getRealPath();
            long l = 0L;
            if (string4 != null && (file = new File(string4)).exists()) {
                l = file.lastModified();
            }
            string3 = string3 + "&lastModifiedTime=" + l;
            jRStringBufferPrintWriter.println(string3);
            jRStringBufferPrintWriter.println("jrs.node_desc=" + pathInfoImpl.getDescription());
            ++n3;
        }
        httpServletResponse.setStatus(200);
        jRStringBufferPrintWriter.close();
    }

    public void returnRemovedPath(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = this.I.getPathInfo(httpServletRequest);
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.I.getWriter(httpServletResponse);
        jRStringBufferPrintWriter.println(0);
        jRStringBufferPrintWriter.println(string);
        jRStringBufferPrintWriter.close();
    }

    public void returnServletPath(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        httpServletResponse.setStatus(200);
        String string = HttpUtil.getServletPath(httpServletRequest);
        if (string.length() > 0) {
            httpServletResponse.setContentLength(string.length() + 2);
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            servletOutputStream.print(string + "\r\n");
            servletOutputStream.close();
        }
    }

    public void responseGetTempResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        this.I.getServletOperation().responseTempResult(httpServletRequest, httpServletResponse, hashtable, (String)hashtable.get("jrs.file"), false);
    }

    public void responseWaitTempResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        this.I.getServletOperation().responseTempResult(httpServletRequest, httpServletResponse, hashtable, (String)hashtable.get("jrs.file"), true);
    }

    public void testTempResultReady(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = (String)hashtable.get("jrs.file");
        if (this.I.getServletOperation().testTempResultReady(string)) {
            this.I.getServletOperation().sendError(httpServletRequest, httpServletResponse, 200, JSvrResource.getMessage("SLT_ERR_42") + "!", hashtable);
        } else {
            this.I.getServletOperation().sendError(httpServletRequest, httpServletResponse, 202, JSvrResource.getMessage("SLT_ERR_44", string), hashtable);
        }
    }

    public void responseRemoveTempResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = (String)hashtable.get("jrs.file");
        String string2 = (String)hashtable.get("jrs.html_temp_dir");
        String string3 = (String)hashtable.get("jrs.pdf_temp_dir");
        String string4 = (String)hashtable.get("jrs.rtf_temp_dir");
        String string5 = (String)hashtable.get("jrs.xml_temp_dir");
        this.I.getHttpRptServer().getTempResultOwnerManager().removeOwner(this.I.getUser(httpServletRequest), ServletUtil.getTempResultKey(string));
        if (string != null) {
            try {
                File file;
                if (string2 != null) {
                    SchdTools.deleteFile(this.I.getTempDir() + string2 + File.separator, string);
                    file = new File(this.I.getTempDir() + string2);
                    file.delete();
                }
                if (string3 != null) {
                    SchdTools.deleteFile(this.I.getTempDir() + string3 + File.separator, string);
                    file = new File(this.I.getTempDir() + string3);
                    file.delete();
                }
                if (string4 != null) {
                    SchdTools.deleteFile(this.I.getTempDir() + string4 + File.separator, string);
                    file = new File(this.I.getTempDir() + string4);
                    file.delete();
                }
                if (string5 != null) {
                    SchdTools.deleteFile(this.I.getTempDir() + string5 + File.separator, string);
                    file = new File(this.I.getTempDir() + string5);
                    file.delete();
                } else {
                    SchdTools.deleteFile(this.I.getTempDir(), string);
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        this.I.getServletOperation().sendError(httpServletRequest, httpServletResponse, 200, JSvrResource.getMessage("SLT_ERR_42") + "!", hashtable);
    }

    public void responseVerResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = (String)hashtable.get("jrs.file");
        if (string == null) {
            this.I.getServletOperation().sendError(httpServletRequest, httpServletResponse, 404, JSvrResource.getMessage("SLT_ERR_43"), hashtable);
            return;
        }
        String string2 = this.I.getHistFile(string);
        boolean bl = JRRptServer.hasPageSecurity(string2);
        if (bl) {
            this.I.getServletOperation().sendError(httpServletRequest, httpServletResponse, 500, JCliResource.getMessage("CS_MSG_140"), hashtable);
            return;
        }
        File file = new File(string2);
        if (!file.exists()) {
            this.I.getServletOperation().sendError(httpServletRequest, httpServletResponse, 404, JSvrResource.getMessage("SLT_ERR_29", string), hashtable);
            return;
        }
        HttpUtil.processPartialRequest(httpServletRequest, httpServletResponse, file, hashtable);
    }

    public void runAndView(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Properties properties) throws TooManyReportsException, Exception {
        ServiceLogger.logDebug("ViewerOperation1.runAndView: ht=" + properties);
        String string = this.I.checkCatRpt(httpServletRequest, httpServletResponse, properties);
        if (string != null) {
            this.I.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, string, (Hashtable)properties);
            return;
        }
        String string2 = (String)properties.get("jrs.catalog");
        String string3 = (String)properties.get("jrs.report");
        String string4 = this.I.getUser(httpServletRequest);
        properties.put("jrs.catalog", string2);
        properties.put("jrs.report", string3);
        String string5 = JRServlet.getRemoteHost(httpServletRequest);
        if (string5 != null) {
            properties.put("jrs.remote_host", string5);
        }
        properties.put("jrs.remote_addr", httpServletRequest.getRemoteAddr());
        properties.put("jrs.request_url", HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString());
        Hashtable[] hashtableArray = new Hashtable[3];
        if (APIUtil.getBoolean((String)properties.get("jrs.define_permission"), false)) {
            hashtableArray[0] = CSUtil.parseQuery((String)properties.get("jrs.user_permission"));
            hashtableArray[1] = CSUtil.parseQuery((String)properties.get("jrs.role_permission"));
            hashtableArray[2] = CSUtil.parseQuery((String)properties.get("jrs.group_permission"));
        }
        properties.put("jrs.permission_values", hashtableArray);
        String string6 = this.I.getHttpRptServer().runReportNotWaitResult(string4, string2, string3, properties);
        if (string6 == null) {
            this.I.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, httpServletRequest.getRequestURI() + "?" + httpServletRequest.getQueryString(), (Hashtable)properties);
            return;
        }
        File file = new File(string6);
        this.I.getHttpRptServer().getTempResultOwnerManager().registerOwner(string4, ServletUtil.getTempResultKey(file.getName()));
        this.returnResultName(httpServletRequest, httpServletResponse, string6);
        ServiceLogger.logAccessSuccessEvent(this.I.getHttpRptServer().getResourceManager().getRealm(), this.I.getUser(httpServletRequest), this.I.getSessionId(httpServletRequest), 5680025, new Object[]{string2, string3, string6}, 5);
    }

    public void returnResultName(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        String string2 = new File(string).getName();
        if (string2 != null && string != null) {
            ServletUtil.realPathTempHashtable.put(string2, string);
        }
        String string3 = "Content-Location" + string2 + "\r\n";
        httpServletResponse.setStatus(200);
        httpServletResponse.setHeader("Content-Location", string2);
        httpServletResponse.setContentLength(string3.length());
        httpServletResponse.getOutputStream().print(string3);
    }

    public void responseExportResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Properties properties) throws Throwable {
        String string;
        File file = null;
        String string2 = this.I.getUser(httpServletRequest);
        String string3 = (String)properties.get("jrs.file");
        if (string3 != null) {
            file = new File(string3);
        } else {
            string3 = (String)properties.get("jrs.temp_file");
            if (string3 != null) {
                string = string3;
                if (!APIUtil.getBoolean((String)properties.get("jrs.check_fullname"), false)) {
                    string = ServletUtil.getTempResultKey(string3);
                }
                if (!this.I.getHttpRptServer().getTempResultOwnerManager().isOwner(string2, string)) {
                    this.I.getServletOperation().sendError(httpServletRequest, httpServletResponse, 403, JSvrResource.getMessage("SLT_ERR_56", string3), (Hashtable)properties);
                    return;
                }
                file = new File(this.I.getTempDir() + string3);
            } else {
                string3 = (String)properties.get("jrs.hist_file");
                if (string3 != null) {
                    file = new File(this.I.getHistFile(string3));
                }
            }
        }
        if (file == null || !file.exists()) {
            this.I.getServletOperation().sendError(httpServletRequest, httpServletResponse, 404, this.I.getBase(httpServletRequest, true), (Hashtable)properties);
            return;
        }
        string3 = this.I.getUser(httpServletRequest);
        if (string3 != null) {
            properties.put("jrs.uid", string3);
        }
        if ((string = JRServlet.getRemoteHost(httpServletRequest)) != null) {
            properties.put("jrs.remote_host", string);
        }
        properties.put("jrs.remote_addr", httpServletRequest.getRemoteAddr());
        properties.put("jrs.request_url", HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString());
        properties.put("exportResultInAType", String.valueOf("true"));
        ExportedFileList exportedFileList = this.I.getHttpRptServer().exportResult(string2, file.getCanonicalPath(), properties);
        if (exportedFileList != null) {
            int n;
            int n2;
            Vector vector;
            string3 = exportedFileList.getRSTFilename();
            if (string3 != null) {
                this.I.getHttpRptServer().getTempResultOwnerManager().registerOwner(string2, ServletUtil.getTempResultKey(new File(string3).getName()));
            }
            if ((vector = exportedFileList.getHTMLFilenameList()) != null) {
                n2 = vector.size();
                n = 0;
                while (n < n2) {
                    string3 = (String)vector.elementAt(n);
                    if (string3 != null) {
                        this.I.getHttpRptServer().getTempResultOwnerManager().registerOwner(string2, new File(string3).getName());
                    }
                    ++n;
                }
            }
            if ((vector = exportedFileList.getPDFFilename()) != null) {
                n2 = vector.size();
                n = 0;
                while (n < n2) {
                    string3 = (String)vector.elementAt(n);
                    if (string3 != null) {
                        this.I.getHttpRptServer().getTempResultOwnerManager().registerOwner(string2, new File(string3).getName());
                    }
                    ++n;
                }
            }
            if ((string3 = exportedFileList.getTEXTFilename()) != null) {
                this.I.getHttpRptServer().getTempResultOwnerManager().registerOwner(string2, ServletUtil.getTempResultKey(new File(string3).getName()));
            }
            if ((string3 = exportedFileList.getExcelFilename()) != null) {
                this.I.getHttpRptServer().getTempResultOwnerManager().registerOwner(string2, ServletUtil.getTempResultKey(new File(string3).getName()));
            }
            if ((string3 = exportedFileList.getPSFilename()) != null) {
                this.I.getHttpRptServer().getTempResultOwnerManager().registerOwner(string2, ServletUtil.getTempResultKey(new File(string3).getName()));
            }
            if ((vector = exportedFileList.getRTFFilenameList()) != null) {
                n2 = vector.size();
                n = 0;
                while (n < n2) {
                    string3 = (String)vector.elementAt(n);
                    if (string3 != null) {
                        this.I.getHttpRptServer().getTempResultOwnerManager().registerOwner(string2, new File(string3).getName());
                    }
                    ++n;
                }
            }
            if ((vector = exportedFileList.getXMLFilenameList()) != null) {
                n2 = vector.size();
                n = 0;
                while (n < n2) {
                    string3 = (String)vector.elementAt(n);
                    if (string3 != null) {
                        this.I.getHttpRptServer().getTempResultOwnerManager().registerOwner(string2, new File(string3).getName());
                    }
                    ++n;
                }
            }
            httpServletResponse.setStatus(200);
            JRStringBufferPrintWriter jRStringBufferPrintWriter = this.I.getWriter(httpServletResponse);
            String string4 = exportedFileList.toHttpQueryString();
            jRStringBufferPrintWriter.println(string4);
            jRStringBufferPrintWriter.close();
            ServiceLogger.logAccessSuccessEvent(this.I.getHttpRptServer().getResourceManager().getRealm(), this.I.getUser(httpServletRequest), this.I.getSessionId(httpServletRequest), 6680026, string4, 6);
            return;
        }
        this.I.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, httpServletRequest.getRequestURI(), (Hashtable)properties);
    }

    public void returnFolderFiles(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        CharSequence charSequence;
        String string = this.I.getUser(httpServletRequest);
        String string2 = this.I.getPathInfo(httpServletRequest);
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        vector = this.I.getHttpRptServer().getResourceManager().getSubnodes(string, string2);
        int n = vector.size();
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n) {
            vector2.clear();
            charSequence = new StringBuffer(vector.elementAt(n3).toString());
            PathInfo pathInfo = (PathInfo)vector.elementAt(n3);
            if (!pathInfo.isAdhocReport()) {
                File file;
                int n4;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                while (n7 < 9) {
                    n5 = ((StringBuffer)charSequence).toString().indexOf(",");
                    if (n5 != -1) {
                        vector2.add(((StringBuffer)charSequence).substring(n6, n5).toString().trim());
                        ((StringBuffer)charSequence).delete(n6, n5 + 1);
                        n5 = 0;
                    } else {
                        vector2.add(((StringBuffer)charSequence).toString().trim());
                    }
                    ++n7;
                }
                charSequence = null;
                String string3 = vector2.elementAt(1).toString().trim();
                String string4 = vector2.elementAt(0).toString().trim();
                int n8 = string4.indexOf("=");
                String string5 = string4.substring(n8 + 1, string4.length());
                int n9 = string3.indexOf("=");
                String string6 = string3.substring(n9 + 1, string3.length());
                String string7 = vector2.elementAt(2).toString().trim();
                int n10 = string7.indexOf("=");
                String string8 = string7.substring(n10 + 1, string7.length());
                String string9 = vector2.elementAt(3).toString().trim();
                int n11 = string9.indexOf("=");
                String string10 = string9.substring(n11 + 1, string9.length());
                String string11 = vector2.elementAt(4).toString().trim();
                int n12 = string11.indexOf("=");
                String string12 = string11.substring(n12 + 1, string11.length());
                String string13 = vector2.elementAt(5).toString().trim();
                String string14 = string13.substring((n4 = string13.indexOf("=")) + 1, string13.length());
                if (string14 == null) {
                    string14 = " ";
                }
                boolean bl = pathInfo.isReport();
                boolean bl2 = pathInfo.isResult();
                boolean bl3 = pathInfo.isCatalog();
                boolean bl4 = pathInfo.isDir();
                int n13 = 0;
                if (bl) {
                    n13 = 0;
                } else if (bl2) {
                    n13 = 1;
                } else if (bl3) {
                    n13 = 2;
                } else if (bl4) {
                    n13 = 3;
                }
                String string15 = String.valueOf(n13);
                String string16 = vector2.elementAt(5).toString().trim();
                int n14 = string16.indexOf("=");
                String string17 = string16.substring(n14 + 1, string16.length());
                String string18 = vector2.elementAt(5).toString().trim();
                int n15 = string18.indexOf("=");
                String string19 = string18.substring(n15 + 1, string18.length());
                String string20 = vector2.elementAt(5).toString().trim();
                int n16 = string20.indexOf("=");
                String string21 = string20.substring(n16 + 1, string20.length());
                String string22 = null;
                string22 = string12 != null ? ((file = new File(string12)).exists() ? APIUtil.toWinDateString(new Date(file.lastModified())) : "") : "";
                stringBuffer.append(string6 + "," + string8 + "," + string15 + "," + string14 + "," + string22 + ",");
            } else {
                ++n2;
            }
            ++n3;
        }
        if (n - n2 >= 0) {
            stringBuffer.append(n - n2);
        } else {
            stringBuffer.append(0);
        }
        charSequence = this.I.getHttpRptServer().getResourceManager().getTempDir();
        if (!((String)charSequence).endsWith(File.separator)) {
            charSequence = (String)charSequence + File.separator;
        }
        FileWriter fileWriter = new FileWriter((String)charSequence + string + "folderfiles.txt");
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        bufferedWriter.write(stringBuffer.toString().trim());
        bufferedWriter.flush();
        fileWriter.close();
        File file = new File((String)charSequence + string + "folderfiles.txt");
        httpServletResponse.setContentType("text/plain");
        this.I.getServletOperation().sendFile(httpServletRequest, httpServletResponse, file);
        file.delete();
    }

    public void responseRunTask(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Properties properties) throws Exception {
        String string = this.I.getUser(httpServletRequest);
        properties.put("jrs.uid", string);
        String string2 = JRServlet.getRemoteHost(httpServletRequest);
        if (string2 != null) {
            properties.put("jrs.remote_host", string2);
        }
        properties.put("jrs.remote_addr", httpServletRequest.getRemoteAddr());
        properties.put("jrs.request_url", HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString());
        String string3 = this.I.getHttpRptServer().runTask(string, properties);
        ServiceLogger.logAccessSuccessEvent(this.I.getHttpRptServer().getResourceManager().getRealm(), this.I.getUser(httpServletRequest), this.I.getSessionId(httpServletRequest), 6680027, new Object[]{properties, string3}, 6);
        if (string3 == null) {
            this.I.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, JSvrResource.getMessage("SLT_ERR_61"), (Hashtable)properties);
        } else if (HttpUtil.isClientAPI(httpServletRequest, properties)) {
            httpServletResponse.setStatus(200);
            JRStringBufferPrintWriter jRStringBufferPrintWriter = this.I.getWriter(httpServletResponse);
            jRStringBufferPrintWriter.println(string3);
            jRStringBufferPrintWriter.close();
        } else {
            this.I.getServletOperation().sendError(httpServletRequest, httpServletResponse, 200, JSvrResource.getMessage("SLT_ERR_26", string3), (Hashtable)properties);
        }
    }

    public void responseStopTask(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = (String)hashtable.get("jrs.task_id");
        String string2 = HttpUtil.getUser(httpServletRequest);
        ServiceLogger.logAccessSuccessEvent(this.I.getHttpRptServer().getResourceManager().getRealm(), this.I.getUser(httpServletRequest), this.I.getSessionId(httpServletRequest), 6680028, string, 6);
        if (string == null) {
            this.I.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, JSvrResource.getMessage("SLT_ERR_52"), hashtable);
            return;
        }
        if (!this.I.getHttpRptServer().stopActiveTaskByUser(string, string2)) {
            this.I.getServletOperation().sendError(httpServletRequest, httpServletResponse, 200, JSvrResource.getMessage("SLT_ERR_57", string), hashtable);
            return;
        }
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentLength(0);
    }

    public void returnAllRptParams(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        Object object;
        String string;
        ServiceLogger.logDebug("ViewerOperation1.returnAllRptParams: ht=" + hashtable);
        String string2 = (String)hashtable.get("jrs.param_engineid");
        String string3 = this.I.getUser(httpServletRequest);
        Vector vector = new Vector();
        Vector vector2 = JRTUtil.parseSheetNames(hashtable);
        if (string2 != null) {
            string = (String)hashtable.get("jrs.param_name");
            object = hashtable.get("jrs.param_value");
            String string4 = (String)hashtable.get("_isMultiple_jrs.param_value");
            ReportInfoCache reportInfoCache = ReportInfoCache.getReportInfoCache(string2);
            vector = reportInfoCache == null ? null : (vector2.size() > 0 ? reportInfoCache.paramValueChanged(vector2, string, object) : reportInfoCache.paramValueChanged(0, string, object));
        } else {
            string = this.I.checkCatRpt(httpServletRequest, httpServletResponse, hashtable);
            if (string != null) {
                this.I.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, string, hashtable);
                return;
            }
            object = (String)hashtable.get("jrs.report");
            String string5 = (String)hashtable.get("jrs.catalog");
            String string6 = (String)hashtable.get("jrs.cat_version");
            String string7 = (String)hashtable.get("jrs.rpt_version");
            String string8 = (String)hashtable.get("jrs.param_file");
            int n = string6 == null ? this.I.getHttpRptServer().getResourceManager().getLatestVersionNumber(string5) : CSUtil.parseInt(string6);
            int n2 = string7 == null ? this.I.getHttpRptServer().getResourceManager().getLatestVersionNumber((String)object) : CSUtil.parseInt(string7);
            JRServerEnv jRServerEnv = (JRServerEnv)((Object)this.I.getHttpRptServer().getResourceManager());
            try {
                ReportInfoCache reportInfoCache = ReportInfoCache.getReportInfoCache(string3, string5, n, (String)object, n2, jRServerEnv, hashtable);
                vector = vector2.size() > 0 ? reportInfoCache.getParamDescs(vector2) : reportInfoCache.getParamDescs(0);
                string2 = reportInfoCache.getEngineID();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        if (string2 != null) {
            httpServletResponse.setHeader("jrs.param_engineid", string2);
        }
        string = JRTUtil.getParamsString(vector, null, null, false);
        httpServletResponse.setStatus(200);
        object = this.I.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        if (string.length() > 0) {
            ((JRStringBufferPrintWriter)object).print(string);
        }
        ((JRStringBufferPrintWriter)object).println();
        ((JRStringBufferPrintWriter)object).close();
    }

    public void returnBurstRptParams(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        Object object;
        String string;
        String string2 = (String)hashtable.get("jrs.param_engineid");
        String string3 = this.I.getUser(httpServletRequest);
        Vector vector = new Vector();
        String string4 = null;
        String string5 = null;
        if (string2 != null) {
            string4 = (String)hashtable.get("jrs.param_name");
            string5 = (String)hashtable.get("jrs.param_value");
            string = (String)hashtable.get("jrs.report_sheet");
            object = ReportInfoCache.getReportInfoCache(string2);
            if (object != null) {
                vector = ((ReportInfoCache)object).getParamInfoByValueForRecipient(string, string4, string5);
            }
        } else {
            string = this.I.checkCatRpt(httpServletRequest, httpServletResponse, hashtable);
            if (string != null) {
                this.I.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, string, hashtable);
                return;
            }
            object = (String)hashtable.get("jrs.report");
            String string6 = (String)hashtable.get("jrs.catalog");
            String string7 = (String)hashtable.get("jrs.cat_version");
            String string8 = (String)hashtable.get("jrs.rpt_version");
            String string9 = (String)hashtable.get("jrs.report_sheet");
            Vector<String> vector2 = new Vector<String>();
            String string10 = "jrs.bursting_schema$";
            Iterator iterator = hashtable.keySet().iterator();
            while (iterator.hasNext()) {
                String string11 = (String)iterator.next();
                if (!string11.startsWith(string10)) continue;
                vector2.add(string11.substring(string10.length()));
            }
            int n = string7 == null ? this.I.getHttpRptServer().getResourceManager().getLatestVersionNumber(string6) : CSUtil.parseInt(string7);
            int n2 = string8 == null ? this.I.getHttpRptServer().getResourceManager().getLatestVersionNumber((String)object) : CSUtil.parseInt(string8);
            ReportInfo reportInfo = this.I.getHttpRptServer().getReportInfo(string3, string6, n, (String)object, n2);
            string2 = reportInfo.getParamEngineId();
            Vector vector3 = reportInfo.getReportSheetInfos();
            int n3 = 0;
            while (n3 < vector3.size()) {
                ReportSheetInfo reportSheetInfo = (ReportSheetInfo)vector3.get(n3);
                if (reportSheetInfo.isBurstingReport() && string9 != null && string9.equals(reportSheetInfo.getName())) {
                    BurstingSchemaInfo[] burstingSchemaInfoArray = reportSheetInfo.getBurstingSchemaInfos();
                    int n4 = 0;
                    while (n4 < burstingSchemaInfoArray.length) {
                        String string12 = burstingSchemaInfoArray[n4].getName();
                        if (vector2.contains(string12) && burstingSchemaInfoArray[n4].getParamInfosForRecipient() != null) {
                            vector.addAll(burstingSchemaInfoArray[n4].getParamInfosForRecipient());
                        }
                        ++n4;
                    }
                }
                ++n3;
            }
        }
        if (string2 != null) {
            httpServletResponse.setHeader("jrs.param_engineid", string2);
        }
        string = JRTUtil.getParamsString(vector, null, null, true);
        httpServletResponse.setStatus(200);
        object = this.I.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        if (string.length() > 0) {
            ((JRStringBufferPrintWriter)object).print(string);
        }
        ((JRStringBufferPrintWriter)object).println();
        ((JRStringBufferPrintWriter)object).close();
    }

    public void responseDeleteParamEngine(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = this.I.getUser(httpServletRequest);
        String string2 = httpServletRequest.getHeader("jrs.param_engineid");
        JRTUtil.removeParamEngineById(string2);
        httpServletResponse.setStatus(200);
    }

    public void returnJDKVerion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = System.getProperty("java.version");
        httpServletResponse.setHeader("jrs.jdkverion", string);
        httpServletResponse.setStatus(200);
    }

    public void validateParameter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Properties properties) throws Exception {
        String string;
        ServiceLogger.logDebug("ViewerOperation1.validateParameter: ht=" + properties);
        String string2 = this.I.checkCatRpt(httpServletRequest, httpServletResponse, properties);
        if (string2 != null) {
            this.I.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, string2, (Hashtable)properties);
            return;
        }
        String string3 = (String)properties.get("jrs.report");
        String string4 = (String)properties.get("jrs.catalog");
        String string5 = (String)properties.get("jrs.cat_version");
        String string6 = (String)properties.get("jrs.rpt_version");
        int n = string5 == null ? this.I.getHttpRptServer().getResourceManager().getLatestVersionNumber(string4) : CSUtil.parseInt(string5);
        int n2 = string6 == null ? this.I.getHttpRptServer().getResourceManager().getLatestVersionNumber(string3) : CSUtil.parseInt(string6);
        String string7 = this.I.getUser(httpServletRequest);
        if (string7 != null) {
            properties.put("jrs.uid", string7);
        }
        if ((string = httpServletRequest.getHeader("jrs.param_engineid")) != null) {
            properties.put("jrs.engine_id", string);
        }
        ReportInfo reportInfo = null;
        reportInfo = this.I.getHttpRptServer().getReportInfo(string7, string4, n, string3, n2, properties);
        String string8 = reportInfo.validateParameter(2, properties);
        if ((string = properties.getProperty("jrs.engine_id", string)) != null) {
            httpServletResponse.setHeader("jrs.param_engineid", string);
        }
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.I.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        if (string8 != null && string8.length() > 0) {
            jRStringBufferPrintWriter.print(string8);
        }
        jRStringBufferPrintWriter.println();
        jRStringBufferPrintWriter.close();
    }
}

