/*
 * Decompiled with CFR 0.152.
 */
package jet.server.tools.migration;

import guitools.toolkit.JDebug;
import java.io.File;
import java.security.Principal;
import java.security.acl.Group;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.cs.EncodeExProperties;
import jet.server.api.exception.BadRealmException;
import jet.server.api.exception.NoSuchAclException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRealmException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.db.security2.AclEntryTable;
import jet.server.db.security2.AclsWithResourceRecord;
import jet.server.db.security2.AclsWithResourceTable;
import jet.server.db.security2.RoleTable;
import jet.server.db.security2.UserProfileTable;
import jet.server.db.security2.UserTable;
import jet.server.jrc.JRDataService;
import jet.server.jrc.resource.ResourceTreeManagerImpl;
import jet.server.jrc.security.SharedPasswordRealm2;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.tools.migration.DataToolkitV6;
import jet.server.tools.migration.TurnToNewPermissions;
import jet.server.userman.AclEntryImpl;
import jet.server.userman.AuditInfo;
import jet.server.userman.PasswordInfo;
import jet.server.userman.Realm;
import jet.server.userman.SharedPasswordRealm;
import jet.server.userman.User;
import jet.server.userman.UserImpl;
import jet.server.util.ServerUtil;

public class SecurityMigratorV6 {
    private String INFO = "";
    private String QOIV = "";
    private DataToolkitV6 add = null;
    private Vector addElement = new Vector();
    private Hashtable addRecord = new Hashtable();
    static Class class$jet$server$userman$Realm;

    public SecurityMigratorV6(String string, String string2) {
        this.INFO = string;
        this.QOIV = string2;
        this.INFO();
        this.QOIV();
    }

    public void setDataToolkit(DataToolkitV6 dataToolkitV6) {
        this.add = dataToolkitV6;
    }

    public Hashtable getProtections(String string) {
        return (Hashtable)this.addRecord.get(string);
    }

    private void INFO() {
        File file;
        String[] stringArray;
        JDebug.INFO((String)"Loading security data files...");
        Realm.clearAll();
        if (!this.INFO.endsWith(File.separator)) {
            this.INFO = this.INFO + File.separator;
        }
        if ((stringArray = (file = new File(this.INFO)).list()) != null && stringArray.length > 0) {
            try {
                int n = 0;
                while (n < stringArray.length) {
                    if (new File(this.INFO + stringArray[n]).isDirectory()) {
                        SharedPasswordRealm sharedPasswordRealm = new SharedPasswordRealm("");
                        sharedPasswordRealm.loadOld(this.INFO, this.INFO + stringArray[n] + File.separator + "realm.properties");
                        Realm.add(sharedPasswordRealm);
                    }
                    ++n;
                }
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JDebug.INFO((String)"Loading property files failed!  Using default...");
    }

    private void QOIV() {
        File file;
        String[] stringArray;
        JDebug.INFO((String)"Loading security data files...");
        if (!this.QOIV.endsWith(File.separator)) {
            this.QOIV = this.QOIV + File.separator;
        }
        if ((stringArray = (file = new File(this.QOIV)).list()) != null && stringArray.length > 0) {
            try {
                int n = 0;
                while (n < stringArray.length) {
                    if (new File(this.QOIV + stringArray[n]).isDirectory()) {
                        String string = this.QOIV + stringArray[n] + File.separator + "realm.properties";
                        EncodeExProperties encodeExProperties = new EncodeExProperties();
                        encodeExProperties.load(new File(string));
                        String string2 = encodeExProperties.getProperty("name", "");
                        if (!this.addElement.contains(string2)) {
                            this.addElement.add(string2);
                        }
                    }
                    ++n;
                }
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public Enumeration getAllRealmNames() {
        return Realm.getRealmNames();
    }

    private Enumeration getAllGroups(Realm realm) throws NoSuchRealmException, BadRealmException {
        Enumeration enumeration = null;
        enumeration = realm.getGroups();
        return enumeration;
    }

    private Enumeration getAllUserNames(Group group) throws NoSuchRealmException, BadRealmException, NoSuchGroupException {
        Enumeration enumeration = null;
        Enumeration enumeration2 = group.members();
        Vector<String> vector = new Vector<String>();
        while (enumeration2.hasMoreElements()) {
            Principal principal = (Principal)enumeration2.nextElement();
            String string = principal.getName();
            if (!(principal instanceof User)) continue;
            vector.addElement(string);
        }
        enumeration = vector.elements();
        return enumeration;
    }

    public void loadSecurityData(boolean bl) throws SQLException, ClassNotFoundException, NoSuchRealmException, NoSuchGroupException, NoSuchUserException, BadRealmException {
        RoleTable roleTable = null;
        UserTable userTable = null;
        UserProfileTable userProfileTable = null;
        AclsWithResourceTable aclsWithResourceTable = null;
        AclEntryTable aclEntryTable = null;
        Enumeration enumeration = this.getAllRealmNames();
        JRDataService jRDataService = null;
        System.out.println("start migrate security data");
        while (enumeration.hasMoreElements()) {
            boolean bl2;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            String string;
            Enumeration enumeration2;
            String string2 = (String)enumeration.nextElement();
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            Hashtable hashtable2 = new Hashtable();
            Realm realm = Realm.get(string2);
            int n = realm.getScheme();
            System.out.println("realm: " + string2);
            if (!this.addElement.contains(string2)) {
                this.addRealm(string2, n);
            }
            jRDataService = this.add.getDataService(string2);
            ResourceTreeManagerImpl resourceTreeManagerImpl = this.add.getResourceManager(string2);
            aclEntryTable = jRDataService.getAclEntryTable();
            aclsWithResourceTable = jRDataService.getAclsWithResourceTable();
            roleTable = jRDataService.getRoleTable();
            userTable = jRDataService.getUserTable();
            userProfileTable = jRDataService.getUserProfileTable();
            Enumeration enumeration3 = this.getAllGroups(realm);
            while (enumeration3.hasMoreElements()) {
                enumeration2 = (Group)enumeration3.nextElement();
                string = enumeration2.getName();
                boolean bl3 = false;
                if (string.equals("administrators") || string.equals("everyone")) {
                    bl3 = true;
                }
                if (roleTable.getRole(string) == null) {
                    roleTable.addRecord(string, bl3, "OldSecurityLoad", 0);
                }
                object5 = this.getAllUserNames((Group)enumeration2);
                while (object5.hasMoreElements()) {
                    object4 = (String)object5.nextElement();
                    SharedPasswordRealm sharedPasswordRealm = (SharedPasswordRealm)Realm.get(string2);
                    object3 = (UserImpl)sharedPasswordRealm.getUser((String)object4);
                    object2 = ((UserImpl)object3).passwordInfo;
                    object = ((UserImpl)object3).auditInfo;
                    bl2 = false;
                    if (((String)object4).equals("admin") || ((String)object4).equals("guest")) {
                        bl2 = true;
                    }
                    if (userTable.getUserRecordbyUN((String)object4) == null) {
                        userTable.addRecord((String)object4, ((UserImpl)object3).getFullname(), ((UserImpl)object3).getDescription(), ((UserImpl)object3).getEmail(), new Date(System.currentTimeMillis()), ServerUtil.encode((String)((UserImpl)object3).getAuthInfo()), bl2, ((PasswordInfo)object2).getPermitBlankFlag(), ((PasswordInfo)object2).getMinLength(), new Date(((PasswordInfo)object2).getLastModifyTime()), ((PasswordInfo)object2).getNeverExpireFlag(), ((PasswordInfo)object2).getExpireTime(), ((UserImpl)object3).isDisabled(), ((AuditInfo)object).isAuditFileAccessSuccess(), ((AuditInfo)object).isAuditFileAccessFail(), ((AuditInfo)object).isAuditManageSuccess(), ((AuditInfo)object).isAuditManageFail(), ((AuditInfo)object).isNoAudit(), 0, 0);
                    }
                    if (userProfileTable.getRecord((String)object4, string) != null) continue;
                    userProfileTable.addRecord((String)object4, string);
                }
            }
            enumeration2 = realm.getResourceNames();
            while (enumeration2.hasMoreElements()) {
                string = (String)enumeration2.nextElement();
                String string3 = realm.getResource(string).getAclName();
                try {
                    object5 = realm.getAcl(string3);
                }
                catch (NoSuchAclException noSuchAclException) {
                    noSuchAclException.printStackTrace();
                    continue;
                }
                if (object5 == null) continue;
                object4 = aclsWithResourceTable.addRecord(string, -1, string3, "SystemLoader", new Date(System.currentTimeMillis()));
                int n2 = ((AclsWithResourceRecord)object4).getAclID();
                hashtable.put(object5.getName(), new Integer(n2));
                object3 = object5.entries();
                while (object3.hasMoreElements()) {
                    object2 = (AclEntryImpl)object3.nextElement();
                    if (((AclEntryImpl)object2).isNegative()) continue;
                    object = TurnToNewPermissions.toNewPermissions(((AclEntryImpl)object2).permissions(), bl);
                    bl2 = TurnToNewPermissions.turnPermissionsToCode((Vector)object);
                    Principal principal = ((AclEntryImpl)object2).getPrincipal();
                    byte by = 0;
                    by = principal instanceof User ? (byte)1 : 2;
                    String string4 = principal.getName();
                    aclEntryTable.addRecord(n2, by, string4, true, bl2 ? 1 : 0);
                }
                hashtable2.put(string, hashtable.get(string3));
            }
            this.addRecord.put(string2, hashtable2);
            System.out.println("complete security data migration in realm: " + string2 + " successfully!");
        }
        System.out.println("complete all security data migration successfully!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addRealm(String string, int n) throws BadRealmException {
        if (string == null || string.trim().equals("")) {
            return "realm name is blank";
        }
        if (!this.QOIV.endsWith(File.separator)) {
            this.QOIV = this.QOIV + File.separator;
        }
        if (!UserDataToolkit.isValidName(string)) {
            return "Invalid realm name. Valid name can contains only \"_0-9a-zA-Z\"";
        }
        Class clazz = class$jet$server$userman$Realm == null ? (class$jet$server$userman$Realm = SecurityMigratorV6.class$("jet.server.userman.Realm")) : class$jet$server$userman$Realm;
        synchronized (clazz) {
            try {
                jet.server.jrc.security.Realm.get(string);
            }
            catch (NoSuchRealmException noSuchRealmException) {
                SharedPasswordRealm2 sharedPasswordRealm2 = new SharedPasswordRealm2(this.QOIV, string);
                sharedPasswordRealm2.setScheme(n);
                jet.server.jrc.security.Realm.add(sharedPasswordRealm2);
                sharedPasswordRealm2.oldSave(this.QOIV);
            }
        }
        return null;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            SecurityMigratorV6.add();
            return;
        }
        SecurityMigratorV6 securityMigratorV6 = new SecurityMigratorV6(stringArray[0], stringArray[1]);
        boolean bl = false;
        if (stringArray[2].endsWith("true")) {
            bl = true;
        }
        try {
            securityMigratorV6.loadSecurityData(bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void add() {
        System.out.println("java OldDataLoader oldJRHome newJRHome isV590OrLater");
        System.out.println("For Example:");
        System.out.println("java OldDataLoader C:" + File.separator + "OldJREntServer C:" + File.separator + "NewJREntServer " + "true");
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

