/*
 * Decompiled with CFR 0.152.
 */
package jet.server.trigger;

import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import jet.server.ServerEnv;
import jet.server.api.db.FieldValue;
import jet.server.api.db.Recordset;
import jet.server.api.trigger.Trigger;
import jet.server.api.trigger.TriggerManageException;
import jet.server.api.trigger.TriggerManager;
import jet.server.log.ServiceLogger;
import jet.server.trigger.ExternTriggerImpl;
import jet.server.trigger.TriggerTableImpl;

public final class TriggerManagerImpl
implements TriggerManager {
    private static TriggerManager QOIV = null;
    private HashList _updateTrigger = new HashList(this);
    private TriggerTableImpl append;

    public static synchronized TriggerManager getInstance() {
        if (QOIV == null) {
            QOIV = new TriggerManagerImpl();
        }
        return QOIV;
    }

    private TriggerManagerImpl() {
        ServiceLogger.logEvent(4670015, 4);
        this.append = TriggerTableImpl.getInstance();
        if (this.append != null) {
            this.clear();
        }
    }

    public void destroy() {
        this._updateTrigger.clear();
        if (this.append != null) {
            this.append.close();
        }
        QOIV = null;
        ServiceLogger.logEvent(4670016, 4);
    }

    public synchronized Trigger createTrigger(String string, String string2) throws TriggerManageException {
        if (this.contains(string)) {
            throw new TriggerManageException(670001, new Object[]{string}, null);
        }
        ExternTriggerImpl externTriggerImpl = new ExternTriggerImpl(string, string2);
        if (this.QOIV(externTriggerImpl)) {
            this._updateTrigger.put(externTriggerImpl.getName(), externTriggerImpl);
        }
        return externTriggerImpl;
    }

    public synchronized void setEnable(String string, boolean bl) {
        Trigger trigger = this.getTrigger(string);
        if (trigger != null) {
            boolean bl2 = trigger.isEnable();
            ((ExternTriggerImpl)trigger).setEnable(bl);
            if (!this._updateTrigger(trigger)) {
                ((ExternTriggerImpl)trigger).setEnable(bl2);
            }
        }
    }

    public Trigger getTrigger(String string) {
        return this._updateTrigger.get(string);
    }

    public synchronized void deleteTrigger(String string) throws TriggerManageException {
        Trigger trigger = this.getTrigger(string);
        if (trigger != null) {
            int n = trigger.getReferenced();
            if (n != 0) {
                throw new TriggerManageException(670002, new Object[]{string, new Integer(n)}, null);
            }
            if (this.append(trigger)) {
                this._updateTrigger.remove(trigger.getName());
            }
        }
    }

    public boolean contains(String string) {
        return this._updateTrigger.containsKey(string);
    }

    public Iterator iterator() {
        return this._updateTrigger.iterator();
    }

    public int size() {
        return this._updateTrigger.size();
    }

    public void fire(String string, Properties properties) throws TriggerManageException {
        if (!this.contains(string)) {
            throw new TriggerManageException(670003, new Object[]{string}, null);
        }
        Trigger trigger = this.getTrigger(string);
        if (!trigger.isEnable()) {
            throw new TriggerManageException(670004, new Object[]{string}, null);
        }
        ((ExternTriggerImpl)trigger).setPrevFireTime(System.currentTimeMillis());
        this.close(trigger, properties);
        this._updateTrigger(trigger);
    }

    private boolean QOIV(Trigger trigger) {
        if (this.append != null) {
            FieldValue[] fieldValueArray = this.append.fields().values();
            Object var3_3 = null;
            fieldValueArray[0].setValue(trigger.getName());
            fieldValueArray[1].setValue(trigger.getDescription());
            fieldValueArray[2].setValue(new Integer(((ExternTriggerImpl)trigger).getType()));
            fieldValueArray[3].setValue(new Boolean(trigger.isEnable()));
            fieldValueArray[4].setValue(new Long(trigger.getPrevFireTime()));
            fieldValueArray[5].setValue(new Long(((ExternTriggerImpl)trigger).getNextFireTime()));
            try {
                this.append.insert(fieldValueArray);
                return true;
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
                return false;
            }
        }
        return true;
    }

    private boolean append(Trigger trigger) {
        if (this.append != null) {
            FieldValue[] fieldValueArray = new FieldValue[]{this.append.fields("trigger_name").createFieldValue()};
            fieldValueArray[0].setValue(trigger.getName());
            try {
                this.append.delete(fieldValueArray);
                return true;
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
                return false;
            }
        }
        return true;
    }

    public boolean _updateTrigger(Trigger trigger) {
        if (this.append != null) {
            FieldValue[] fieldValueArray = new FieldValue[3];
            fieldValueArray[0] = this.append.fields("trigger_state").createFieldValue();
            fieldValueArray[0].setValue(new Boolean(trigger.isEnable()));
            fieldValueArray[1] = this.append.fields("prev_fire_time").createFieldValue();
            fieldValueArray[1].setValue(new Long(trigger.getPrevFireTime()));
            fieldValueArray[2] = this.append.fields("next_fire_time").createFieldValue();
            fieldValueArray[2].setValue(new Long(((ExternTriggerImpl)trigger).getNextFireTime()));
            try {
                this.append.update(fieldValueArray, "WHERE trigger_name=" + this.append.getDBAdapter().formatValue(trigger.getName()));
                return true;
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void clear() {
        block13: {
            Recordset recordset = null;
            recordset = this.append.query(this.append.fields().toArray(), null, true);
            while (recordset.next()) {
                ExternTriggerImpl externTriggerImpl = null;
                String string = recordset.getString("trigger_name");
                String string2 = recordset.getString("description");
                int n = recordset.getInt("trigger_type");
                boolean bl = recordset.getBoolean("trigger_state");
                long l = recordset.getLong("prev_fire_time");
                long l2 = recordset.getLong("next_fire_time");
                switch (n) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        externTriggerImpl = new ExternTriggerImpl(string, string2);
                        this._updateTrigger.put(externTriggerImpl.getName(), externTriggerImpl);
                        break;
                    }
                }
                ((ExternTriggerImpl)externTriggerImpl).setEnable(bl);
                externTriggerImpl.setPrevFireTime(l);
                externTriggerImpl.setNextFireTime(l2);
            }
            Object var12_10 = null;
            try {
                recordset.close();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            break block13;
            {
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                    Object var12_11 = null;
                    try {
                        recordset.close();
                    }
                    catch (Exception exception2) {
                        ServiceLogger.logError(exception2, 3);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                try {
                    recordset.close();
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
                throw throwable;
            }
        }
    }

    private boolean close(Trigger trigger, Object object) {
        ServiceLogger.logEvent(6670017, trigger.getName(), 6);
        Properties properties = new Properties();
        properties.setProperty("trigger.name", trigger.getName());
        if (object != null) {
            properties.put("trigger.data", object);
        }
        try {
            ServerEnv.getEventQueue().postEvent("TRIGGER_FIRE", 0, properties, 1);
            return true;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return false;
        }
    }

    private class HashList {
        private HashMap QOIV;
        private ArrayList add;
        private final TriggerManagerImpl this$0;

        public HashList(TriggerManagerImpl triggerManagerImpl) {
            this.this$0 = triggerManagerImpl;
            this.QOIV = null;
            this.add = null;
            this.QOIV = new HashMap();
            this.add = new ArrayList();
        }

        public synchronized void clear() {
            this.QOIV.clear();
            this.add.clear();
        }

        public synchronized int size() {
            return this.add.size();
        }

        public synchronized Iterator iterator() {
            return this.add.iterator();
        }

        public synchronized boolean containsKey(String string) {
            return this.QOIV.containsKey(string);
        }

        public synchronized Trigger get(String string) {
            return (Trigger)this.QOIV.get(string);
        }

        public synchronized void put(String string, Trigger trigger) {
            this.QOIV.put(string, trigger);
            this.add.add(trigger);
        }

        public synchronized void remove(String string) {
            Object v = this.QOIV.remove(string);
            if (v != null) {
                this.add.remove(v);
            }
        }

        protected void finalize() throws Throwable {
            this.clear();
            this.QOIV = null;
            this.add = null;
            super.finalize();
        }
    }
}

