/*
 * Decompiled with CFR 0.152.
 */
package jet.server.trigger;

import java.sql.SQLException;
import jet.server.api.db.Database;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Table;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.TableImpl;
import jet.server.log.ServiceLogger;

public final class TriggerTableImpl
extends TableImpl
implements Table {
    public static final int version = 1;
    private static String BIGINT = "TRIGGERS_1";
    private static TriggerTableImpl BIT = null;

    public static synchronized TriggerTableImpl getInstance() {
        return BIT;
    }

    public static synchronized TriggerTableImpl newInstance(Database database) {
        if (BIT == null) {
            try {
                BIT = new TriggerTableImpl(database);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return BIT;
    }

    private TriggerTableImpl(Database database) throws InstantiationException, SQLException {
        super(database, BIGINT);
        super.append(new FieldImpl(this.getName(), "trigger_name", JDBCType.VARCHAR, 80, 9, 0));
        super.append(new FieldImpl(this.getName(), "description", JDBCType.VARCHAR, 255, 0, 0));
        super.append(new FieldImpl(this.getName(), "trigger_type", JDBCType.TINYINT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), "trigger_state", JDBCType.BIT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), "prev_fire_time", JDBCType.BIGINT, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), "next_fire_time", JDBCType.BIGINT, 0, 0, 0));
        if (!database.tables().contains(this.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
    }

    public void close() {
        super.close();
        BIT = null;
    }
}

