/*
 * Decompiled with CFR 0.152.
 */
package jet.server.userman;

import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.AclEntry;
import java.security.acl.Group;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.cs.EncodeExProperties;
import jet.server.api.exception.BadRealmException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRealmException;
import jet.server.userman.AclEntryImpl;
import jet.server.userman.GroupImpl;
import jet.server.userman.OwnerImpl;
import jet.server.userman.PermissionImpl;
import jet.server.userman.Realm;
import jet.server.userman.User;
import jet.server.userman.UserImpl;

public class AclImpl
extends OwnerImpl
implements Acl {
    protected String name;
    protected String realmName;
    protected Vector entrys = new Vector();

    public AclImpl() {
    }

    public AclImpl(String string) {
        super(null);
        this.name = string;
    }

    public synchronized void setRealmName(String string) {
        this.realmName = string;
    }

    public synchronized String getRealmName() {
        return this.realmName;
    }

    public synchronized Realm getRealm() {
        try {
            return Realm.get(this.realmName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized void setName(Principal principal, String string) throws NotOwnerException {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public synchronized boolean addEntry(Principal principal, AclEntry aclEntry) throws NotOwnerException {
        if (aclEntry == null) {
            return false;
        }
        boolean bl = aclEntry.isNegative();
        Principal principal2 = aclEntry.getPrincipal();
        int n = 0;
        while (n < this.entrys.size()) {
            AclEntryImpl aclEntryImpl = (AclEntryImpl)this.entrys.elementAt(n);
            if (aclEntryImpl.getPrincipal() == principal2 && aclEntryImpl.isNegative() == bl) {
                return false;
            }
            ++n;
        }
        ((AclEntryImpl)aclEntry).setRealmName(this.realmName);
        this.entrys.addElement(aclEntry);
        return true;
    }

    public synchronized boolean removeEntry(Principal principal, AclEntry aclEntry) throws NotOwnerException {
        if (!this.entrys.contains(aclEntry)) {
            return false;
        }
        this.entrys.removeElement(aclEntry);
        Principal principal2 = aclEntry.getPrincipal();
        int n = 0;
        while (n < this.entrys.size()) {
            AclEntry aclEntry2 = (AclEntry)this.entrys.elementAt(n);
            if (aclEntry2.getPrincipal() == principal2) {
                return true;
            }
            ++n;
        }
        return true;
    }

    public synchronized Enumeration getPermissions(Principal principal) {
        if (!(principal instanceof Group) && !(principal instanceof User)) {
            return null;
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this.QOIV(principal, vector, vector2);
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        this.getPermissions(principal, vector3, vector4);
        int n = 0;
        while (n < vector4.size()) {
            Object e = vector4.elementAt(n);
            if (vector.contains(e)) {
                vector.removeElement(e);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            vector3.addElement(vector.elementAt(n2));
            ++n2;
        }
        return vector3.elements();
    }

    private void QOIV(Principal principal, Vector vector, Vector vector2) {
        vector.removeAllElements();
        vector2.removeAllElements();
        try {
            Vector vector3 = principal instanceof Group ? ((GroupImpl)((Object)principal)).getParentGroups() : ((UserImpl)principal).getParentGroups();
            Realm realm = Realm.get(this.realmName);
            Vector vector4 = new Vector();
            Vector vector5 = new Vector();
            int n = 0;
            while (n < vector3.size()) {
                GroupImpl groupImpl = (GroupImpl)realm.getGroup((String)vector3.elementAt(n));
                this.getPermissions((Principal)((Object)groupImpl), vector4, vector5);
                int n2 = 0;
                while (n2 < vector4.size()) {
                    Object e = vector4.elementAt(n2);
                    if (!vector.contains(e)) {
                        vector.addElement(e);
                    }
                    ++n2;
                }
                int n3 = 0;
                while (n3 < vector5.size()) {
                    Object e = vector5.elementAt(n3);
                    if (!vector2.contains(e)) {
                        vector2.addElement(e);
                    }
                    ++n3;
                }
                ++n;
            }
            int n4 = vector.size() - 1;
            while (n4 >= 0) {
                Object e = vector.elementAt(n4);
                if (vector2.contains(e)) {
                    vector.removeElement(e);
                    vector2.removeElement(e);
                }
                --n4;
            }
        }
        catch (NoSuchRealmException noSuchRealmException) {
        }
        catch (BadRealmException badRealmException) {
        }
        catch (NoSuchGroupException noSuchGroupException) {
            // empty catch block
        }
    }

    private void getPermissions(Principal principal, Vector vector, Vector vector2) {
        vector.removeAllElements();
        vector2.removeAllElements();
        Enumeration enumeration = this.entries();
        while (enumeration.hasMoreElements()) {
            AclEntryImpl aclEntryImpl = (AclEntryImpl)enumeration.nextElement();
            if (!aclEntryImpl.user.equals(principal.getName())) continue;
            Vector vector3 = aclEntryImpl.isNegative() ? vector2 : vector;
            Enumeration enumeration2 = aclEntryImpl.permissions();
            while (enumeration2.hasMoreElements()) {
                vector3.addElement(enumeration2.nextElement());
            }
        }
    }

    protected synchronized boolean checkNegativePermission(Principal principal, Permission permission) {
        Enumeration enumeration = this.addElement(principal);
        while (enumeration.hasMoreElements()) {
            if (!permission.equals(enumeration.nextElement())) continue;
            return true;
        }
        return false;
    }

    private synchronized Enumeration addElement(Principal principal) {
        if (!(principal instanceof Group) && !(principal instanceof User)) {
            return null;
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this.QOIV(principal, vector, vector2);
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        this.getPermissions(principal, vector3, vector4);
        int n = 0;
        while (n < vector3.size()) {
            Object e = vector3.elementAt(n);
            if (vector2.contains(e)) {
                vector2.removeElement(e);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < vector2.size()) {
            vector4.addElement(vector2.elementAt(n2));
            ++n2;
        }
        return vector4.elements();
    }

    public synchronized boolean checkPermission(Principal principal, Permission permission) {
        Enumeration enumeration = this.getPermissions(principal);
        while (enumeration.hasMoreElements()) {
            if (!permission.equals(enumeration.nextElement())) continue;
            return true;
        }
        return false;
    }

    public synchronized Enumeration entries() {
        return ((Vector)this.entrys.clone()).elements();
    }

    public String toString() {
        return "AclImpl:" + this.hashCode() + " " + this.name;
    }

    public synchronized EncodeExProperties getProperties() throws IOException {
        EncodeExProperties encodeExProperties = new EncodeExProperties();
        encodeExProperties.setProperty("name", this.name);
        encodeExProperties.setProperty("entry.count", this.entrys.size());
        int n = 0;
        while (n < this.entrys.size()) {
            AclEntryImpl aclEntryImpl = (AclEntryImpl)this.entrys.elementAt(n);
            aclEntryImpl.save(encodeExProperties, "entry." + n + ".");
            ++n;
        }
        return encodeExProperties;
    }

    public synchronized void save(String string) {
        try {
            EncodeExProperties encodeExProperties = this.getProperties();
            encodeExProperties.save(string, "");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized boolean load(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        try {
            EncodeExProperties encodeExProperties = new EncodeExProperties();
            encodeExProperties.load(file);
            this.name = encodeExProperties.getProperty("name", "");
            int n = encodeExProperties.getProperty("entry.count", 0);
            int n2 = 0;
            while (n2 < n) {
                AclEntryImpl aclEntryImpl = new AclEntryImpl();
                aclEntryImpl.setRealmName(this.realmName);
                aclEntryImpl.load(encodeExProperties, "entry." + n2 + ".");
                this.entrys.addElement(aclEntryImpl);
                ++n2;
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public String listPermissions() {
        Object object;
        Object object2;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration enumeration = this.entries();
        while (enumeration.hasMoreElements()) {
            String string;
            object2 = (AclEntryImpl)enumeration.nextElement();
            object = ((AclEntryImpl)object2).getPrincipal();
            if (object == null) continue;
            String string2 = string = object instanceof User ? object.getName() : "[" + object.getName() + "]";
            if (!hashtable.containsKey(string)) {
                hashtable.put(string, string + ":  ");
            }
            String string3 = (String)hashtable.get(string);
            Enumeration enumeration2 = ((AclEntryImpl)object2).permissions();
            while (enumeration2.hasMoreElements()) {
                PermissionImpl permissionImpl = (PermissionImpl)enumeration2.nextElement();
                if (((AclEntryImpl)object2).isNegative()) {
                    string3 = string3 + "-";
                }
                string3 = string3 + permissionImpl.getName() + ";";
            }
            hashtable.put(string, string3);
        }
        object2 = "";
        object = hashtable.elements();
        while (object.hasMoreElements()) {
            object2 = (String)object2 + (String)object.nextElement() + System.getProperty("line.separator");
        }
        return object2;
    }
}

