/*
 * Decompiled with CFR 0.152.
 */
package jet.server.userman;

import guitools.toolkit.JDebug;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Vector;
import jet.cs.EncodeExProperties;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.userman.Realm;
import jet.server.userman.SharedPasswordRealm;
import jet.server.userman.User;
import jet.server.userman.UserImpl;

public class GroupImpl
implements Group {
    protected String name;
    protected String description = "";
    protected long timeCreation;
    protected boolean bAdministrator = false;
    protected String realmName;
    protected Vector parentGroups = new Vector();
    protected Vector children = new Vector();
    protected boolean ldapFlag = false;
    static Class class$jet$server$userman$GroupImpl;

    public GroupImpl() {
        this.timeCreation = System.currentTimeMillis();
    }

    public GroupImpl(String string) {
        this.name = string;
        this.timeCreation = System.currentTimeMillis();
    }

    public boolean getLdapFlag() {
        return this.ldapFlag;
    }

    public void setLdapFlag(boolean bl) {
        this.ldapFlag = bl;
    }

    public synchronized boolean addMember(Principal principal) {
        if (principal instanceof Group) {
            if (this.name.equals(principal.getName())) {
                return false;
            }
            if (((GroupImpl)((Object)principal)).isDescendant(this.name)) {
                return false;
            }
        }
        if (this.isMember(principal)) {
            return false;
        }
        this.children.addElement(principal.getName());
        if (principal instanceof User) {
            ((UserImpl)principal).insertIntoGroup(this);
        } else if (principal instanceof Group) {
            ((GroupImpl)((Object)principal)).insertIntoGroup(this);
        }
        return true;
    }

    public synchronized boolean isMember(Principal principal) {
        int n = 0;
        while (n < this.children.size()) {
            if (((String)this.children.elementAt(n)).equalsIgnoreCase(principal.getName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized Enumeration listDisappearedPrincipal() {
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < this.children.size()) {
            String string = (String)this.children.elementAt(n);
            try {
                Realm realm = Realm.get(this.realmName);
                Object var7_8 = null;
                if (!((SharedPasswordRealm)realm).isUserExist(string)) {
                    bl = true;
                }
                if (!realm.isGroupExist(string)) {
                    bl2 = true;
                }
                if (bl && bl2) {
                    vector.addElement(string);
                    bl = false;
                    bl2 = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        return vector.elements();
    }

    public synchronized Enumeration members() {
        Vector<User> vector = new Vector<User>();
        int n = 0;
        while (n < this.children.size()) {
            String string = (String)this.children.elementAt(n);
            try {
                Realm realm = Realm.get(this.realmName);
                User user = null;
                try {
                    user = realm.getUser(string);
                }
                catch (NoSuchUserException noSuchUserException) {
                    user = realm.getGroup(string);
                }
                vector.addElement(user);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        return vector.elements();
    }

    public synchronized boolean removeMember(Principal principal) {
        if (!this.isMember(principal)) {
            return false;
        }
        int n = 0;
        while (n < this.children.size()) {
            String string = (String)this.children.elementAt(n);
            if (string.equalsIgnoreCase(principal.getName())) {
                this.children.removeElement(string);
                break;
            }
            ++n;
        }
        if (principal instanceof User) {
            ((UserImpl)principal).removeFromGroup(this);
        } else if (principal instanceof Group) {
            ((GroupImpl)((Object)principal)).removeFromGroup(this);
        }
        return true;
    }

    public synchronized void setName(String string) {
        this.name = string;
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public synchronized void setDescription(String string) {
        this.description = string;
    }

    public synchronized void setRealmName(Realm realm) {
        this.realmName = realm.getName();
    }

    public synchronized void setRealmName(String string) {
        this.realmName = string;
    }

    public synchronized String getRealmName() {
        return this.realmName;
    }

    public synchronized void setAdministrator(boolean bl) {
        this.bAdministrator = bl;
    }

    public synchronized boolean isAdministrator() {
        return this.bAdministrator;
    }

    public synchronized int getMemberCount() {
        int n = this.children.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            String string = (String)this.children.elementAt(n3);
            try {
                Realm realm = Realm.get(this.realmName);
                User user = null;
                try {
                    user = realm.getUser(string);
                }
                catch (NoSuchUserException noSuchUserException) {
                    user = realm.getGroup(string);
                }
                ++n2;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n3;
        }
        return n2;
    }

    public synchronized void insertIntoGroup(Group group) {
        this.parentGroups.addElement(group.getName());
    }

    public synchronized void removeFromGroup(Group group) {
        this.parentGroups.removeElement(group.getName());
    }

    public synchronized Vector getParentGroups() {
        return this.parentGroups;
    }

    public synchronized boolean isDescendant(String string) {
        try {
            Realm realm = Realm.get(this.realmName);
            int n = 0;
            while (n < this.children.size()) {
                String string2 = (String)this.children.elementAt(n);
                if (string.equalsIgnoreCase(string2)) {
                    return true;
                }
                try {
                    GroupImpl groupImpl = (GroupImpl)realm.getGroup(string2);
                    if (groupImpl.isDescendant(string)) {
                        return true;
                    }
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    // empty catch block
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String toString() {
        return "Group@" + this.hashCode() + " " + this.name;
    }

    public void dump() {
        String string = this + "\n    children:" + this.children;
        JDebug.INFO((String)string);
    }

    public synchronized EncodeExProperties getProperties() throws IOException {
        EncodeExProperties encodeExProperties = new EncodeExProperties();
        encodeExProperties.setProperty("class", this.getClass().getName());
        encodeExProperties.setProperty("name", this.name);
        encodeExProperties.setProperty("description", this.getDescription());
        encodeExProperties.setProperty("Administrator", this.bAdministrator);
        encodeExProperties.setProperty("Creation", this.timeCreation);
        encodeExProperties.setProperty("group.count", this.parentGroups.size());
        int n = 0;
        while (n < this.parentGroups.size()) {
            encodeExProperties.setProperty("group." + n, (String)this.parentGroups.elementAt(n));
            ++n;
        }
        encodeExProperties.setProperty("child.count", this.children.size());
        int n2 = 0;
        while (n2 < this.children.size()) {
            encodeExProperties.setProperty("child." + n2, (String)this.children.elementAt(n2));
            ++n2;
        }
        return encodeExProperties;
    }

    public synchronized void save(String string) {
        try {
            EncodeExProperties encodeExProperties = this.getProperties();
            encodeExProperties.save(string, "");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Group load(String string) {
        Class clazz = class$jet$server$userman$GroupImpl == null ? (class$jet$server$userman$GroupImpl = GroupImpl.class$("jet.server.userman.GroupImpl")) : class$jet$server$userman$GroupImpl;
        synchronized (clazz) {
            File file = new File(string);
            if (!file.exists()) {
                return null;
            }
            try {
                EncodeExProperties encodeExProperties = new EncodeExProperties();
                encodeExProperties.load(file);
                String string2 = encodeExProperties.getProperty("class", "jet.server.userman.GroupImpl");
                GroupImpl groupImpl = (GroupImpl)Class.forName(string2).newInstance();
                groupImpl.name = encodeExProperties.getProperty("name", "");
                groupImpl.description = encodeExProperties.getProperty("description", "");
                groupImpl.bAdministrator = encodeExProperties.getProperty("administrator", false);
                int n = encodeExProperties.getProperty("group.count", 0);
                int n2 = 0;
                while (n2 < n) {
                    String string3 = encodeExProperties.getProperty("group." + n2, "");
                    if (string3.length() > 0) {
                        groupImpl.parentGroups.addElement(string3);
                    }
                    ++n2;
                }
                n = encodeExProperties.getProperty("child.count", 0);
                int n3 = 0;
                while (n3 < n) {
                    String object = encodeExProperties.getProperty("child." + n3, "");
                    if (object.length() > 0) {
                        groupImpl.children.addElement(object);
                    }
                    ++n3;
                }
                return groupImpl;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

