/*
 * Decompiled with CFR 0.152.
 */
package jet.server.userman;

import guitools.toolkit.JDebug;
import java.io.File;
import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.Group;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.server.api.exception.BadRealmException;
import jet.server.api.exception.InUseException;
import jet.server.api.exception.NoSuchAclException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRealmException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.log.ServiceLogger;
import jet.server.userman.AclEntryImpl;
import jet.server.userman.AclImpl;
import jet.server.userman.GroupImpl;
import jet.server.userman.Resource;
import jet.server.userman.SharedPasswordRealm;
import jet.server.userman.User;
import jet.server.userman.WorldGroupImpl;

public abstract class Realm {
    public static final int SCHEME_BASIC = 0;
    public static final int SCHEME_DIGEST = 1;
    protected static Vector realms = new Vector();
    protected Hashtable users = new Hashtable();
    protected Hashtable groups = new Hashtable();
    protected Hashtable acls = new Hashtable();
    protected Hashtable resources = new Hashtable();
    protected String name;
    protected File realmDir;
    protected int scheme = 0;
    static Class class$jet$server$userman$Realm;

    public Realm() {
        this("");
    }

    public Realm(String string) {
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector list() {
        Class clazz = class$jet$server$userman$Realm == null ? (class$jet$server$userman$Realm = Realm.class$("jet.server.userman.Realm")) : class$jet$server$userman$Realm;
        synchronized (clazz) {
            Vector<String> vector = new Vector<String>();
            int n = 0;
            while (n < realms.size()) {
                vector.addElement(((Realm)realms.elementAt(n)).getName());
                ++n;
            }
            Vector<String> vector2 = vector;
            return vector2;
        }
    }

    public synchronized void setScheme(int n) {
        this.scheme = n;
        if (this.scheme != 0 && this.scheme != 1) {
            this.scheme = 0;
        }
    }

    public int getScheme() {
        return this.scheme;
    }

    public static void clearAll() {
        realms.removeAllElements();
    }

    public synchronized Acl getAcl() throws BadRealmException {
        try {
            return this.getAcl("rootAcl");
        }
        catch (NoSuchAclException noSuchAclException) {
            Realm.logError(noSuchAclException, "rootAcl not found");
            return null;
        }
    }

    public synchronized Enumeration getAclNames() throws BadRealmException {
        return this.acls.keys();
    }

    public synchronized Acl getAcl(String string) throws NoSuchAclException, BadRealmException {
        Enumeration enumeration = this.acls.elements();
        while (enumeration.hasMoreElements()) {
            Acl acl = (Acl)enumeration.nextElement();
            if (!acl.getName().equalsIgnoreCase(string)) continue;
            return acl;
        }
        throw new NoSuchAclException(630006, (Object[])new String[]{string}, null);
    }

    public synchronized boolean isAclExist(String string) {
        Enumeration enumeration = this.acls.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public synchronized Enumeration getAcls() throws BadRealmException {
        return this.acls.elements();
    }

    public synchronized Acl makeAcl(String string, Principal principal) throws BadRealmException {
        if (this.isAclExist(string)) {
            throw new IllegalArgumentException(string + " already exists.");
        }
        AclImpl aclImpl = new AclImpl(string);
        aclImpl.setRealmName(this.getName());
        this.acls.put(string, aclImpl);
        return aclImpl;
    }

    public synchronized void deleteAcl(String string) throws NoSuchAclException, BadRealmException {
        Enumeration enumeration = this.acls.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            this.acls.remove(string2);
            return;
        }
        Realm.logError("deleteAcl " + string + " fail.");
        throw new NoSuchAclException(630006, (Object[])new String[]{string}, null);
    }

    public abstract Enumeration getUserNames() throws BadRealmException;

    public abstract User getUser(String var1) throws NoSuchUserException, BadRealmException;

    public abstract void deleteUser(String var1) throws NoSuchUserException, BadRealmException, InUseException;

    protected synchronized void verifyNotInPolicies(Principal principal) throws BadRealmException, InUseException {
        Group group;
        Enumeration enumeration = this.groups.elements();
        while (enumeration.hasMoreElements()) {
            group = (Group)enumeration.nextElement();
            if (!group.isMember(principal) || group instanceof WorldGroupImpl) continue;
            throw new InUseException(630040, (Object[])new String[]{group.getName()}, null);
        }
        group = this.acls.elements();
        while (group.hasMoreElements()) {
            Acl acl = (Acl)group.nextElement();
            if (acl.isOwner(principal)) {
                throw new InUseException(630041, (Object[])new String[]{principal.getName(), acl.getName()}, null);
            }
            Enumeration enumeration2 = acl.entries();
            while (enumeration2.hasMoreElements()) {
                AclEntryImpl aclEntryImpl = (AclEntryImpl)enumeration2.nextElement();
                if (aclEntryImpl.getPrincipal() == null || !aclEntryImpl.getPrincipal().equals(principal)) continue;
                throw new InUseException(630041, (Object[])new String[]{principal.getName(), acl.getName()}, null);
            }
        }
    }

    public synchronized Enumeration getResourceNames() throws BadRealmException {
        return this.resources.keys();
    }

    public synchronized Enumeration getResources() throws BadRealmException {
        return this.resources.elements();
    }

    public synchronized Resource getResource(String string) throws BadRealmException {
        if (string == null) {
            return null;
        }
        Enumeration enumeration = this.resources.elements();
        while (enumeration.hasMoreElements()) {
            Resource resource = (Resource)enumeration.nextElement();
            if (!resource.getName().equalsIgnoreCase(string)) continue;
            return resource;
        }
        Realm.logError("getResource " + string + " fails.");
        return null;
    }

    public synchronized Resource makeResource(String string, int n) throws BadRealmException {
        if (this.isResourceExist(string)) {
            throw new IllegalArgumentException(string + " already exists.");
        }
        Resource resource = new Resource(this);
        resource.setName(string);
        resource.setType(n);
        this.resources.put(string, resource);
        return resource;
    }

    public synchronized boolean isResourceExist(String string) {
        Enumeration enumeration = this.resources.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public synchronized void deleteResource(String string) {
        Enumeration enumeration = this.resources.elements();
        while (enumeration.hasMoreElements()) {
            Resource resource = (Resource)enumeration.nextElement();
            if (!resource.getName().equalsIgnoreCase(string)) continue;
            this.resources.remove(resource.getName());
            return;
        }
    }

    public synchronized Enumeration getGroupNames() throws BadRealmException {
        return this.groups.keys();
    }

    public synchronized Enumeration getGroups() throws BadRealmException {
        return this.groups.elements();
    }

    public synchronized Group getGroup(String string) throws BadRealmException, NoSuchGroupException {
        if (string == null) {
            return null;
        }
        Enumeration enumeration = this.groups.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            return (Group)this.groups.get(string2);
        }
        throw new NoSuchGroupException(630001, (Object[])new String[]{string}, null);
    }

    public synchronized boolean isGroupExist(String string) {
        if (string == null) {
            return false;
        }
        Enumeration enumeration = this.groups.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public synchronized Group makeGroup(String string) throws BadRealmException, InUseException {
        try {
            GroupImpl groupImpl = (GroupImpl)this.getGroup(string);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            if (((SharedPasswordRealm)this).isUserExist(string)) {
                return null;
            }
            GroupImpl groupImpl = string.equals("everyone") ? new WorldGroupImpl(string) : new GroupImpl(string);
            groupImpl.setRealmName(this);
            this.groups.put(string, groupImpl);
            return groupImpl;
        }
        return null;
    }

    public synchronized boolean deleteGroup(String string) throws BadRealmException, NoSuchGroupException, InUseException {
        GroupImpl groupImpl = (GroupImpl)this.getGroup(string);
        this.verifyNotInPolicies((Principal)((Object)groupImpl));
        if (groupImpl.getMemberCount() > 0) {
            return false;
        }
        Enumeration enumeration = this.groups.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            this.groups.remove(string2);
            return true;
        }
        return false;
    }

    public synchronized boolean removeGroup(String string) throws BadRealmException, NoSuchGroupException, InUseException {
        GroupImpl groupImpl = (GroupImpl)this.getGroup(string);
        Enumeration enumeration = this.groups.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            this.groups.remove(string2);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Realm get(String string) throws NoSuchRealmException, BadRealmException {
        Class clazz = class$jet$server$userman$Realm == null ? (class$jet$server$userman$Realm = Realm.class$("jet.server.userman.Realm")) : class$jet$server$userman$Realm;
        synchronized (clazz) {
            int n = 0;
            while (n < realms.size()) {
                Realm realm = (Realm)realms.elementAt(n);
                if (realm.getName().equalsIgnoreCase(string)) {
                    return realm;
                }
                ++n;
            }
            throw new NoSuchRealmException(620003, new Object[]{string}, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(Realm realm) {
        Class clazz = class$jet$server$userman$Realm == null ? (class$jet$server$userman$Realm = Realm.class$("jet.server.userman.Realm")) : class$jet$server$userman$Realm;
        synchronized (clazz) {
            realms.addElement(realm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(String string) {
        Class clazz = class$jet$server$userman$Realm == null ? (class$jet$server$userman$Realm = Realm.class$("jet.server.userman.Realm")) : class$jet$server$userman$Realm;
        synchronized (clazz) {
            try {
                Realm realm = Realm.get(string);
                realms.removeElement(realm);
            }
            catch (NoSuchRealmException noSuchRealmException) {
                ServiceLogger.logError(noSuchRealmException, 3);
            }
            catch (BadRealmException badRealmException) {
                ServiceLogger.logError(badRealmException, 3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration getRealmNames() {
        Class clazz = class$jet$server$userman$Realm == null ? (class$jet$server$userman$Realm = Realm.class$("jet.server.userman.Realm")) : class$jet$server$userman$Realm;
        synchronized (clazz) {
            Object object;
            Vector<String> vector = new Vector<String>();
            int n = 0;
            while (n < realms.size()) {
                object = (Realm)realms.elementAt(n);
                vector.addElement(((Realm)object).getName());
                ++n;
            }
            object = vector.elements();
            return object;
        }
    }

    public final String getName() {
        return this.name;
    }

    protected final synchronized void setName(String string) {
        this.name = string;
    }

    protected synchronized void init(Properties properties) throws BadRealmException, NoSuchRealmException {
    }

    protected synchronized void setRealmDir(File file) {
        this.realmDir = file;
    }

    public synchronized File getRealmDir() {
        return this.realmDir;
    }

    protected void setDefaultPolicies() throws BadRealmException {
    }

    public synchronized boolean checkPermission(String string, Principal principal, Permission permission) {
        try {
            Resource resource = this.getResource(string);
            if (resource == null) {
                return true;
            }
            AclImpl aclImpl = (AclImpl)this.getAcl(resource.getAclName());
            if (aclImpl == null) {
                return false;
            }
            return aclImpl.checkPermission(principal, permission);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
            return false;
        }
    }

    public static void logError(Exception exception, String string) {
        ServiceLogger.logError(string);
        ServiceLogger.logError(exception);
    }

    public static void logError(String string) {
        ServiceLogger.logError(string);
    }

    public String toString() {
        return "Realm:" + this.hashCode() + " " + this.name;
    }

    public void dump() {
        String string = this + "\n  groups:" + this.groups + "\n   acls:" + this.acls;
        JDebug.INFO((String)string);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

