/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import java.beans.Introspector;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class ClassUtils {
    public static final String ARRAY_SUFFIX = "[]";
    private static final Map QOIV = new HashMap(8);
    private static final Map TYPE = new HashMap(8);
    static Class class$java$lang$Boolean;
    static Class class$java$lang$Byte;
    static Class class$java$lang$Character;
    static Class class$java$lang$Double;
    static Class class$java$lang$Float;
    static Class class$java$lang$Integer;
    static Class class$java$lang$Long;
    static Class class$java$lang$Short;
    static Class class$jet$server$util$ClassUtils;

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = (class$jet$server$util$ClassUtils == null ? (class$jet$server$util$ClassUtils = ClassUtils.class$("jet.server.util.ClassUtils")) : class$jet$server$util$ClassUtils).getClassLoader();
        }
        return classLoader;
    }

    public static boolean isPresent(String string) {
        try {
            ClassUtils.forName(string);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static Class forName(String string) throws ClassNotFoundException {
        return ClassUtils.forName(string, ClassUtils.getDefaultClassLoader());
    }

    public static Class forName(String string, ClassLoader classLoader) throws ClassNotFoundException {
        Class clazz = ClassUtils.resolvePrimitiveClassName(string);
        if (clazz != null) {
            return clazz;
        }
        if (string.endsWith(ARRAY_SUFFIX)) {
            String string2 = string.substring(0, string.length() - ARRAY_SUFFIX.length());
            Class clazz2 = ClassUtils.forName(string2, classLoader);
            return Array.newInstance(clazz2, 0).getClass();
        }
        return Class.forName(string, true, classLoader);
    }

    public static Class resolvePrimitiveClassName(String string) {
        Class clazz = null;
        if (string != null && string.length() <= 8) {
            clazz = (Class)TYPE.get(string);
        }
        return clazz;
    }

    public static String getShortName(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Class name must not be empty");
        }
        int n = string.lastIndexOf(46);
        int n2 = string.indexOf("$$");
        if (n2 == -1) {
            n2 = string.length();
        }
        String string2 = string.substring(n + 1, n2);
        string2 = string2.replace('$', '.');
        return string2;
    }

    public static String getShortName(Class clazz) {
        return ClassUtils.getShortName(ClassUtils.getQualifiedName(clazz));
    }

    public static String getShortNameAsProperty(Class clazz) {
        return Introspector.decapitalize(ClassUtils.getShortName(clazz));
    }

    public static String getQualifiedName(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (clazz.isArray()) {
            return ClassUtils.QOIV(clazz);
        }
        return clazz.getName();
    }

    public static String getQualifiedMethodName(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("Method must not be null");
        }
        return method.getDeclaringClass().getName() + "." + method.getName();
    }

    public static boolean hasMethod(Class clazz, String string, Class[] classArray) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Method name must not be null");
        }
        try {
            clazz.getMethod(string, classArray);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public static int getMethodCountForName(Class clazz, String string) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Method name must not be null");
        }
        int n = 0;
        do {
            int n2 = 0;
            while (n2 < clazz.getDeclaredMethods().length) {
                Method method = clazz.getDeclaredMethods()[n2];
                if (string.equals(method.getName())) {
                    ++n;
                }
                ++n2;
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return n;
    }

    public static boolean hasAtLeastOneMethodWithName(Class clazz, String string) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Method name must not be null");
        }
        do {
            int n = 0;
            while (n < clazz.getDeclaredMethods().length) {
                Method method = clazz.getDeclaredMethods()[n];
                if (method.getName().equals(string)) {
                    return true;
                }
                ++n;
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return false;
    }

    public static Method getStaticMethod(Class clazz, String string, Class[] classArray) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Method name must not be null");
        }
        try {
            Method method = clazz.getDeclaredMethod(string, classArray);
            if ((method.getModifiers() & 8) != 0) {
                return method;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        return null;
    }

    public static boolean isPrimitiveWrapper(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        return QOIV.containsKey(clazz);
    }

    public static boolean isPrimitiveOrWrapper(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        return clazz.isPrimitive() || ClassUtils.isPrimitiveWrapper(clazz);
    }

    public static boolean isPrimitiveArray(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        return clazz.isArray() && clazz.getComponentType().isPrimitive();
    }

    public static boolean isPrimitiveWrapperArray(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        return clazz.isArray() && ClassUtils.isPrimitiveWrapper(clazz.getComponentType());
    }

    public static boolean isAssignable(Class clazz, Class clazz2) {
        if (clazz == null) {
            throw new IllegalArgumentException("Target type must not be null");
        }
        if (clazz2 == null) {
            throw new IllegalArgumentException("Value type must not be null");
        }
        return clazz.isAssignableFrom(clazz2) || clazz.equals(QOIV.get(clazz2));
    }

    public static boolean isAssignableValue(Class clazz, Object object) {
        if (clazz == null) {
            throw new IllegalArgumentException("Type must not be null");
        }
        return object != null ? ClassUtils.isAssignable(clazz, object.getClass()) : !clazz.isPrimitive();
    }

    public static String addResourcePathToPackagePath(Class clazz, String string) {
        if (string == null) {
            throw new IllegalArgumentException("Resource name must not be null");
        }
        if (!string.startsWith("/")) {
            return ClassUtils.classPackageAsResourcePath(clazz) + "/" + string;
        }
        return ClassUtils.classPackageAsResourcePath(clazz) + string;
    }

    public static String classPackageAsResourcePath(Class clazz) {
        if (clazz == null || clazz.getPackage() == null) {
            return "";
        }
        return clazz.getPackage().getName().replace('.', '/');
    }

    public static Class[] getAllInterfaces(Object object) {
        Set set = ClassUtils.getAllInterfacesAsSet(object);
        return set.toArray(new Class[set.size()]);
    }

    public static Class[] getAllInterfacesForClass(Class clazz) {
        Set set = ClassUtils.getAllInterfacesForClassAsSet(clazz);
        return set.toArray(new Class[set.size()]);
    }

    public static Set getAllInterfacesAsSet(Object object) {
        return ClassUtils.getAllInterfacesForClassAsSet(object.getClass());
    }

    public static Set getAllInterfacesForClassAsSet(Class clazz) {
        if (clazz.isInterface()) {
            return Collections.singleton(clazz);
        }
        HashSet hashSet = new HashSet();
        while (clazz != null) {
            int n = 0;
            while (n < clazz.getInterfaces().length) {
                Class<?> clazz2 = clazz.getInterfaces()[n];
                hashSet.add(clazz2);
                ++n;
            }
            clazz = clazz.getSuperclass();
        }
        return hashSet;
    }

    private static String QOIV(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            stringBuffer.append(ARRAY_SUFFIX);
        }
        stringBuffer.insert(0, clazz.getName());
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        QOIV.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean, Boolean.TYPE);
        QOIV.put(class$java$lang$Byte == null ? (class$java$lang$Byte = ClassUtils.class$("java.lang.Byte")) : class$java$lang$Byte, Byte.TYPE);
        QOIV.put(class$java$lang$Character == null ? (class$java$lang$Character = ClassUtils.class$("java.lang.Character")) : class$java$lang$Character, Character.TYPE);
        QOIV.put(class$java$lang$Double == null ? (class$java$lang$Double = ClassUtils.class$("java.lang.Double")) : class$java$lang$Double, Double.TYPE);
        QOIV.put(class$java$lang$Float == null ? (class$java$lang$Float = ClassUtils.class$("java.lang.Float")) : class$java$lang$Float, Float.TYPE);
        QOIV.put(class$java$lang$Integer == null ? (class$java$lang$Integer = ClassUtils.class$("java.lang.Integer")) : class$java$lang$Integer, Integer.TYPE);
        QOIV.put(class$java$lang$Long == null ? (class$java$lang$Long = ClassUtils.class$("java.lang.Long")) : class$java$lang$Long, Long.TYPE);
        QOIV.put(class$java$lang$Short == null ? (class$java$lang$Short = ClassUtils.class$("java.lang.Short")) : class$java$lang$Short, Short.TYPE);
        Iterator iterator = QOIV.values().iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            TYPE.put(clazz.getName(), clazz);
        }
    }
}

