/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringBufferInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import jet.cs.CSUtil;
import jet.server.api.exception.UnknownMIMEType;
import jet.util.AsciiProperties;

public class MIMETypeTable
extends Hashtable {
    public static final String extsKey = "file_extensions";
    public static final String descKey = "description";
    public static final String unknownType = "application/octet-stream";
    public static final String extSeparator = ",";
    private static char[] QOIV = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public MIMETypeTable() {
        this.charAt();
    }

    public MIMETypeTable(InputStream inputStream) throws IOException {
        this.charAt();
        this.load(inputStream);
    }

    public void load(InputStream inputStream) throws IOException {
        AsciiProperties asciiProperties = new AsciiProperties();
        asciiProperties.load(inputStream);
        Enumeration enumeration = asciiProperties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)asciiProperties.get((Object)string);
            this.QOIV(string, string2);
        }
    }

    public boolean mimeCheck(String string, String string2) throws UnknownMIMEType {
        if (this.containsKey(string)) {
            Properties properties = (Properties)this.get(string);
            String string3 = (String)properties.get(extsKey);
            if (string3 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string3, extSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    if (!string2.endsWith(string4)) continue;
                    return true;
                }
            }
            return false;
        }
        throw new UnknownMIMEType(670005, new Object[]{string}, null);
    }

    public String getMimeType(String string) {
        Enumeration enumeration = this.keys();
        String string2 = null;
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            Properties properties = (Properties)this.get(string2);
            String string3 = (String)properties.get(extsKey);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, extSeparator);
            boolean bl = false;
            while (stringTokenizer.hasMoreElements()) {
                String string4 = (String)stringTokenizer.nextElement();
                if (!string4.equals(string)) continue;
                return string2;
            }
        }
        return unknownType;
    }

    public String[] getExts(String string) {
        String[] stringArray = null;
        Properties properties = (Properties)this.get(string);
        if (properties != null) {
            String string2 = (String)properties.get(extsKey);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, extSeparator);
            int n = 0;
            stringArray = new String[stringTokenizer.countTokens()];
            while (stringTokenizer.hasMoreElements()) {
                String string3 = (String)stringTokenizer.nextElement();
                stringArray[n++] = string3;
            }
        }
        return stringArray;
    }

    public void putMimeType(String string, String string2, String[] stringArray) {
        Properties properties = new Properties();
        if (string2 != null) {
            properties.put(descKey, string2);
        }
        if (stringArray != null) {
            int n = stringArray.length;
            String string3 = "";
            int n2 = 0;
            while (n2 < n) {
                string3 = string3 + stringArray[n2];
                if (n2 + 1 < n) {
                    string3 = string3 + extSeparator;
                }
                ++n2;
            }
            if (string3.length() > 0) {
                properties.put(extsKey, string3);
            }
        }
        this.put(string, properties);
    }

    public void save(OutputStream outputStream) {
        PrintWriter printWriter;
        try {
            printWriter = CSUtil.getUrlEncoding() != null ? new PrintWriter(new OutputStreamWriter(outputStream, CSUtil.getUrlEncoding())) : new PrintWriter(new OutputStreamWriter(outputStream, "ISO-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        }
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Properties properties = (Properties)this.get(string);
            printWriter.println(string + ": \\");
            Enumeration<Object> enumeration2 = properties.keys();
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                printWriter.print('\t');
                printWriter.print(string2);
                printWriter.print('=');
                String string3 = (String)properties.get(string2);
                int n = string3.length();
                int n2 = 0;
                while (n2 < n) {
                    char c = string3.charAt(n2);
                    switch (c) {
                        case '\\': {
                            printWriter.print("\\\\");
                            break;
                        }
                        case '\t': {
                            printWriter.print("\\t");
                            break;
                        }
                        case '\n': {
                            printWriter.print("\\n");
                            break;
                        }
                        case '\r': {
                            printWriter.print("\\r");
                            break;
                        }
                        default: {
                            if (c < ' ' || c >= '\u007f') {
                                printWriter.print("\\u");
                                printWriter.print(MIMETypeTable.append(c >> 12 & 0xF));
                                printWriter.print(MIMETypeTable.append(c >> 8 & 0xF));
                                printWriter.print(MIMETypeTable.append(c >> 4 & 0xF));
                                printWriter.print(MIMETypeTable.append(c >> 0 & 0xF));
                                break;
                            }
                            printWriter.print(c);
                        }
                    }
                    ++n2;
                }
                printWriter.print(';');
                if (enumeration2.hasMoreElements()) {
                    printWriter.print(" \\");
                }
                printWriter.println();
            }
        }
        printWriter.close();
    }

    private void QOIV(String string, String string2) throws IOException {
        Object object;
        Object object2;
        string2 = string2.replace(';', '\n');
        if (string.equals("application/x-jrreport") && string2.indexOf(".clx") < 0) {
            object2 = string2.substring(0, string2.indexOf(10));
            object = string2.substring(string2.indexOf(10));
            string2 = (String)object2 + extSeparator + ".clx" + "\n" + (String)object;
        }
        object2 = new StringBufferInputStream(string2);
        object = new AsciiProperties();
        object.load((InputStream)object2);
        this.put(string, object);
    }

    private static char append(int n) {
        return QOIV[n & 0xF];
    }

    public static MIMETypeTable getDefaultMIMETypeTable() {
        MIMETypeTable mIMETypeTable = new MIMETypeTable();
        mIMETypeTable.charAt();
        return mIMETypeTable;
    }

    private void charAt() {
        String string = "application/x-jrcatalog";
        String string2 = "Catalog file";
        String[] stringArray = new String[]{".cat", ".cat.xml"};
        this.putMimeType(string, string2, stringArray);
        string = "application/x-jrreport";
        string2 = "Report file";
        stringArray = new String[]{".rpt", ".cls", ".clx", ".xpt", ".cls.xml"};
        this.putMimeType(string, string2, stringArray);
        this.putMimeType("application/postscript", null, new String[]{".ai", ".eps", ".ps"});
        this.putMimeType("audio/x-aiff", null, new String[]{".aif", ".aifc", ".aiff"});
        this.putMimeType("application/x-x509-ca-cert", null, new String[]{".cer", ".crt", ".der"});
        this.putMimeType("audio/basic", null, new String[]{".au", ".snd"});
        this.putMimeType("video/x-msvideo", null, new String[]{".avi"});
        this.putMimeType("video/x-rad-screenplay", null, new String[]{".avx"});
        this.putMimeType("application/x-bcpio", null, new String[]{".bcpio"});
        this.putMimeType(unknownType, null, new String[]{".bin", ".exe", ".csv"});
        this.putMimeType("text/html", null, new String[]{".body", ".htm", ".html"});
        this.putMimeType("application/x-netcdf", null, new String[]{".cdf", ".nc"});
        this.putMimeType("application/java", null, new String[]{".class"});
        this.putMimeType("application/x-cpio", null, new String[]{".cpio"});
        this.putMimeType("application/x-csh", null, new String[]{".csh"});
        this.putMimeType("application/x-dvi", null, new String[]{".dvi"});
        this.putMimeType("text/x-setext", null, new String[]{".etx"});
        this.putMimeType("image/gif", null, new String[]{".gif"});
        this.putMimeType("application/x-gtar", null, new String[]{".gtar"});
        this.putMimeType("application/x-gzip", null, new String[]{".gz"});
        this.putMimeType("application/x-hdf", null, new String[]{".hdf"});
        this.putMimeType("application/mac-binhex40", null, new String[]{".hqx"});
        this.putMimeType("image/ief", null, new String[]{".ief"});
        this.putMimeType("text/plain", null, new String[]{".java", ".txt"});
        this.putMimeType("image/jpeg", null, new String[]{".jpe", ".jpeg", ".jpg"});
        this.putMimeType("application/x-latex", null, new String[]{".latex"});
        this.putMimeType("application/x-troff-man", null, new String[]{".man"});
        this.putMimeType("application/x-troff-me", null, new String[]{".me"});
        this.putMimeType("application/x-mif", null, new String[]{".mif"});
        this.putMimeType("video/quicktim", null, new String[]{".mov", ".qt"});
        this.putMimeType("video/x-sgi-movie", null, new String[]{".movie"});
        this.putMimeType("video/mpeg", null, new String[]{".mpe", ".mpeg", ".mpg"});
        this.putMimeType("video/x-mpeg-2", null, new String[]{".mpv2"});
        this.putMimeType("application/x-troff-ms", null, new String[]{".ms"});
        this.putMimeType("application/oda", null, new String[]{".oda"});
        this.putMimeType("image/x-portable-bitmap", null, new String[]{".pdm"});
        this.putMimeType("application/pdf", null, new String[]{".pdf"});
        this.putMimeType("application/x-perl", null, new String[]{".perl", ".pl"});
        this.putMimeType("application/x-portable-graymap", null, new String[]{".pgm"});
        this.putMimeType("image/x-portable-anymap", null, new String[]{".pnm"});
        this.putMimeType("image/x-protable-pixmap", null, new String[]{".ppm"});
        this.putMimeType("image/x-cmu-raster", null, new String[]{".ras"});
        this.putMimeType("image/x-rgb", null, new String[]{".rgb"});
        this.putMimeType("application/x-troff", null, new String[]{".roff", ".t", ".tr"});
        this.putMimeType("application/rtf", null, new String[]{".rtf"});
        this.putMimeType("text/richtext", null, new String[]{".rtx"});
        this.putMimeType("application/x-sh", null, new String[]{".sh"});
        this.putMimeType("application/x-shar", null, new String[]{".shar"});
        this.putMimeType("java-internal/parsed-html", null, new String[]{".shtml"});
        this.putMimeType("application/x-wais-source", null, new String[]{".src"});
        this.putMimeType("application/x-sv4cpio", null, new String[]{".sv4cpio"});
        this.putMimeType("application/x-sv4crc", null, new String[]{".sv4crc"});
        this.putMimeType("application/x-tar", null, new String[]{".tar"});
        this.putMimeType("application/x-tcl", null, new String[]{".tcl"});
        this.putMimeType("application/x-tex", null, new String[]{".tex"});
        this.putMimeType("application/x-texinfo", null, new String[]{".texi", ".texinfo"});
        this.putMimeType("image/tiff", null, new String[]{".tif", ".tiff"});
        this.putMimeType("text/tab-separated-values", null, new String[]{".tsv"});
        this.putMimeType("application/x-ustar", null, new String[]{".ustar"});
        this.putMimeType("audio/x-wav", null, new String[]{".wav"});
        this.putMimeType("x-world/x-vrml", null, new String[]{".wrl"});
        this.putMimeType("image/x-xbitmap", null, new String[]{".xbm"});
        this.putMimeType("image/x-xpixmap", null, new String[]{".xpm"});
        this.putMimeType("image/x-xwindowdump", null, new String[]{".xwd"});
        this.putMimeType("application/x-compress", null, new String[]{".Z"});
        this.putMimeType("application/zip", null, new String[]{".zip"});
        this.putMimeType("application/x-jar", null, new String[]{".jar"});
        this.putMimeType("application/x-jreport-result", null, new String[]{".rst"});
        this.putMimeType("application/x-jreport-result", null, new String[]{".ast"});
        this.putMimeType("application/x-jreport_temp", null, new String[]{".temp"});
        this.putMimeType("application/x-msexcel", null, new String[]{".xls"});
        this.putMimeType("application/svg", null, new String[]{".svg"});
        this.putMimeType("application/xml", null, new String[]{".xml"});
        this.putMimeType("text/xml", null, new String[]{".xml"});
        this.putMimeType("application/xml-external-parsed-entity", null, new String[]{".xml", ".ent"});
        this.putMimeType("text/xml-external-parsed-entity", null, new String[]{".xml", ".ent"});
        this.putMimeType("application/xml-dtd", null, new String[]{".dtd", ".mod"});
        this.putMimeType("application/x-javascript", null, new String[]{".js"});
        this.putMimeType("text/css", null, new String[]{".css"});
        this.putMimeType("image/icon", null, new String[]{".ico"});
        this.putMimeType("text", null, new String[]{".param"});
    }
}

