/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import jet.controls.JetObject;
import jet.jetc.JetCReader;
import jet.jetc.ReadFailureException;
import jet.jetc.ReportLoader;
import jet.report.JReportUtil;
import jet.report.JetRptReportPanel;
import jet.reportset.JetRptReportSet;
import jet.server.jrserver.JRCatConnectionInfo;
import jet.server.log.ServiceLogger;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUUniverse;
import jet.universe.JetUUserDataSource;
import jet.universe.JetUXMLConnection;
import jet.universe.exception.UniverseFileException;

public class RefResource {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Vector getFontFiles(String string, String string2) throws Exception {
        if (string == null) {
            return null;
        }
        Vector[] vectorArray = null;
        if (string.endsWith(".rpt")) {
            ReportLoader reportLoader = new ReportLoader(string);
            JetObject jetObject = reportLoader.load();
            if (jetObject instanceof JetRptReportPanel) {
                vectorArray = JReportUtil.getInternalResource((JetRptReportPanel)((JetRptReportPanel)jetObject), (String)string2, null);
                return vectorArray[JReportUtil.IRT_FONT];
            } else {
                if (!(jetObject instanceof JetRptReportSet)) return null;
                vectorArray = JReportUtil.getInternalResource((JetRptReportSet)((JetRptReportSet)jetObject), (String)string2, null);
            }
            return vectorArray[JReportUtil.IRT_FONT];
        } else {
            vectorArray = JReportUtil.getReportResource((String)string, (String)string2, null);
        }
        return vectorArray[JReportUtil.IRT_FONT];
    }

    public static Vector getStyleFilesByExt(String string) throws IOException {
        String[] stringArray;
        File file;
        Vector<String> vector = new Vector<String>();
        if (string != null && (file = new File(string)).exists() && file.isDirectory() && (stringArray = file.list()).length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].endsWith("_stl.xsd") || stringArray[n].endsWith(".css")) {
                    vector.addElement(string + File.separator + stringArray[n]);
                }
                ++n;
            }
        }
        return vector;
    }

    public static Vector[] getRptFiles(String string) throws Exception {
        return JReportUtil.getReportResource((String)string, (boolean)true);
    }

    public static Vector[] getRptFilesWithoutEnv(String string, String string2) throws Exception {
        return JReportUtil.getReportResource((String)string, (boolean)false, (String)string2, null);
    }

    public static Vector getCatRefFiles(String string) throws Exception {
        File file = new File(string);
        String string2 = file.getParent();
        Vector vector = JReportUtil.getRelaCatalFiles((String)string2);
        return vector;
    }

    public static Vector getHdsFiles(String string, String string2) throws ReadFailureException, UniverseFileException, IOException {
        if (string == null || string2 == null) {
            return null;
        }
        Vector vector = new Vector();
        JetCReader jetCReader = new JetCReader(null, true);
        JetObject jetObject = jetCReader.read(string2);
        File file = new File(string);
        JetUUniverse jetUUniverse = JetUUniverse.LoadNoCache((String)file.getParent(), (String)file.getName());
        vector = JReportUtil.getHdsFiles((JetUUniverse)jetUUniverse, (JetRptReportSet)((JetRptReportSet)jetObject));
        return vector;
    }

    public static boolean hasHierDataSource(String string) throws ReadFailureException, UniverseFileException, IOException {
        if (string == null) {
            return false;
        }
        File file = new File(string);
        JetUUniverse jetUUniverse = JetUUniverse.LoadNoCache((String)file.getParent(), (String)file.getName());
        if (jetUUniverse == null) {
            return false;
        }
        return jetUUniverse.hasHierDataSource();
    }

    public static Vector getCatConnectionInfo(String string) throws Exception {
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            Vector<Object> vector = new Vector<Object>();
            File file = new File(string);
            JetUUniverse jetUUniverse = JetUUniverse.LoadNoCache((String)file.getParent(), (String)file.getName());
            Vector vector2 = jetUUniverse.getAllDatabases();
            if (vector2 != null && !vector2.isEmpty()) {
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                String string8 = null;
                int n = 0;
                while (n < vector2.size()) {
                    Object object;
                    Vector vector3;
                    Object object2;
                    Vector vector4;
                    JetUDatabase jetUDatabase = (JetUDatabase)vector2.elementAt(n);
                    Vector vector5 = jetUDatabase.getConnections();
                    if (vector5 != null && !vector5.isEmpty()) {
                        int n2 = 0;
                        while (n2 < vector5.size()) {
                            vector4 = (JetUConnection)vector5.elementAt(n2);
                            string2 = vector4.getResourceName();
                            string3 = vector4.getDesc();
                            if (vector4 instanceof JetUJDBCConnection) {
                                string4 = ((JetUJDBCConnection)vector4).getURL();
                                string5 = ((JetUJDBCConnection)vector4).getJdbcDriver();
                                string6 = ((JetUJDBCConnection)vector4).getUID();
                                string7 = ((JetUJDBCConnection)vector4).getPSWD();
                                object2 = new JRCatConnectionInfo("JDBC Connection", string2, string3, string4, string5, string6, string7, null, null, null, null);
                                vector.addElement(object2);
                            }
                            if (vector4 instanceof JetUXMLConnection) {
                                string8 = ((JetUXMLConnection)vector4).getXMLMetadata().getInstSource().getInstURI();
                                object2 = new JRCatConnectionInfo("XML Connection", string2, null, null, null, null, null, null, string8, null, null);
                                vector.addElement(object2);
                            }
                            ++n2;
                        }
                    }
                    if ((vector3 = jetUDatabase.getDataSources()) != null && !vector3.isEmpty()) {
                        int n3 = 0;
                        while (n3 < vector3.size()) {
                            object2 = (JetUUserDataSource)vector3.elementAt(n3);
                            string2 = object2.getResourceName();
                            string3 = object2.getDesc();
                            object = new JRCatConnectionInfo("UDS", string2, string3, null, null, null, null, object2.getUDSClassName(), null, null, null);
                            vector.addElement(object);
                            ++n3;
                        }
                    }
                    if ((vector4 = jetUDatabase.getHierDataSources()) != null && !vector4.isEmpty()) {
                        int n4 = 0;
                        while (n4 < vector4.size()) {
                            object = (JetUHierDataSource)vector4.elementAt(n4);
                            string2 = object.getResourceName();
                            string3 = object.getDesc();
                            JRCatConnectionInfo jRCatConnectionInfo = new JRCatConnectionInfo("HDS", string2, string3, null, null, null, null, null, object.getURIValue(), object.getXSDValue(), object.getRootName());
                            vector.addElement(jRCatConnectionInfo);
                            ++n4;
                        }
                    }
                    ++n;
                }
            }
            return vector;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return null;
        }
    }
}

