/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.ServletContext;
import jet.server.util.AbstractResource;
import jet.server.util.Resource;
import jet.server.util.StringUtils;
import jet.server.util.WebUtils;

public class ServletContextResource
extends AbstractResource {
    private final ServletContext QOIV;
    private final String append;

    public ServletContextResource(ServletContext servletContext, String string) {
        if (servletContext == null) {
            throw new IllegalArgumentException("Cannot resolve ServletContextResource without ServletContext");
        }
        this.QOIV = servletContext;
        if (string == null) {
            throw new IllegalArgumentException("path is required");
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        this.append = StringUtils.cleanPath(string);
    }

    public final ServletContext getServletContext() {
        return this.QOIV;
    }

    public final String getPath() {
        return this.append;
    }

    public InputStream getInputStream() throws IOException {
        InputStream inputStream = this.QOIV.getResourceAsStream(this.append);
        if (inputStream == null) {
            throw new FileNotFoundException("Could not open " + this.getDescription());
        }
        return inputStream;
    }

    public URL getURL() throws IOException {
        URL uRL = this.QOIV.getResource(this.append);
        if (uRL == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be resolved to URL because it does not exist");
        }
        return uRL;
    }

    public File getFile() throws IOException {
        String string = WebUtils.getRealPath(this.QOIV, this.append);
        return new File(string);
    }

    public Resource createRelative(String string) throws IOException {
        String string2 = StringUtils.applyRelativePath(this.append, string);
        return new ServletContextResource(this.QOIV, string2);
    }

    public String getFilename() {
        return StringUtils.getFilename(this.append);
    }

    public String getDescription() {
        return "ServletContext resource [" + this.append + "]";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ServletContextResource) {
            ServletContextResource servletContextResource = (ServletContextResource)object;
            return this.QOIV.equals(servletContextResource.QOIV) && this.append.equals(servletContextResource.append);
        }
        return false;
    }

    public int hashCode() {
        return this.append.hashCode();
    }
}

