/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jet.server.log.ServiceLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XMLUtil {
    public static Document newDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ServiceLogger.logError(parserConfigurationException, 2);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static Document loadDocument(String string) {
        Document document;
        block19: {
            BufferedInputStream bufferedInputStream = null;
            document = null;
            File file = new File(string);
            if (file.exists()) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                document = documentBuilder.parse(bufferedInputStream);
                Object var10_9 = null;
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException, 3);
                }
                break block19;
                {
                    catch (FileNotFoundException fileNotFoundException) {
                        ServiceLogger.logError(fileNotFoundException, 2);
                        Document document2 = null;
                        Object var10_10 = null;
                        try {
                            bufferedInputStream.close();
                        }
                        catch (IOException iOException) {
                            ServiceLogger.logError(iOException, 3);
                        }
                        return document2;
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        ServiceLogger.logError(parserConfigurationException, 2);
                        Document document3 = null;
                        Object var10_11 = null;
                        try {
                            bufferedInputStream.close();
                        }
                        catch (IOException iOException) {
                            ServiceLogger.logError(iOException, 3);
                        }
                        return document3;
                    }
                    catch (SAXException sAXException) {
                        ServiceLogger.logError(sAXException, 2);
                        Document document4 = null;
                        Object var10_12 = null;
                        try {
                            bufferedInputStream.close();
                        }
                        catch (IOException iOException) {
                            ServiceLogger.logError(iOException, 3);
                        }
                        return document4;
                    }
                    catch (IOException iOException) {
                        ServiceLogger.logError(iOException, 2);
                        Document document5 = null;
                        Object var10_13 = null;
                        try {
                            bufferedInputStream.close();
                        }
                        catch (IOException iOException2) {
                            ServiceLogger.logError(iOException2, 3);
                        }
                        return document5;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {
                        ServiceLogger.logError(iOException, 3);
                    }
                    throw throwable;
                }
            }
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static synchronized void saveDocument(Document document, String string) {
        block14: {
            OutputStreamWriter outputStreamWriter = null;
            Document document2 = document;
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            DOMSource dOMSource = new DOMSource(document2);
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(string)), "UTF-8");
            StreamResult streamResult = new StreamResult(outputStreamWriter);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(dOMSource, streamResult);
            Object var9_12 = null;
            try {
                outputStreamWriter.close();
            }
            catch (IOException iOException) {}
            break block14;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    ServiceLogger.logError(fileNotFoundException, 2);
                    Object var9_13 = null;
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {}
                    break block14;
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    ServiceLogger.logError(transformerConfigurationException, 2);
                    Object var9_14 = null;
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {}
                    break block14;
                }
                catch (TransformerException transformerException) {
                    ServiceLogger.logError(transformerException, 2);
                    Object var9_15 = null;
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {}
                    break block14;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    ServiceLogger.logError(unsupportedEncodingException, 2);
                    Object var9_16 = null;
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_17 = null;
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public static synchronized Element[] getChildElements(Element element) {
        if (element == null) {
            return null;
        }
        Vector<Element> vector = new Vector<Element>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                vector.add((Element)node);
            }
            node = node.getNextSibling();
        }
        Element[] elementArray = new Element[vector.size()];
        vector.toArray(elementArray);
        return elementArray;
    }

    public static synchronized Element[] getChildElements(Element element, String string) {
        if (element == null || string == null || string.length() == 0) {
            return null;
        }
        Vector<Element> vector = new Vector<Element>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element && node.getNodeName().equals(string)) {
                vector.add((Element)node);
            }
            node = node.getNextSibling();
        }
        Element[] elementArray = new Element[vector.size()];
        vector.toArray(elementArray);
        return elementArray;
    }

    public static synchronized Node[] getChildNodes(Node node) {
        if (node == null) {
            return null;
        }
        Vector<Element> vector = new Vector<Element>();
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            vector.add((Element)node2);
            node2 = node2.getNextSibling();
        }
        Node[] nodeArray = new Element[vector.size()];
        vector.toArray(nodeArray);
        return nodeArray;
    }

    public static synchronized Element getChildElement(Element element, String string) {
        if (element == null || string == null || string.length() == 0) {
            return null;
        }
        Element element2 = null;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element && node.getNodeName().equals(string)) {
                element2 = (Element)node;
                break;
            }
            node = node.getNextSibling();
        }
        return element2;
    }

    public static synchronized Element getChildElement(Element element) {
        if (element == null) {
            return null;
        }
        Element element2 = null;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                element2 = (Element)node;
                break;
            }
            node = node.getNextSibling();
        }
        return element2;
    }

    public static synchronized String[] getElenentValues(Element element) {
        if (element == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Text) {
                vector.add(node.getNodeValue());
            }
            node = node.getNextSibling();
        }
        String[] stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        return stringArray;
    }

    public static synchronized String getElenentValue(Element element) {
        if (element == null) {
            return null;
        }
        String string = null;
        Node node = element.getFirstChild();
        while (node != null) {
            String string2;
            if (node instanceof Text && (string2 = node.getNodeValue()) != null && string2.length() != 0 && string2.trim().length() != 0) {
                string = string2;
                break;
            }
            node = node.getNextSibling();
        }
        return string;
    }

    public static synchronized Element getElementByName(Element element, String string) {
        if (element == null || string == null || string.length() == 0) {
            return null;
        }
        String string2 = null;
        Element[] elementArray = XMLUtil.getChildElements(element);
        int n = 0;
        while (n < elementArray.length) {
            string2 = elementArray[n].getNodeName();
            if (string.equals(string2)) {
                return elementArray[n];
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < elementArray.length) {
            Element element2 = XMLUtil.getElementByName(elementArray[n2], string);
            if (element2 != null) {
                return element2;
            }
            ++n2;
        }
        return null;
    }

    public static synchronized Element getElementByAttr(Element element, String string, String string2) {
        return XMLUtil.getElementByAttr(element, string, string2, true);
    }

    public static synchronized Element getElementByAttr(Element element, String string, String string2, boolean bl) {
        if (element == null || string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return null;
        }
        String string3 = null;
        Element[] elementArray = XMLUtil.getChildElements(element);
        int n = 0;
        while (n < elementArray.length) {
            string3 = elementArray[n].getAttribute(string);
            if (string2.equals(string3)) {
                return elementArray[n];
            }
            ++n;
        }
        if (bl) {
            int n2 = 0;
            while (n2 < elementArray.length) {
                Element element2 = XMLUtil.getElementByAttr(elementArray[n2], string, string2);
                if (element2 != null) {
                    return element2;
                }
                ++n2;
            }
        }
        return null;
    }

    public static synchronized void appendElement(Element element, Node node) {
        if (element == null || node == null) {
            return;
        }
        Document document = element.getOwnerDocument();
        Node node2 = document.importNode(node, true);
        element.appendChild(node2);
        element.appendChild(document.createTextNode("\n\t"));
    }

    public static synchronized void insertElement(Element element, Node node) {
        XMLUtil.insertElement(element, node, 0);
    }

    public static synchronized void insertElement(Element element, Node node, int n) {
        if (element == null || node == null) {
            return;
        }
        Element[] elementArray = XMLUtil.getChildElements(element);
        if (elementArray == null || elementArray.length == 0) {
            return;
        }
        int n2 = n;
        if (n2 <= 0) {
            n2 = 1;
        }
        if (n2 > elementArray.length) {
            n2 = elementArray.length;
        }
        Document document = element.getOwnerDocument();
        Node node2 = document.importNode(node, true);
        Element element2 = elementArray[n2 - 1];
        element.insertBefore(node2, element2);
        element.insertBefore(document.createTextNode("\n\t"), element2);
    }

    public static synchronized void setAttribute(Element element, String string, String string2) {
        if (element == null || string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return;
        }
        element.setAttribute(string, string2);
    }

    public static synchronized String getAttribute(Element element, String string) {
        return XMLUtil.getAttribute(element, string, null);
    }

    public static synchronized String getAttribute(Element element, String string, String string2) {
        if (element == null || string == null || string.length() == 0) {
            return string2;
        }
        return element.getAttribute(string);
    }

    public static synchronized void removeElement(Element element, String[] stringArray) {
        if (element == null || stringArray == null || stringArray.length == 0) {
            return;
        }
        Vector<Element> vector = new Vector<Element>();
        Element[] elementArray = XMLUtil.getChildElements(element);
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string != null && string.length() != 0) {
                int n2 = 0;
                while (n2 < elementArray.length) {
                    if (string.equals(elementArray[n2].getNodeName())) {
                        vector.add(elementArray[n2]);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            element.removeChild((Element)vector.get(n3));
            ++n3;
        }
    }

    public static synchronized void removeElement(Element element, Element element2) {
        if (element == null || element2 == null) {
            return;
        }
        element.removeChild(element2);
    }

    public static synchronized void deleteXMLFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
    }
}

