/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util.nls;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import jet.server.util.ClassUtils;

public abstract class PropertyMessageResourcesFactory {
    protected static Locale defalutLocale = Locale.ENGLISH;
    protected Map messages = new HashMap();
    protected String languagePath;
    protected boolean inited = false;
    protected Locale locale;
    protected String localeDir;

    protected PropertyMessageResourcesFactory(String string) {
        this.locale = new Locale(string);
        this.localeDir = string.replace('_', '-');
    }

    protected synchronized void init() {
        String string;
        String string2;
        Properties properties;
        if (this.inited) {
            return;
        }
        String string3 = "resources" + File.separator + "server" + File.separator + "languages" + File.separator;
        if (this.languagePath != null && this.languagePath.trim().length() > 0 && !(string3 = this.languagePath).endsWith("/") && !string3.endsWith("\\")) {
            string3 = string3 + File.separator;
        }
        if ((properties = PropertyMessageResourcesFactory.loadResources(string2 = (string = string3 + this.localeDir.toLowerCase() + File.separator + "properties" + File.separator) + this.getFileName(), this.languagePath == null || this.languagePath.trim().length() == 0)) != null) {
            Iterator<Object> iterator = properties.keySet().iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                String string5 = properties.getProperty(string4);
                this.messages.put(string4, string5);
            }
        }
        this.inited = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Properties loadResources(String string, boolean bl) {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            try {
                if (!bl) {
                    inputStream = new FileInputStream(new File(string));
                } else {
                    ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
                    inputStream = classLoader.getResourceAsStream(string.replace('\\', '/'));
                }
                if (inputStream != null) {
                    properties.load(inputStream);
                }
            }
            catch (Throwable throwable) {
                Properties properties2 = null;
                Object var7_7 = null;
                try {
                    if (inputStream == null) return properties2;
                    inputStream.close();
                    return properties2;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {}
            catch (IOException iOException) {
                return null;
            }
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return null;
        }
        if (inputStream == null) return properties;
        inputStream.close();
        return properties;
    }

    public String getMessage(String string) {
        return this.getMessage(string, new Object[0]);
    }

    protected abstract PropertyMessageResourcesFactory findFactory(String var1);

    public String getMessage(String string, Object[] objectArray) {
        this.init();
        String string2 = (String)this.messages.get(string);
        if (string2 == null) {
            string2 = "";
        }
        MessageFormat messageFormat = new MessageFormat(PropertyMessageResourcesFactory.escape(string2));
        messageFormat.setLocale(this.locale);
        return messageFormat.format(objectArray);
    }

    protected String getDefaultMessage(String string, Object[] objectArray) {
        String string2 = null;
        if (this.locale.getCountry() != null && this.locale.getCountry().trim().length() > 0) {
            PropertyMessageResourcesFactory propertyMessageResourcesFactory = this.findFactory(this.locale.getLanguage());
            propertyMessageResourcesFactory.setLanguagePath(this.languagePath);
            string2 = propertyMessageResourcesFactory.getMessage(string, objectArray);
        } else if (!this.locale.equals(defalutLocale)) {
            PropertyMessageResourcesFactory propertyMessageResourcesFactory = this.findFactory(defalutLocale.toString());
            propertyMessageResourcesFactory.setLanguagePath(this.languagePath);
            string2 = propertyMessageResourcesFactory.getMessage(string, objectArray);
        }
        if (string2 == null || string2.trim().length() == 0) {
            string2 = "???" + string + "???";
        }
        return string2;
    }

    protected abstract String getFileName();

    protected static String escape(String string) {
        if (string == null || string.indexOf(39) < 0) {
            return string;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\'') {
                stringBuffer.append('\'');
            }
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String getLanguagePath() {
        return this.languagePath;
    }

    public void setLanguagePath(String string) {
        if (string != null && string.equals(this.languagePath)) {
            return;
        }
        if (string == null && this.languagePath == null) {
            return;
        }
        this.languagePath = string;
        this.inited = false;
    }
}

