/*
 * Decompiled with CFR 0.152.
 */
package jet.web.dhtml;

import javax.servlet.http.HttpServletRequest;
import jet.server.api.RemoteFileService;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.api.rmi.RemoteDispatcherFactory;
import jet.server.log.ServiceLogger;

public class DHTMLHttpUtil {
    private static boolean QOIV = false;

    public static boolean isRemoteServer() {
        return QOIV;
    }

    private static HttpRptServer QOIV(HttpServletRequest httpServletRequest) {
        HttpRptServer httpRptServer = null;
        try {
            httpRptServer = RemoteDispatcherFactory.getInstance().getDispatchedServer(httpServletRequest);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return httpRptServer;
    }

    private static RemoteFileService append(HttpServletRequest httpServletRequest) {
        RemoteFileService remoteFileService = null;
        try {
            remoteFileService = RemoteDispatcherFactory.getInstance().getDispatchedFileService(httpServletRequest);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return remoteFileService;
    }

    public static HttpRptServer getHttpRptServer(HttpServletRequest httpServletRequest) {
        if (httpServletRequest != null && QOIV) {
            return DHTMLHttpUtil.QOIV(httpServletRequest);
        }
        return HttpUtil.getHttpRptServer();
    }

    public static RemoteFileService getRemoteFileService(HttpServletRequest httpServletRequest) {
        if (QOIV) {
            return DHTMLHttpUtil.append(httpServletRequest);
        }
        return HttpUtil.getRemoteFileService();
    }

    public static String getWebAppUrl(HttpServletRequest httpServletRequest, String string) {
        String string2 = "";
        if (DHTMLHttpUtil.useRelativeWebAppUrl(httpServletRequest)) {
            String string3;
            int n;
            String string4;
            String string5 = HttpUtil.getServletPath(httpServletRequest);
            if (string5.endsWith(".jsp")) {
                string5 = string5.substring(0, string5.lastIndexOf("/"));
            }
            if (!(string4 = string).startsWith("/")) {
                string4 = "/" + string4;
            }
            while ((n = string4.indexOf("/", 1)) != -1 && string5.startsWith(string3 = string4.substring(0, n))) {
                string5 = string5.substring(n);
                string4 = string4.substring(n);
            }
            n = 0;
            if (string5.equals("/")) {
                string5 = "";
            }
            while ((n = string5.indexOf("/", n)) != -1) {
                string2 = string2 + "../";
                ++n;
            }
            string2 = string2 + string4.substring(1);
        } else {
            string2 = string;
            if (!string2.startsWith("/")) {
                string2 = "/" + string2;
            }
        }
        return string2;
    }

    public static boolean useRelativeWebAppUrl(HttpServletRequest httpServletRequest) {
        if (QOIV) {
            return DHTMLHttpUtil.QOIV(httpServletRequest).getServerEnv().getWebPageOptions().useRelativeWebAppUrl();
        }
        return HttpUtil.useRelativeWebAppUrl();
    }

    public static String getJSPWebAppName(HttpServletRequest httpServletRequest, String string) {
        if (QOIV) {
            return DHTMLHttpUtil.QOIV(httpServletRequest).getServerEnv().getWebPageOptions().getJSPWebAppName(string);
        }
        return HttpUtil.getJSPWebAppName("jsp.webapp.dhtml");
    }

    static {
        if (System.getProperty("jrs.remote.dispatcher") != null) {
            QOIV = true;
        }
    }
}

