/*
 * Decompiled with CFR 0.152.
 */
package jet.web.dhtml;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jet.server.api.TooManyUsersException;
import jet.server.api.exception.NoRemoteServerException;
import jet.server.api.http.HttpUtil;
import jet.server.api.http.TooManyTimesException;
import jet.server.servlets.JRServlet;
import jet.web.dhtml.DHTMLClientService;
import jet.web.dhtml.DHTMLConfig;
import jet.web.dhtml.DHTMLServiceFactory;
import jet.web.dhtml.DHTMLUtil;
import jet.web.dhtml.JDErrorMsgException;
import jet.webreport.client.DHTMLContext;

public class DHTMLRunReportlet
extends JRServlet {
    private ServletContext QOIV;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.QOIV = servletConfig.getServletContext();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Hashtable hashtable = null;
        DHTMLClientService dHTMLClientService = null;
        try {
            try {
                if (!HttpUtil.checkLogin(httpServletRequest, httpServletResponse)) {
                    return;
                }
            }
            catch (TooManyUsersException tooManyUsersException) {
                throw new JDErrorMsgException(910038);
            }
            catch (TooManyTimesException tooManyTimesException) {
                throw new JDErrorMsgException(910039);
            }
            catch (NoRemoteServerException noRemoteServerException) {
                throw new JDErrorMsgException(910040);
            }
            dHTMLClientService = DHTMLServiceFactory.getDHTMLClientService(httpServletRequest);
            this.QOIV(httpServletRequest, httpServletResponse, dHTMLClientService);
            hashtable = new Hashtable();
            Map map = DHTMLUtil.runReport(httpServletRequest, hashtable);
            String string = null;
            String string2 = null;
            if (map != null) {
                string2 = (String)map.get("errorMsg");
                string = (String)map.get("targeturi");
                if (string2 != null && !string2.trim().equals("")) {
                    PrintWriter printWriter = httpServletResponse.getWriter();
                    printWriter.print(string2);
                    return;
                }
                if (string != null && !string.trim().equals("")) {
                    httpServletResponse.sendRedirect(string);
                }
            }
        }
        catch (Exception exception) {
            DHTMLUtil.sendToErrorpage(httpServletRequest, httpServletResponse, exception, true, false);
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    private void QOIV(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, DHTMLClientService dHTMLClientService) {
        DHTMLConfig dHTMLConfig = dHTMLClientService.getDHTMLConfig();
        String string = DHTMLUtil.getUserName(httpServletRequest);
        String string2 = DHTMLUtil.getSessionID(httpServletRequest);
        dHTMLClientService.createDHTMLSession(string2, string);
        httpServletRequest.setAttribute("jrd.forward", (Object)(httpServletRequest.getServletPath() + httpServletRequest.getPathInfo()));
        httpServletRequest.setAttribute("jrd.referer.let", (Object)"true");
        Properties properties = DHTMLContext.getSkins(httpServletRequest, this.QOIV);
        dHTMLConfig.setDHTMLSkins(string2, properties.toString());
        dHTMLConfig.setDHTMLContextPath(string2, DHTMLContext.getContextPath(httpServletRequest));
        dHTMLConfig.setDHTMLJspUrl(string2, DHTMLContext.getRelativeJspPath(httpServletRequest));
        dHTMLConfig.setDHTMLServletUrl(string2, null, DHTMLContext.getRelativeLetPath(httpServletRequest, "jet.web.dhtml.DHTMLlet"));
    }
}

