/*
 * Decompiled with CFR 0.152.
 */
package jet.webreport.service;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Vector;
import jet.connect.DbValue;
import jet.formula.ParamDesc;
import jet.webreport.beans.FieldValue;
import jet.webreport.beans.Parameter;

public final class ParameterKit {
    public static Parameter getParameter(ParamDesc paramDesc, Locale locale, long l) {
        Parameter parameter = new Parameter(paramDesc.getName());
        parameter.setDataType(paramDesc.getType());
        parameter.setFormatPattern(paramDesc.getLocalizedUserFormat(locale));
        parameter.setPrompt(paramDesc.getPrompt());
        parameter.setAllowTypeIn(paramDesc.isAllowTypeIn());
        parameter.setAllSelected(paramDesc.isAllSelected());
        parameter.setAllowAll(paramDesc.isAllowAll());
        int n = paramDesc.isRequired() ? 1 : 0;
        n |= ParameterKit.getIsOnlySelect(paramDesc) ? 2 : 0;
        n |= paramDesc.isReferedBy() ? 4 : 0;
        parameter.setMask(n |= paramDesc.isMultipleValue() ? 8 : 0);
        parameter.setAvailableValues(ParameterKit.getFieldValues(paramDesc, locale));
        if (!paramDesc.isMultipleValue()) {
            String string = ParameterKit.getRealValue(paramDesc, locale, l);
            parameter.setRealValues(new String[]{string});
            String string2 = ParameterKit.getDispValue(paramDesc, locale, l);
            parameter.setDispValues(new String[]{string2});
        } else {
            parameter.setRealValues(paramDesc.getMultiStrValue());
            parameter.setDispValues(paramDesc.getMultiStrValue());
        }
        if (paramDesc.isCascading()) {
            parameter.setCascadingInfo(paramDesc.getChainID(), paramDesc.getPreviousLevel(), paramDesc.getNextLevel());
        }
        return parameter;
    }

    public static ArrayList getFieldValues(ParamDesc paramDesc, Locale locale) {
        Vector vector;
        Vector vector2;
        if (paramDesc.getBeColumn() == 4) {
            String string = paramDesc.getFormat();
            vector2 = string != null && string.length() > 0 ? paramDesc.getDisplayValues(locale) : paramDesc.getValues();
            vector = paramDesc.getShowValues();
        } else {
            vector2 = vector = paramDesc.getDisplayValues(locale);
        }
        int n = vector.size();
        ArrayList<FieldValue> arrayList = new ArrayList<FieldValue>(n);
        int n2 = 0;
        while (n2 < n) {
            FieldValue fieldValue = new FieldValue();
            fieldValue.setMultiRealValue(new String[]{(String)vector2.get(n2)});
            fieldValue.setMultiDispValue(new String[]{(String)vector.get(n2)});
            arrayList.add(fieldValue);
            ++n2;
        }
        return arrayList;
    }

    public static String getRealValue(ParamDesc paramDesc, Locale locale, long l) {
        if (ParameterKit.isDynamicDate(paramDesc)) {
            DbValue dbValue = paramDesc.getDynamicValue(l, locale);
            return paramDesc.getDisplayValue(dbValue, locale);
        }
        return paramDesc.getDisplayValue(paramDesc.getValue(), locale);
    }

    public static String getDispValue(ParamDesc paramDesc, Locale locale, long l) {
        return paramDesc.getDisplayValue(paramDesc.getValue(), locale);
    }

    public static boolean isDynamicDate(ParamDesc paramDesc) {
        return paramDesc.isUseCurrentDate() || paramDesc.isUseCurrentDateWhenBlank();
    }

    public static boolean getIsOnlySelect(ParamDesc paramDesc) {
        return paramDesc.IsParameters() || paramDesc.isColumn();
    }
}

