/*
 * Decompiled with CFR 0.152.
 */
package jet.webreport.service.builder;

import chart.ChartDefinition;
import com.jinfonet.util.JDLog;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import jet.api.BLNodeInformation;
import jet.api.CatalogAPI;
import jet.report.JetRptCTCrossTab;
import jet.report.JetRptObject;
import jet.report.chart.JetRptChartPlatform;
import jet.reportLogic.objectInfo.CTHdFldInfo;
import jet.reportLogic.objectInfo.CrosstableInfo;
import jet.reportset.JetRptReport;
import jet.rptservice.api.FlyResourceScope;
import jet.rptservice.api.design.DesignService;
import jet.rptservice.design.DisplayName;
import jet.rptservice.design.FlyFormulaInfo;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.DataElementInfo;
import jet.universe.businesslogic.JBusinessLogic;
import jet.universe.businesslogic.impl.Category;
import jet.universe.businesslogic.impl.DetailInfo;
import jet.universe.businesslogic.impl.Dimension;
import jet.universe.businesslogic.impl.Measure;
import jet.web.dhtml.DHTMLRptSheet;
import jet.web.dhtml.DHTMLService;
import jet.web.dhtml.DToolkit;
import jet.web.dhtml.DataTools;
import jet.webreport.beans.DHTMLFlyResourceScope;
import jet.webreport.service.ComponentKit;
import jet.webreport.service.DataKit;
import jet.webreport.service.FlyResourceScopeImpl;
import jet.webreport.util.JNode;

public final class ResourceTreeBuilder {
    public static final String TYPE_DATASOURCE = "datasource";
    public static final String TYPE_COMPONENT = "component";
    public static final String TYPE_HANDLE = "handle";
    public static final String TYPE_CATEGORY = "category";
    public static final String TYPE_DIMENSION = "dimension";
    public static final String TYPE_MEASURE = "measure";
    public static final String TYPE_DETAIL = "detail";
    public static final String TYPE_SQLTYPE = "sql";
    public static final String TYPE_DYNAMIC = "dynamic";
    public static final String TYPE_DYNAMIC_FORMULA_ROOT = "dynamic.formula.root";
    public static final String TYPE_DYNAMIC_FORMULA_ADD = "dynamic.formula.add";
    public static final String TYPE_DYNAMIC_FORMULA = "dynamic.formula";
    public static final String TYPE_DYNAMIC_FORMULA_ERROR = "dynamic.formula.error";
    public static final String TYPE_DYNAMIC_FORMULA_USED = "dynamic.formula.used";
    public static final String TYPE_DYNAMIC_FORMULA_USED_ERROR = "dynamic.formula.used.error";
    public static final String TYPE_DYNAMIC_MEASURE_ROOT = "dynamic.measure.root";
    public static final String TYPE_DYNAMIC_MEASURE_ADD = "dynamic.measure.add";
    public static final String TYPE_DYNAMIC_MEASURE = "dynamic.measure";
    public static final String TYPE_DYNAMIC_MEASURE_ERROR = "dynamic.measure.error";
    public static final String TYPE_DYNAMIC_MEASURE_USED = "dynamic.measure.used";
    public static final String TYPE_DYNAMIC_MEASURE_USED_ERROR = "dynamic.measure.used.error";
    private DHTMLService QOIV = DHTMLService.getInstance();
    private DesignService add;
    private DHTMLRptSheet addAll;
    private static String[] addChild = new String[]{"CTCrossTab", "ChartPlatform"};

    public ResourceTreeBuilder() {
        this.add = this.QOIV.ds;
    }

    public ResourceTreeBuilder(DHTMLRptSheet dHTMLRptSheet) {
        this();
        this.addAll = dHTMLRptSheet;
    }

    public JNode buildReportDSTree(String string, String string2, String string3) {
        JNode jNode = new JNode("root");
        HashMap hashMap = new HashMap();
        List list = null;
        try {
            list = this.add.getAllBLNames(string, hashMap);
        }
        catch (Exception exception) {
            if (JDLog.isError((int)2)) {
                JDLog.error((int)2, (Throwable)exception);
            }
            return jNode;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            JNode jNode2 = new JNode(TYPE_DATASOURCE, string4, string4, null);
            jNode.addChild(jNode2);
            Vector vector = (Vector)hashMap.get(string4);
            if (vector == null) continue;
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                String string5 = (String)vector.get(n2);
                JNode jNode3 = this.add(string, string2, string3, string5);
                jNode2.addChild(jNode3);
                ++n2;
            }
        }
        return jNode;
    }

    public JNode buildReportDSTree(String string, String string2, String string3, String string4) {
        JNode jNode = new JNode("root");
        if (string4 == null) {
            Vector vector = this.QOIV(string, string2, string3);
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                String string5 = (String)iterator.next();
                JNode jNode2 = this.add(string, string2, string3, string5);
                if (jNode2 == null) continue;
                jNode.addChild(jNode2);
            }
        } else {
            JNode jNode3 = this.add(string, string2, string3, string4);
            if (jNode3 != null) {
                jNode.addChild(jNode3);
            }
        }
        return jNode;
    }

    private Vector QOIV(String string, String string2, String string3) {
        Vector vector = new Vector();
        String[] stringArray = DataKit.getReportEngineKeys(this.add, string, string2, string3);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                try {
                    Vector vector2 = this.add.getRCNameForUsedDataSet(string, string2, stringArray[n2]);
                    if (!vector.containsAll(vector2)) {
                        vector.addAll(vector2);
                    }
                }
                catch (Exception exception) {
                    if (!JDLog.isError((int)2)) break block4;
                    JDLog.error((int)2, (Throwable)exception);
                }
            }
            ++n2;
        }
        return vector;
    }

    private JNode add(String string, String string2, String string3, String string4) {
        Serializable serializable;
        JBusinessLogic jBusinessLogic;
        JNode jNode = null;
        try {
            jBusinessLogic = this.add.getBusinessLogicFromName(string, string2, string4, string3);
        }
        catch (Exception exception) {
            if (JDLog.isError((int)2)) {
                JDLog.error((int)2, (Throwable)exception);
            }
            return null;
        }
        String string5 = jBusinessLogic.getName();
        String string6 = jBusinessLogic.getDisplayName();
        string6 = string6 == null || string6.length() == 0 ? string5 : string6;
        String string7 = jBusinessLogic.getComment();
        jNode = new JNode(TYPE_HANDLE, string6, string4, string7);
        BLNode[] bLNodeArray = jBusinessLogic.getBLChildren();
        int n = 0;
        while (n < bLNodeArray.length) {
            serializable = this.addAll(string, string2, string3, string4, bLNodeArray[n]);
            if (serializable != null) {
                jNode.addChild((JNode)serializable);
            }
            ++n;
        }
        serializable = new DHTMLFlyResourceScope();
        serializable.setReportName(string2);
        serializable.setBLName(string4);
        jNode.addChild(this.equals(string, string2, (DHTMLFlyResourceScope)serializable));
        return jNode;
    }

    public JNode buildCubeNode(String string, String string2, String string3, HashMap hashMap) {
        Serializable serializable;
        JBusinessLogic jBusinessLogic;
        boolean bl = true;
        boolean bl2 = true;
        if (hashMap != null) {
            if (hashMap.get("DY_FORMULA") != null && hashMap.get("DY_FORMULA").equals("false")) {
                bl = false;
            }
            if (hashMap.get("DY_MEASURE") != null && hashMap.get("DY_MEASURE").equals("false")) {
                bl2 = false;
            }
        }
        JNode jNode = null;
        try {
            jBusinessLogic = this.add.getBusinessLogicFromName(string, string2, string3, null);
        }
        catch (Exception exception) {
            if (JDLog.isError((int)2)) {
                JDLog.error((int)2, (Throwable)exception);
            }
            return null;
        }
        String string4 = jBusinessLogic.getName();
        String string5 = jBusinessLogic.getDisplayName();
        string5 = string5 == null || string5.length() == 0 ? string4 : string5;
        String string6 = jBusinessLogic.getComment();
        jNode = new JNode(TYPE_HANDLE, string5, string3, string6);
        BLNode[] bLNodeArray = jBusinessLogic.getBLChildren();
        int n = 0;
        while (n < bLNodeArray.length) {
            serializable = this.addAll(string, string2, null, string3, bLNodeArray[n]);
            if (serializable != null) {
                jNode.addChild((JNode)serializable);
            }
            ++n;
        }
        serializable = new DHTMLFlyResourceScope();
        serializable.setReportName(string2);
        serializable.setBLName(string3);
        if (bl) {
            jNode.addChild(this.equalsIgnoreCase(string, string2, (DHTMLFlyResourceScope)serializable, false));
        }
        if (bl2) {
            jNode.addChild(this.error(string, string2, (DHTMLFlyResourceScope)serializable, false));
        }
        return jNode;
    }

    private JNode addAll(String string, String string2, String string3, String string4, BLNode bLNode) {
        JNode jNode;
        char c;
        String string5;
        String string6;
        JNode jNode2 = null;
        String string7 = "";
        BLNode[] bLNodeArray = null;
        int n = bLNode.getElementType();
        switch (n) {
            case 3: {
                string6 = TYPE_CATEGORY;
                string5 = ((Category)bLNode).getDisplayName();
                bLNodeArray = ((Category)bLNode).getBLChildren();
                break;
            }
            case 4: {
                string6 = TYPE_DIMENSION;
                string5 = ((Dimension)bLNode).getDisplayName();
                string7 = ((Dimension)bLNode).getPrompt();
                bLNodeArray = ((Dimension)bLNode).getBLChildren();
                break;
            }
            case 5: {
                string6 = TYPE_MEASURE;
                string5 = ((Measure)bLNode).getDisplayName();
                string7 = ((Measure)bLNode).getPrompt();
                bLNodeArray = ((Measure)bLNode).getBLChildren();
                break;
            }
            case 7: {
                string6 = TYPE_DETAIL;
                string5 = ((DetailInfo)bLNode).getDisplayName();
                string7 = ((DetailInfo)bLNode).getPrompt();
                break;
            }
            default: {
                return null;
            }
        }
        String string8 = bLNode.getComment();
        string7 = this.get(string7, string8);
        String string9 = bLNode.getBLQualifyName();
        jNode2 = new JNode(string6, string5, string9, string7);
        if (!TYPE_CATEGORY.equals(string6)) {
            block12: {
                c = 'u';
                try {
                    c = DataTools.getDataType(this.add.getDataSqlType(string, string2, string4, bLNode, string3));
                }
                catch (Exception exception) {
                    if (!JDLog.isError((int)2)) break block12;
                    JDLog.error((int)2, (Throwable)exception);
                }
            }
            jNode = new JNode(TYPE_SQLTYPE);
            jNode.setText(new String(new char[]{c}));
            jNode2.addChild(jNode);
        }
        if (bLNodeArray != null) {
            c = '\u0000';
            while (c < bLNodeArray.length) {
                jNode = this.addAll(string, string2, string3, string4, bLNodeArray[c]);
                if (jNode != null) {
                    jNode2.addChild(jNode);
                }
                ++c;
            }
        }
        return jNode2;
    }

    public JNode buildComponentDSTree(String string, String string2, String string3, String string4) {
        RuntimeException runtimeException;
        JNode jNode = null;
        JetRptObject jetRptObject = null;
        String string5 = null;
        if (string3 != null && string3.length() > 0 && !string3.equalsIgnoreCase("null")) {
            jetRptObject = this.addAll.getJetRptObject(string3);
            string5 = DToolkit.getSubReportKey(this.addAll, string3);
        } else if (string4 != null && string4.length() > 0 && !string4.equalsIgnoreCase("null")) {
            runtimeException = this.add.getReportSetById(string);
            JetRptReport jetRptReport = runtimeException.getReport(string2);
            jetRptObject = (JetRptObject)jetRptReport.nameToObject(string4);
        }
        if (jetRptObject != null) {
            jNode = this.addChild(string, string2, string5, jetRptObject);
        } else {
            runtimeException = new RuntimeException("JetRptObject is null");
            if (JDLog.isError((int)2)) {
                JDLog.error((int)2, (Throwable)runtimeException);
            }
        }
        return jNode;
    }

    private JNode addChild(String string, String string2, String string3, JetRptObject jetRptObject) {
        JNode jNode;
        BLNode bLNode;
        String string4;
        JetRptObject jetRptObject2 = ComponentKit.getMatchedParentComponent(jetRptObject, addChild);
        if (jetRptObject2 == null) {
            return null;
        }
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        this.append(linkedList, linkedList2, jetRptObject2);
        JNode jNode2 = new JNode("root");
        String string5 = jetRptObject2.getInstName();
        String string6 = jetRptObject2.getDisplayName();
        string6 = string6 == null || string6.length() == 0 ? string5 : string6;
        JNode jNode3 = new JNode(TYPE_COMPONENT, string6, string5, string6);
        jNode2.addChild(jNode3);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            string4 = (String)iterator.next();
            try {
                bLNode = this.add.getRefDataElement(string, string2, string5, string4, string3);
                string6 = ((DataElementInfo)bLNode).getDisplayName();
            }
            catch (Exception exception) {
                string6 = string4.substring(string4.lastIndexOf(".") + 1);
            }
            jNode = new JNode(TYPE_DIMENSION, string6, string4, string6);
            jNode3.addChild(jNode);
        }
        iterator = linkedList2.iterator();
        while (iterator.hasNext()) {
            string4 = (String)iterator.next();
            try {
                bLNode = this.add.getRefDataElement(string, string2, string5, string4, string3);
                string6 = ((DataElementInfo)bLNode).getDisplayName();
            }
            catch (Exception exception) {
                string6 = string4.substring(string4.lastIndexOf(".") + 1);
            }
            jNode = new JNode(TYPE_MEASURE, string6, string4, string6);
            jNode3.addChild(jNode);
        }
        return jNode2;
    }

    private void append(LinkedList linkedList, LinkedList linkedList2, JetRptObject jetRptObject) {
        block10: {
            String string;
            block9: {
                String string2;
                String string3;
                string = ComponentKit.getComponentType(jetRptObject);
                if (!"CTCrossTab".equals(string)) break block9;
                CrosstableInfo crosstableInfo = CrosstableInfo.getCrosstableInfo((JetRptCTCrossTab)((JetRptCTCrossTab)jetRptObject));
                int n = 0;
                n = crosstableInfo.getRowFldInfos().size();
                int n2 = 0;
                while (n2 < n) {
                    CTHdFldInfo cTHdFldInfo = crosstableInfo.getRowFldInfo(n2);
                    string3 = cTHdFldInfo.get_blColumnName();
                    if (string3 != null) {
                        linkedList.add(string3);
                    }
                    ++n2;
                }
                n = crosstableInfo.getColumnFldInfos().size();
                int n3 = 0;
                while (n3 < n) {
                    string3 = crosstableInfo.getColumnFldInfo(n3);
                    string2 = string3.get_blColumnName();
                    if (string2 != null) {
                        linkedList.add(string2);
                    }
                    ++n3;
                }
                n = crosstableInfo.getSummaryFldInfos().size();
                int n4 = 0;
                while (n4 < n) {
                    string2 = crosstableInfo.getSummaryFldInfo(n4);
                    String string4 = string2.get_blColumnName();
                    if (string4 != null) {
                        linkedList2.add(string4);
                    }
                    ++n4;
                }
                break block10;
            }
            if (!"ChartPlatform".equals(string)) break block10;
            ChartDefinition chartDefinition = ((JetRptChartPlatform)jetRptObject).getDefinition();
            String string5 = chartDefinition.getCategory();
            if (string5 != null) {
                linkedList.add(string5);
            }
            if ((string5 = chartDefinition.getSeries()) != null) {
                linkedList.add(string5);
            }
            String[] stringArray = chartDefinition.getIndexedFieldNames();
            int n = 0;
            while (n < stringArray.length) {
                linkedList2.add(stringArray[n]);
                ++n;
            }
        }
    }

    public JNode buildCatalogDSTree(CatalogAPI catalogAPI, String string) {
        JNode jNode = new JNode("root");
        String[] stringArray = catalogAPI.getDataSources();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            JNode jNode2 = new JNode(TYPE_DATASOURCE, string2, string2, null);
            String[] stringArray2 = catalogAPI.getBLViewHandles(string2, string);
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String string3 = stringArray2[n4];
                String string4 = catalogAPI.getString(string3, "DisplayName");
                if (string4 == null || string4.trim().length() == 0) {
                    string4 = catalogAPI.getString(string3, "name");
                }
                String string5 = catalogAPI.getString(string3, "Prompt");
                String string6 = catalogAPI.getString(string3, "Description");
                String string7 = this.get(string5, string6);
                JNode jNode3 = new JNode(TYPE_HANDLE, string4, string3, string7);
                this.checkFlyFormulaSyntax(catalogAPI, string, string3, jNode3);
                jNode2.addChild(jNode3);
                ++n4;
            }
            jNode.addChild(jNode2);
            ++n2;
        }
        return jNode;
    }

    private void checkFlyFormulaSyntax(CatalogAPI catalogAPI, String string, String string2, JNode jNode) {
        BLNodeInformation[] bLNodeInformationArray = catalogAPI.getBLNodeInformations(string2, string);
        if (bLNodeInformationArray == null) {
            return;
        }
        int n = bLNodeInformationArray.length;
        int n2 = 0;
        while (n2 < n) {
            BLNodeInformation bLNodeInformation = bLNodeInformationArray[n2];
            JNode jNode2 = null;
            int n3 = bLNodeInformation.getElementType();
            switch (n3) {
                case 18: {
                    jNode2 = this.containsAll(catalogAPI, string, bLNodeInformation, TYPE_CATEGORY);
                    break;
                }
                case 19: {
                    jNode2 = this.ds(catalogAPI, string, bLNodeInformation, TYPE_DIMENSION);
                    break;
                }
                case 20: {
                    jNode2 = this.ds(catalogAPI, string, bLNodeInformation, TYPE_MEASURE);
                    break;
                }
                case 22: {
                    jNode2 = this.ds(catalogAPI, string, bLNodeInformation, TYPE_DETAIL);
                    break;
                }
            }
            if (jNode2 != null) {
                jNode.addChild(jNode2);
            }
            ++n2;
        }
    }

    private JNode containsAll(CatalogAPI catalogAPI, String string, BLNodeInformation bLNodeInformation, String string2) {
        String string3 = bLNodeInformation.getHandle();
        String string4 = bLNodeInformation.getName();
        String string5 = bLNodeInformation.getDisplayName();
        if (string5 == null || string5.trim().length() == 0) {
            string5 = string4;
        }
        String string6 = bLNodeInformation.getDescription();
        JNode jNode = new JNode(string2, string5, string4, string6);
        this.checkFlyFormulaSyntax(catalogAPI, string, string3, jNode);
        return jNode;
    }

    private JNode ds(CatalogAPI catalogAPI, String string, BLNodeInformation bLNodeInformation, String string2) {
        Object object;
        String string3 = bLNodeInformation.getHandle();
        String string4 = catalogAPI.getBLNodeQualifyName(string3);
        String string5 = bLNodeInformation.getDisplayName();
        if (string5 == null || string5.trim().length() == 0) {
            string5 = string4;
        }
        String string6 = bLNodeInformation.getDescription();
        char c = DataTools.getDataType(bLNodeInformation.getSqlType());
        if (TYPE_MEASURE.equals(string2) && ((String)(object = catalogAPI.getString(string3, "AggregationFunction"))).indexOf("Count") != -1) {
            c = 'n';
        }
        object = new JNode(string2, string5, string4, string6);
        JNode jNode = new JNode(TYPE_SQLTYPE);
        jNode.setText(new String(new char[]{c}));
        ((JNode)object).addChild(jNode);
        if (string2.equals(TYPE_DETAIL)) {
            return object;
        }
        BLNodeInformation[] bLNodeInformationArray = catalogAPI.getBLNodeInformations(string3, string);
        int n = bLNodeInformationArray.length;
        int n2 = 0;
        while (n2 < n) {
            BLNodeInformation bLNodeInformation2 = bLNodeInformationArray[n2];
            if (bLNodeInformation2.getElementType() == 22) {
                JNode jNode2 = this.ds(catalogAPI, string, bLNodeInformation2, TYPE_DETAIL);
                ((JNode)object).addChild(jNode2);
            }
            ++n2;
        }
        return object;
    }

    private JNode equals(String string, String string2, DHTMLFlyResourceScope dHTMLFlyResourceScope) {
        JNode jNode = new JNode(TYPE_DYNAMIC, "Dynamic Resource", "_Dynamic_Resource", "");
        jNode.addChild(this.equalsIgnoreCase(string, string2, dHTMLFlyResourceScope, true));
        jNode.addChild(this.error(string, string2, dHTMLFlyResourceScope, true));
        return jNode;
    }

    private JNode equalsIgnoreCase(String string, String string2, DHTMLFlyResourceScope dHTMLFlyResourceScope, boolean bl) {
        JNode jNode;
        block10: {
            Serializable serializable;
            jNode = new JNode(TYPE_DYNAMIC_FORMULA_ROOT, "Formulas", "_Formulas", "");
            if (bl) {
                serializable = new JNode(TYPE_DYNAMIC_FORMULA_ADD, "<Add Formula...>", "_Formulas_Add", "");
                jNode.addChild((JNode)serializable);
            }
            try {
                serializable = new FlyResourceScopeImpl();
                ((DHTMLFlyResourceScope)serializable).setBLName(dHTMLFlyResourceScope.getBLName());
                ((DHTMLFlyResourceScope)serializable).setKeyword(dHTMLFlyResourceScope.getKeyword());
                ((DHTMLFlyResourceScope)serializable).setReportName(dHTMLFlyResourceScope.getReportName());
                DisplayName[] displayNameArray = this.add.getFlyFormulaDisplayNames(string, (FlyResourceScope)serializable);
                int n = 0;
                while (displayNameArray != null && n < displayNameArray.length) {
                    DisplayName displayName = displayNameArray[n];
                    FlyFormulaInfo flyFormulaInfo = this.add.getFlyFormulaInfo(string, (FlyResourceScope)serializable, displayName.getBlQualifiedDispName());
                    String string3 = this.QOIV.checkFlyFormulaSyntax(string, dHTMLFlyResourceScope, flyFormulaInfo.getExpression());
                    boolean bl2 = this.add.isUsedFlyResource(string, (FlyResourceScope)serializable, displayName.getBlQualifiedDispName());
                    JNode jNode2 = null;
                    if (string3 != null) {
                        if (bl2) {
                            jNode2 = new JNode(TYPE_DYNAMIC_FORMULA_USED_ERROR, displayName.getBlDisplayName(), displayName.getBlColumnName(), "");
                            jNode2.setAttribute("atts", "{dyType:'formula',blCName:'" + displayName.getBlColumnName() + "',blQName:'" + displayName.getBlQualifiedDispName() + "',error:true,used:true}");
                        } else {
                            jNode2 = new JNode(TYPE_DYNAMIC_FORMULA_ERROR, displayName.getBlDisplayName(), displayName.getBlColumnName(), "");
                            jNode2.setAttribute("atts", "{dyType:'formula',blCName:'" + displayName.getBlColumnName() + "',blQName:'" + displayName.getBlQualifiedDispName() + "',error:true,used:false}");
                        }
                    } else if (bl2) {
                        jNode2 = new JNode(TYPE_DYNAMIC_FORMULA_USED, displayName.getBlDisplayName(), displayName.getBlColumnName(), "");
                        jNode2.setAttribute("atts", "{dyType:'formula',blCName:'" + displayName.getBlColumnName() + "',blQName:'" + displayName.getBlQualifiedDispName() + "',error:false,used:true}");
                    } else {
                        jNode2 = new JNode(TYPE_DYNAMIC_FORMULA, displayName.getBlDisplayName(), displayName.getBlColumnName(), "");
                        jNode2.setAttribute("atts", "{dyType:'formula',blCName:'" + displayName.getBlColumnName() + "',blQName:'" + displayName.getBlQualifiedDispName() + "',error:false,used:false}");
                    }
                    JNode jNode3 = new JNode(TYPE_SQLTYPE);
                    jNode3.setText(new String(new char[]{DataTools.getDataType(displayName.getSqlType())}));
                    jNode2.addChild(jNode3);
                    jNode.addChild(jNode2);
                    ++n;
                }
            }
            catch (Exception exception) {
                if (!JDLog.isError((int)2)) break block10;
                JDLog.error((int)2, (Throwable)exception);
            }
        }
        return jNode;
    }

    private JNode error(String string, String string2, DHTMLFlyResourceScope dHTMLFlyResourceScope, boolean bl) {
        JNode jNode;
        block6: {
            Serializable serializable;
            jNode = new JNode(TYPE_DYNAMIC_MEASURE_ROOT, "Measures", "_Measures", "");
            if (bl) {
                serializable = new JNode(TYPE_DYNAMIC_MEASURE_ADD, "<Add Measure...>", "_Measures_Add", "");
                jNode.addChild((JNode)serializable);
            }
            try {
                serializable = new FlyResourceScopeImpl();
                ((DHTMLFlyResourceScope)serializable).setBLName(dHTMLFlyResourceScope.getBLName());
                ((DHTMLFlyResourceScope)serializable).setKeyword(dHTMLFlyResourceScope.getKeyword());
                ((DHTMLFlyResourceScope)serializable).setReportName(dHTMLFlyResourceScope.getReportName());
                DisplayName[] displayNameArray = this.add.getFlyMeasureDisplayNames(string, (FlyResourceScope)serializable);
                int n = 0;
                while (displayNameArray != null && n < displayNameArray.length) {
                    DisplayName displayName = displayNameArray[n];
                    JNode jNode2 = null;
                    boolean bl2 = this.add.isUsedFlyResource(string, (FlyResourceScope)serializable, displayName.getBlQualifiedDispName());
                    if (bl2) {
                        jNode2 = new JNode(TYPE_DYNAMIC_MEASURE_USED, displayName.getBlDisplayName(), displayName.getBlColumnName(), "");
                        jNode2.setAttribute("atts", "{dyType:'measure',blCName:'" + displayName.getBlColumnName() + "',blQName:'" + displayName.getBlQualifiedDispName() + "',used:true}");
                    } else {
                        jNode2 = new JNode(TYPE_DYNAMIC_MEASURE, displayName.getBlDisplayName(), displayName.getBlColumnName(), "");
                        jNode2.setAttribute("atts", "{dyType:'measure',blCName:'" + displayName.getBlColumnName() + "',blQName:'" + displayName.getBlQualifiedDispName() + "',used:false}");
                    }
                    JNode jNode3 = new JNode(TYPE_SQLTYPE);
                    jNode3.setText(new String(new char[]{DataTools.getDataType(displayName.getSqlType())}));
                    jNode2.addChild(jNode3);
                    jNode.addChild(jNode2);
                    ++n;
                }
            }
            catch (Exception exception) {
                if (!JDLog.isError((int)2)) break block6;
                JDLog.error((int)2, (Throwable)exception);
            }
        }
        return jNode;
    }

    private String get(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 != null && string2.length() > 0) {
            if (string.length() > 0) {
                string = string + "\r\n";
            }
            string = string + string2;
        }
        return string;
    }

    public static Properties getDefaultSetting(Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        String string = properties.getProperty("images.path", "");
        properties.setProperty("node.name.map", "text");
        properties.setProperty("node.value.map", "value");
        properties.setProperty("node.desc.map", "tip");
        properties.setProperty("root.tag", "jTree");
        properties.setProperty("datasource.tag", "jTreeNode");
        properties.setProperty("bussdata.tag", "jTreeNode");
        properties.setProperty("component.tag", "jTreeNode");
        properties.setProperty("category.tag", "jTreeNode");
        properties.setProperty("handle.tag", "jTreeNode");
        properties.setProperty("dimension.tag", "jTreeNode");
        properties.setProperty("measure.tag", "jTreeNode");
        properties.setProperty("detail.tag", "jTreeNode");
        properties.setProperty("sql.tag", "dType");
        properties.setProperty("dynamic.tag", "jTreeNode");
        properties.setProperty("dynamic.formula.root.tag", "jTreeNode");
        properties.setProperty("dynamic.formula.add.tag", "jTreeNode");
        properties.setProperty("dynamic.formula.error.tag", "jTreeNode");
        properties.setProperty("dynamic.formula.used.tag", "jTreeNode");
        properties.setProperty("dynamic.formula.used.error.tag", "jTreeNode");
        properties.setProperty("dynamic.formula.tag", "jTreeNode");
        properties.setProperty("dynamic.measure.root.tag", "jTreeNode");
        properties.setProperty("dynamic.measure.add.tag", "jTreeNode");
        properties.setProperty("dynamic.measure.tag", "jTreeNode");
        properties.setProperty("dynamic.measure.error.tag", "jTreeNode");
        properties.setProperty("dynamic.measure.used.tag", "jTreeNode");
        properties.setProperty("dynamic.measure.used.error.tag", "jTreeNode");
        properties.setProperty("att.1", "contractImg");
        properties.setProperty("att.2", "expandImg");
        properties.setProperty("att.3", "enableDrag");
        properties.setProperty("att.4", "expandLevel");
        properties.setProperty("att.5", "resourcePath");
        properties.setProperty("root.enableDrag", "false");
        properties.setProperty("root.expandLevel", "0");
        properties.setProperty("root.resourcePath", string);
        properties.setProperty("datasource.contractImg", string + "bussdata.gif");
        properties.setProperty("datasource.expandImg", string + "bussdata.gif");
        properties.setProperty("bussdata.contractImg", string + "bussdata.gif");
        properties.setProperty("bussdata.expandImg", string + "bussdata.gif");
        properties.setProperty("component.contractImg", string + "query.gif");
        properties.setProperty("component.expandImg", string + "query.gif");
        properties.setProperty("handle.contractImg", string + "bussdata.gif");
        properties.setProperty("handle.expandImg", string + "bussdata.gif");
        properties.setProperty("category.contractImg", string + "branch_c.gif");
        properties.setProperty("category.expandImg", string + "branch_o.gif");
        properties.setProperty("dimension.contractImg", string + "dimension.gif");
        properties.setProperty("dimension.expandImg", string + "dimension.gif");
        properties.setProperty("measure.contractImg", string + "measure.gif");
        properties.setProperty("measure.expandImg", string + "measure.gif");
        properties.setProperty("detail.contractImg", string + "detail.gif");
        properties.setProperty("detail.expandImg", string + "detail.gif");
        properties.setProperty("dynamic.contractImg", string + "formula.gif");
        properties.setProperty("dynamic.formula.root.contractImg", string + "formula.gif");
        properties.setProperty("dynamic.formula.add.contractImg", string + "addformula.gif");
        properties.setProperty("dynamic.formula.contractImg", string + "formula.gif");
        properties.setProperty("dynamic.formula.error.contractImg", string + "errorformula.gif");
        properties.setProperty("dynamic.formula.used.contractImg", string + "insertedformula.gif");
        properties.setProperty("dynamic.formula.used.error.contractImg", string + "inserterrorformula.gif");
        properties.setProperty("dynamic.measure.root.contractImg", string + "measure.gif");
        properties.setProperty("dynamic.measure.add.contractImg", string + "newmeasure.gif");
        properties.setProperty("dynamic.measure.error.contractImg", string + "errormeasure.gif");
        properties.setProperty("dynamic.measure.used.contractImg", string + "insertedmeasure.gif");
        properties.setProperty("dynamic.measure.used.error.contractImg", string + "inserterrormeasure.gif");
        properties.setProperty("dynamic.measure.contractImg", string + "measure.gif");
        return properties;
    }
}

