/*
 * Decompiled with CFR 0.152.
 */
package jet.webreport.service.builder;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.util.Properties;
import jet.datastream.Communicator;
import jet.datastream.DSTOC;
import jet.datastream.TOCNode;
import jet.web.dhtml.DHTMLService;
import jet.webreport.util.FileUtil;
import jet.webreport.util.JNode;
import util.Node;

public final class TOCTreeBuilder {
    public static final String TYPE_TOCNODE = "tocnode";
    public static final String TYPE_TOCGRP = "tocgrp";
    public static final String TYPE_PAGE = "page";
    public static final String TYPE_X = "x";
    public static final String TYPE_Y = "y";
    private DHTMLService QOIV = DHTMLService.getInstance();

    public JNode buildTOCTree(String string, String string2, boolean bl, String string3, Properties properties) {
        if (string3 == null) {
            return this.buildTOCTree(string, string2, bl, properties);
        }
        JNode jNode = new JNode("root");
        Communicator communicator = this.QOIV.ds.getCommunicator(string, string2);
        DSTOC dSTOC = communicator.getDSTOC();
        if (dSTOC == null) {
            return jNode;
        }
        TOCNode tOCNode = dSTOC.getTOCNode();
        if (tOCNode == null) {
            return jNode;
        }
        if ((tOCNode = this.addChild(tOCNode, string3)) == null) {
            return jNode;
        }
        JNode jNode2 = this.QOIV(string, string2, bl, tOCNode, string3, false, properties);
        return jNode2;
    }

    public JNode buildTOCTree(String string, String string2, boolean bl, Properties properties) {
        TOCNode tOCNode;
        String string3;
        JNode jNode = new JNode("root");
        Communicator communicator = this.QOIV.ds.getCommunicator(string, string2);
        DSTOC dSTOC = communicator.getDSTOC();
        if (dSTOC == null) {
            return jNode;
        }
        String string4 = this.booleanValue(dSTOC);
        if (string4 != null) {
            jNode.setAttribute("treeCSS", string4);
        }
        if ((string3 = this.buildTOCTree(dSTOC)) != null) {
            jNode.setAttribute("nodeCSS", string3);
        }
        if ((tOCNode = dSTOC.getTOCNode()) == null) {
            return jNode;
        }
        JNode jNode2 = this.QOIV(string, string2, bl, tOCNode, null, false, properties);
        jNode.addChild(jNode2);
        return jNode;
    }

    private JNode QOIV(String string, String string2, boolean bl, TOCNode tOCNode, String string3, boolean bl2, Properties properties) {
        int n;
        boolean bl3;
        CharSequence charSequence;
        String string4;
        String string5 = tOCNode.getNodeDisplayValue();
        String string6 = tOCNode.getValue();
        String string7 = tOCNode.getName();
        if (bl) {
            if (string7 != null && string7.length() != 0) {
                string4 = string7 + ": ";
                string4 = !string7.equals(string5) ? string4 + string5 : string4;
            } else {
                string4 = string5;
            }
        } else {
            string4 = string5;
        }
        if (string5 == null || string5.length() == 0) {
            string4 = string4 + string6;
        } else if (tOCNode.getImg().endsWith("sum.gif")) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("(").append(string6).append(")");
            string4 = string4 + ((StringBuffer)charSequence).toString();
        }
        charSequence = string4;
        JNode jNode = new JNode(TYPE_TOCNODE, string4, string4, (String)charSequence);
        String string8 = this.ds(tOCNode, properties);
        jNode.setAttribute("contractImg", string8);
        JNode jNode2 = new JNode(TYPE_PAGE);
        String string9 = Integer.toString(tOCNode.getPage());
        jNode2.setName(TYPE_PAGE);
        jNode2.setText(string9);
        jNode.addChild(jNode2);
        JNode jNode3 = new JNode(TYPE_X);
        String string10 = Integer.toString(Unit.convertUnitToPixel((int)tOCNode.getX()));
        jNode3.setName(TYPE_X);
        jNode3.setText(string10);
        jNode.addChild(jNode3);
        JNode jNode4 = new JNode(TYPE_Y);
        String string11 = Integer.toString(Unit.convertUnitToPixel((int)tOCNode.getY()));
        jNode4.setName(TYPE_Y);
        jNode4.setText(string11);
        jNode.addChild(jNode4);
        Node[] nodeArray = tOCNode.getNodes();
        if (nodeArray == null || nodeArray.length == 0) {
            return jNode;
        }
        TOCNode tOCNode2 = (TOCNode)nodeArray[0];
        String string12 = tOCNode2.getName();
        boolean bl4 = bl3 = !bl;
        if (string12 == null || string12.length() == 0) {
            bl3 = false;
        }
        JNode jNode5 = null;
        if (bl3) {
            jNode5 = new JNode(TYPE_TOCGRP, string12, string12, string12);
            jNode5.setAttribute("contractImg", this.ds(tOCNode2, properties));
            jNode5.addChild(jNode2);
            jNode5.addChild(jNode3);
            jNode5.addChild(jNode4);
            jNode.addChild(jNode5);
        }
        if ((n = nodeArray.length) <= 10 || !bl2) {
            int n2 = 0;
            while (n2 < n) {
                TOCNode tOCNode3 = (TOCNode)nodeArray[n2];
                JNode jNode6 = this.QOIV(string, string2, bl, tOCNode3, string3, true, properties);
                if (bl3) {
                    if (jNode6 != null) {
                        jNode5.addChild(jNode6);
                    }
                } else if (jNode6 != null) {
                    jNode.addChild(jNode6);
                }
                ++n2;
            }
        } else {
            String string13 = properties.getProperty("delay.url") + "NV=";
            jNode.setAttribute("src", string13);
            if (string3 != null) {
                string3 = FileUtil.getCanonicalPath(string3 + "/../");
                jNode.setPathPrefix(string3);
            }
        }
        return jNode;
    }

    private TOCNode addChild(TOCNode tOCNode, String string) {
        TOCNode tOCNode2 = null;
        if (string == null) {
            return null;
        }
        if (string.startsWith("/")) {
            TOCNode tOCNode3 = this.append(tOCNode);
            int n = string.indexOf("/", 1);
            String string2 = null;
            if (n != -1) {
                string2 = string.substring(1, n);
                int n2 = string2.indexOf(": ");
                if (n2 != -1) {
                    string2 = string2.substring(n2 + 2);
                }
                String string3 = string.substring(n + 1);
                String string4 = tOCNode3.getNodeDisplayValue();
                if (string2.equals(string4)) {
                    return this.addChild(tOCNode3, string3);
                }
            }
        } else {
            String string5;
            int n = string.indexOf("/");
            String string6 = null;
            if (n != -1) {
                string5 = string.substring(0, n);
                string6 = string.substring(n + 1);
            } else {
                string5 = string;
            }
            int n3 = string5.indexOf(": ");
            if (n3 != -1) {
                string5 = string5.substring(n3 + 2);
            }
            Node[] nodeArray = tOCNode.getNodes();
            int n4 = nodeArray.length;
            int n5 = 0;
            while (n5 < n4) {
                tOCNode2 = (TOCNode)nodeArray[n5];
                String string7 = tOCNode2.getName();
                String string8 = tOCNode2.getNodeDisplayValue();
                if (string5.equals(string8)) {
                    if (string6 != null) {
                        return this.addChild(tOCNode2, string6);
                    }
                    return tOCNode2;
                }
                if (string5.equals(string7)) {
                    if (string6 == null) {
                        return tOCNode;
                    }
                    n = string6.indexOf("/");
                    if (n != -1) {
                        string5 = string6.substring(0, n);
                        string6 = string6.substring(n + 1);
                    } else {
                        string5 = string6;
                        string6 = null;
                    }
                    n5 = -1;
                }
                ++n5;
            }
        }
        return null;
    }

    private TOCNode append(TOCNode tOCNode) {
        TOCNode tOCNode2 = (TOCNode)tOCNode.getParent();
        return tOCNode2 == null ? tOCNode : this.append(tOCNode2);
    }

    private String booleanValue(DSTOC dSTOC) {
        String string = null;
        Object object = dSTOC.getPropertyByName("Background").getObject();
        if (object instanceof Color) {
            StringBuffer stringBuffer = new StringBuffer("background-color:#");
            stringBuffer.append(this.convertUnitToPixel((Color)object)).append(";").toString();
            string = stringBuffer.toString();
        }
        return string;
    }

    private String buildTOCTree(DSTOC dSTOC) {
        Object object = dSTOC.getPropertyByName("StrikeOut").getObject();
        boolean bl = (Boolean)object;
        object = dSTOC.getPropertyByName("Underline").getObject();
        boolean bl2 = (Boolean)object;
        object = dSTOC.getPropertyByName("Italic").getObject();
        boolean bl3 = (Boolean)object;
        object = dSTOC.getPropertyByName("Bold").getObject();
        boolean bl4 = (Boolean)object;
        String string = null;
        object = dSTOC.getPropertyByName("Foreground").getObject();
        if (object instanceof Color) {
            string = this.convertUnitToPixel((Color)object);
        }
        object = dSTOC.getPropertyByName("FontFace").getObject();
        String string2 = (String)object;
        object = dSTOC.getPropertyByName("FontSize").getObject();
        int n = Unit.convertUnitToPixel((int)((Integer)object));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(bl3 ? "font-style:italic; " : "");
        if (bl || bl2) {
            stringBuffer.append("text-decoration:").append(bl ? "line-through " : "");
            stringBuffer.append(bl2 ? " underline" : "").append("; ");
        }
        stringBuffer.append(bl4 ? "font-weight: bold; " : "");
        stringBuffer.append("font-size:").append(n).append("px; ");
        if (!"Default".equals(string2)) {
            stringBuffer.append("font-family: ").append(string2).append("; ");
        }
        if (string != null) {
            stringBuffer.append("color:#").append(string).append("; ");
        }
        return stringBuffer.toString();
    }

    private String convertUnitToPixel(Color color) {
        if (color == null) {
            return null;
        }
        int n = color.getRGB();
        String string = Integer.toHexString(n).substring(2);
        return string;
    }

    private String ds(TOCNode tOCNode, Properties properties) {
        String string = properties.getProperty("images.path", "");
        StringBuffer stringBuffer = new StringBuffer(string).append("toc/");
        String string2 = tOCNode.getImg();
        if (string2 == null || string2.length() == 0) {
            int n = tOCNode.getObjType();
            switch (n) {
                case 44: 
                case 0x1000000: {
                    stringBuffer.append("toc_group.gif");
                    break;
                }
                case 512: {
                    stringBuffer.append("toc_section.gif");
                    break;
                }
                case 45: {
                    stringBuffer.append("toc_sectionobject.gif");
                    break;
                }
                case 262179: {
                    stringBuffer.append("toc_table.gif");
                    break;
                }
                case 257: {
                    stringBuffer.append("toc_textfiled.gif");
                    break;
                }
                case 258: {
                    stringBuffer.append("toc_dbfield.gif");
                    break;
                }
                case 262178: {
                    stringBuffer.append("toc_paragraph.gif");
                    break;
                }
                case 262181: {
                    stringBuffer.append("toc_textbox.gif");
                    break;
                }
                case 128: {
                    stringBuffer.append("toc_image.gif");
                    break;
                }
                case 46: {
                    stringBuffer.append("toc_tabular.gif");
                    break;
                }
                case 47: {
                    stringBuffer.append("toc_tabularcell.gif");
                    break;
                }
                case 262177: {
                    stringBuffer.append("toc_reportbody.gif");
                    break;
                }
                case 34: {
                    stringBuffer.append("toc_crosstable.gif");
                    break;
                }
                default: {
                    stringBuffer.append("../folder.gif");
                    break;
                }
            }
        } else {
            stringBuffer.append("toc_").append(string2.toLowerCase());
        }
        return stringBuffer.toString();
    }

    public static Properties getDefaultSetting(Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        String string = properties.getProperty("images.path", "");
        properties.setProperty("node.name.map", "text");
        properties.setProperty("node.value.map", "value");
        properties.setProperty("node.desc.map", "tip");
        properties.setProperty("root.tag", "jTree");
        properties.setProperty("tocnode.tag", "jTreeNode");
        properties.setProperty("tocgrp.tag", "jTreeNode");
        properties.setProperty("page.tag", "p");
        properties.setProperty("x.tag", TYPE_X);
        properties.setProperty("y.tag", TYPE_Y);
        properties.setProperty("att.1", "contractImg");
        properties.setProperty("att.2", "expandImg");
        properties.setProperty("att.3", "enableDrag");
        properties.setProperty("att.4", "expandLevel");
        properties.setProperty("att.5", "resourcePath");
        properties.setProperty("att.6", "treeStyle");
        properties.setProperty("root.enableDrag", "false");
        properties.setProperty("root.expandLevel", "1");
        properties.setProperty("root.treeStyle", "1");
        properties.setProperty("root.resourcePath", string);
        return properties;
    }
}

