/*
 * Decompiled with CFR 0.152.
 */
package jet.webreport.util;

import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jet.webreport.util.FileUtil;
import jet.webreport.util.Tools;

public final class StringUtil {
    private static Properties CHINA = Tools.getProperties("date.pattern.properties");
    private static Properties QOIV = Tools.getProperties("bool.pattern.properties");
    private static Properties add = Tools.getProperties("numeric.pattern.properties");
    public static final String Base64Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789@*-";

    public static String findFormat(Properties properties, String string) {
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Pattern pattern = Pattern.compile(string2);
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            return (String)properties.get(string2);
        }
        return null;
    }

    public static String unformat(int n, String string) throws ParseException {
        return StringUtil.unformat(n, string, Locale.getDefault());
    }

    public static String unformat(int n, String string, Locale locale) throws ParseException {
        String string2 = null;
        locale = locale == null ? Locale.getDefault() : locale;
        Date date = null;
        switch (n) {
            case 91: {
                string2 = StringUtil.findFormat(CHINA, string);
                if (string2 == null) {
                    throw new ParseException(string, 0);
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2, locale);
                date = simpleDateFormat.parse(string);
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd z");
                return simpleDateFormat.format(date);
            }
            case 92: {
                string2 = StringUtil.findFormat(CHINA, string);
                if (string2 == null) {
                    throw new ParseException(string, 0);
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2, locale);
                date = simpleDateFormat.parse(string);
                simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
                return simpleDateFormat.format(date);
            }
            case 93: {
                string2 = StringUtil.findFormat(CHINA, string);
                if (string2 == null) {
                    throw new ParseException(string, 0);
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2, locale);
                date = simpleDateFormat.parse(string);
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                return simpleDateFormat.format(date);
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                Object object = null;
                string2 = StringUtil.findFormat(add, string);
                if (string2 == null) {
                    throw new ParseException(string, 0);
                }
                NumberFormat numberFormat = NumberFormat.getInstance(locale);
                DecimalFormat decimalFormat = null;
                if (numberFormat instanceof DecimalFormat) {
                    decimalFormat = (DecimalFormat)numberFormat;
                    decimalFormat.setDecimalSeparatorAlwaysShown(true);
                    decimalFormat.applyLocalizedPattern(string2);
                    object = decimalFormat.parse(string);
                }
                return object != null ? object.toString() : string;
            }
            case -7: 
            case 16: {
                string2 = StringUtil.findFormat(QOIV, string);
                if (string2 == null) {
                    throw new ParseException(string, 0);
                }
                char c = string.charAt(0);
                if (c >= '0' && c <= '9') {
                    if (c == '1' || c == '0') {
                        return new String(new char[]{c});
                    }
                    throw new ParseException(string, 0);
                }
                return string2;
            }
        }
        return string;
    }

    public static int findFirstDelimiter(String string, char c, char c2, char c3) {
        int n = string.length();
        boolean bl = c2 == c3;
        int n2 = 0;
        char c4 = string.charAt(0);
        int n3 = 0;
        while (n3 < n) {
            char c5 = string.charAt(n3);
            if (bl) {
                if (c5 == c2 && c4 != '\\') {
                    n2 = n2 == 0 ? 1 : 0;
                }
                c4 = c5;
            } else if (c5 == c2) {
                ++n2;
            } else if (c5 == c3) {
                --n2;
            }
            if (c5 == c && n2 == 0) {
                return n3;
            }
            ++n3;
        }
        return n;
    }

    public static List split(String string, char c) {
        return StringUtil.split(string, c, new String[0]);
    }

    public static List split(String string, char c, String[] stringArray) {
        return StringUtil.CHINA(string, c, stringArray, new ArrayList());
    }

    private static List CHINA(String string, char c, String[] stringArray, List list) {
        String string2 = string;
        if (string2.length() == 0) {
            return list;
        }
        char c2 = string2.charAt(0);
        int n = -1;
        int n2 = stringArray.length >> 1;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3 << 1;
            char c3 = stringArray[n4].charAt(0);
            if (c2 == c3) {
                char c4 = stringArray[n4 + 1].charAt(0);
                n = StringUtil.findFirstDelimiter(string2, c, c3, c4);
                break;
            }
            ++n3;
        }
        if (n == -1) {
            n = StringUtil.findFirstDelimiter(string2, c, '\u0000', '\u0000');
        }
        list.add(string2.substring(0, n));
        if (n < string2.length()) {
            list = StringUtil.CHINA(string2.substring(n + 1), c, stringArray, list);
        }
        return list;
    }

    public static String replace(String string, char c, char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c3 = string.charAt(n2);
            if (c3 == c) {
                c3 = c2;
            }
            stringBuffer.append(c3);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String escape(String string, char[] cArray) {
        if (string == null || cArray == null || cArray.length == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (StringUtil.QOIV(c, cArray) != -1) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String unescape(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\\') {
                if (++n2 < n) {
                    stringBuffer.append(string.charAt(n2));
                }
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static int QOIV(char c, char[] cArray) {
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (c == cArray[n2]) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static int parseInt(String string, int n) {
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 65535;
        }
        return n2;
    }

    public static int[] parseInt(String string) {
        int n;
        if (string == null) {
            return new int[0];
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return new int[0];
        }
        int n2 = string2.indexOf("-");
        if (n2 == -1) {
            return new int[]{StringUtil.parseInt(string, 10)};
        }
        int n3 = StringUtil.parseInt(string2.substring(0, n2), 10);
        if (n3 == (n = StringUtil.parseInt(string2.substring(n2 + 1), 10))) {
            return new int[]{n3};
        }
        if (n3 < n) {
            int n4 = n - n3 + 1;
            int[] nArray = new int[n4];
            int n5 = 0;
            while (n5 < n4) {
                nArray[n5] = n3 + n5;
                ++n5;
            }
            return nArray;
        }
        if (n3 > n) {
            int n6 = n3 - n + 1;
            int[] nArray = new int[n6];
            int n7 = 0;
            while (n7 < n6) {
                nArray[n7] = n3 - n7;
                ++n7;
            }
            return nArray;
        }
        return null;
    }

    public static int[] parseInt(String[] stringArray) {
        int[] nArray;
        if (stringArray == null) {
            return new int[0];
        }
        int n = stringArray.length;
        if (n == 0) {
            return new int[0];
        }
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            nArray = StringUtil.parseInt(stringArray[n3]);
            arrayList.add(nArray);
            n2 += nArray.length;
            ++n3;
        }
        nArray = new int[n2];
        n = arrayList.size();
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            int[] nArray2 = (int[])arrayList.get(n5);
            int n6 = nArray2.length;
            System.arraycopy(nArray2, 0, nArray, n4, n6);
            n4 += n6;
            ++n5;
        }
        return nArray;
    }

    public static String toHTMLString(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\n': 
                case '\r': 
                case '\'': 
                case '\\': {
                    stringBuffer.append("&#");
                    stringBuffer.append(Integer.toString(c));
                    stringBuffer.append(';');
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static String add(String string) {
        int n = Integer.parseInt(string);
        char c = (char)n;
        return "" + c;
    }

    public static String decodeHTMLString(String string) {
        if (string == null) {
            return string;
        }
        String string2 = string.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&amp;", "&").replaceAll("&quot;", "\"");
        Pattern pattern = Pattern.compile("&#(\\d+);");
        Matcher matcher = pattern.matcher(string2);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string3 = matcher.group(1);
            matcher.appendReplacement(stringBuffer, StringUtil.add(string3));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static String base64Encode(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return string;
        }
        return StringUtil.base64EncodeFoArray(byArray);
    }

    public static String base64EncodeFoArray(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            byte by = byArray[n2++];
            int n5 = (by & 0xFC) >> 2;
            int n6 = (by & 3) << 4;
            if (n2 < n) {
                by = byArray[n2++];
                n6 |= (by & 0xF0) >> 4;
                n4 = (by & 0xF) << 2;
                if (n2 < n) {
                    by = byArray[n2++];
                    n4 |= (by & 0xC0) >> 6;
                    n3 = by & 0x3F;
                } else {
                    n3 = 64;
                }
            } else {
                n3 = 64;
                n4 = 64;
            }
            stringBuffer.append(Base64Chars.charAt(n5));
            stringBuffer.append(Base64Chars.charAt(n6));
            stringBuffer.append(Base64Chars.charAt(n4));
            stringBuffer.append(Base64Chars.charAt(n3));
        }
        return stringBuffer.toString();
    }

    public static String base64Decode(String string) {
        byte[] byArray = StringUtil.base64DecodeToArray(string);
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return "";
        }
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    public static byte[] base64DecodeToArray(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        if (n % 4 != 0) {
            throw new IllegalArgumentException(string);
        }
        byte[] byArray = new byte[n / 4 * 3];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 < n) {
            int n5 = Base64Chars.indexOf(string.charAt(n2++));
            int n6 = n5 << 18;
            n5 = Base64Chars.indexOf(string.charAt(n2++));
            n6 |= n5 << 12;
            if ((n5 = Base64Chars.indexOf(string.charAt(n2++))) < 64) {
                n6 |= n5 << 6;
                if ((n5 = Base64Chars.indexOf(string.charAt(n2++))) < 64) {
                    n6 |= n5;
                } else {
                    n4 = 1;
                }
            } else {
                n4 = 2;
                ++n2;
            }
            byArray[n3 + 2] = (byte)(n6 & 0xFF);
            byArray[n3 + 1] = (byte)((n6 >>= 8) & 0xFF);
            byArray[n3 + 0] = (byte)((n6 >>= 8) & 0xFF);
            n3 += 3;
        }
        if (n4 != 0) {
            n = byArray.length - n4;
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            return byArray2;
        }
        return byArray;
    }

    public static void main(String[] stringArray) throws ParseException {
        String string = " '10,000.00' , '20,000.00', \"abc,\\\"dev\",[\"abc\",\"def\"],{\"abc\",\"def\"},\"abc\" ,123,abc,[vvv,v],,";
        String string2 = "\"tt\\\"t,t\", dddd, 'te,\\'st', '1234',\"a,bc\", [12,3]";
        System.err.println(string);
        List list = StringUtil.split(string, ',', new String[]{"'", "'", "\"", "\"", "[", "]", "{", "}"});
        int n = 0;
        while (n < list.size()) {
            System.err.println(list.get(n));
            ++n;
        }
        String string3 = "a'd\\c\"d[a\\[b\\]c]";
        String string4 = StringUtil.escape(string3, new char[]{'\'', '\\', '\"', '[', ']'});
        System.err.println(string4);
        String string5 = StringUtil.unescape(string4);
        System.err.println(string5);
        System.err.println(StringUtil.unformat(3, "-$1000.77", Locale.CHINA));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd h:mm:ss a", Locale.CHINA);
        String string6 = simpleDateFormat.format(new Date());
        System.err.println(string6);
        System.err.println(simpleDateFormat.parse(string6));
        System.err.println("unformat: " + StringUtil.unformat(93, string6, Locale.CHINA));
        System.err.println(StringUtil.unformat(-7, "true"));
        String[] stringArray2 = new String[]{"1", "2", "3-8", "16-9"};
        int[] nArray = StringUtil.parseInt(stringArray2);
        int n2 = 0;
        while (n2 < nArray.length) {
            System.err.println(nArray[n2]);
            ++n2;
        }
        String string7 = "A:+-*/&^%$#@!~`=[{]}\\|;:'\",<.>/?";
        String string8 = StringUtil.base64Encode(string7);
        System.err.println(string7 + " --> " + string8);
        String string9 = StringUtil.base64Decode(string8);
        System.err.println(string8 + " --> " + string9);
        String string10 = "c:\\a\\b";
        System.err.println("paht: " + FileUtil.getFilePath(string10));
        System.err.println("name: " + FileUtil.getFileName(string10));
    }
}

