/*
 * Decompiled with CFR 0.152.
 */
package server.servlet.http;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.Servlet;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.servlets.RcServlet;
import server.servlet.ServletLoader;
import server.servlet.http.HttpAdminServerHandler;
import server.servlet.http.HttpResponse;
import server.servlet.http.HttpServer;
import server.servlet.http.HttpServerBase;
import server.servlet.http.HttpServerHandlerBase;
import server.servlet.http.JRequestDispatcherImpl;
import server.servlet.http.ServiceHandler;

public class HttpAdminServer
extends HttpServerBase {
    private RcServlet I;
    private HttpServer ID_ADMINSERVER;
    private boolean ID_SERVER = false;

    public HttpAdminServer(ExProperties exProperties, HttpServer httpServer) {
        super(exProperties);
        this.serverProps = exProperties;
        this.ID_ADMINSERVER = httpServer;
        this.loadProperties();
        this.maxHandlers = 50;
        this.maxConnections = 80;
        this.mimeTypeTable = ServerEnv.getMimeTypeTable();
        this.shutdownTimeout = ServerEnv.getShutdownTimeout();
        this.htmlPath = ServerEnv.htmlPath;
        JRequestDispatcherImpl.I = ServerEnv.isUseOldForwardMethod();
        HttpResponse.outputEncoding = ServerEnv.getOutputEncoding();
    }

    public HttpAdminServer(ExProperties exProperties, HttpServer httpServer, boolean bl) {
        super(exProperties);
        this.serverProps = exProperties;
        this.ID_ADMINSERVER = httpServer;
        this.ID_SERVER = bl;
        this.loadProperties();
        this.maxHandlers = 50;
        this.maxConnections = 80;
        this.mimeTypeTable = ServerEnv.getMimeTypeTable();
        this.shutdownTimeout = ServerEnv.getShutdownTimeout();
        this.htmlPath = ServerEnv.htmlPath;
        JRequestDispatcherImpl.I = ServerEnv.isUseOldForwardMethod();
        HttpResponse.outputEncoding = ServerEnv.getOutputEncoding();
    }

    public void setServer(HttpServer httpServer) {
        this.ID_ADMINSERVER = httpServer;
    }

    public HttpServer getServer() {
        return this.ID_ADMINSERVER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalOnly(boolean bl) {
        block28: {
            if (this.ID_SERVER == bl) {
                return;
            }
            this.ID_SERVER = bl;
            try {
                InetAddress inetAddress = InetAddress.getByName("127.0.0.1");
                if (bl) {
                    Object object;
                    int n = 0;
                    while (n < this.serviceHandlers.size()) {
                        object = (ServiceHandler)this.serviceHandlers.elementAt(n);
                        if (!((ServiceHandler)object).getHostAddr().equals(inetAddress)) {
                            try {
                                ((ServiceHandler)object).I.close();
                            }
                            catch (IOException iOException) {
                                this.fireError(iOException);
                            }
                        }
                        ++n;
                    }
                    object = this.sockets;
                    synchronized (object) {
                        int n2 = this.sockets.size() - 1;
                        while (n2 >= 0) {
                            Socket socket = (Socket)this.sockets.elementAt(n2);
                            if (!socket.getInetAddress().equals(inetAddress)) {
                                this.sockets.removeElementAt(n2);
                                try {
                                    socket.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            --n2;
                        }
                    }
                    Vector vector = this.handlerThreads;
                    synchronized (vector) {
                        int n3 = this.handlerThreads.size() - 1;
                        while (n3 >= 0) {
                            HttpServerHandlerBase httpServerHandlerBase = (HttpServerHandlerBase)this.handlerThreads.elementAt(n3);
                            if (httpServerHandlerBase.socket != null && !httpServerHandlerBase.socket.getInetAddress().equals(inetAddress)) {
                                try {
                                    httpServerHandlerBase.socket.close();
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                this.handlerThreads.removeElement(httpServerHandlerBase);
                            }
                            --n3;
                        }
                        break block28;
                    }
                }
                String string = "";
                int n = 0;
                while (n < this.hostAddrs.length) {
                    if (!inetAddress.equals(this.hostAddrs[n])) {
                        ServiceHandler serviceHandler = null;
                        try {
                            serviceHandler = new ServiceHandler(this, this.getServicePort(), this.backlog, this.hostAddrs[n]);
                            this.serviceHandlers.addElement(serviceHandler);
                            new Thread(this.serviceHandlerGroup, serviceHandler).start();
                        }
                        catch (IOException iOException) {
                            string = string + "FAILURE on starting service at address:" + this.hostAddrs[n] + " port:" + this.getServicePort() + ", Error:" + iOException.getMessage() + "\n";
                        }
                        if (serviceHandler != null) {
                            this.fireServiceStarted(serviceHandler, null);
                        }
                    }
                    ++n;
                }
                if (!"".equals(string)) {
                    this.errMsg = new Exception(string);
                    this.fireError(this.errMsg);
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.fireError(unknownHostException);
            }
        }
    }

    public RcServlet getRcServlet() {
        return this.I;
    }

    public void loadProperties() {
        block20: {
            if (this.ID_SERVER) {
                this.hostAddrs = new InetAddress[1];
                try {
                    this.hostAddrs[0] = InetAddress.getByName("127.0.0.1");
                }
                catch (UnknownHostException unknownHostException) {
                    System.err.println("Unknown host address " + unknownHostException.getMessage());
                }
            } else {
                this.useAllHosts = this.serverProps.getProperty("httpserver.host.all", true);
                this.hostName = this.serverProps.getProperty("httpserver.host.name");
                if (this.useAllHosts || this.hostName == null || this.hostName.equals("*")) {
                    InetAddress inetAddress;
                    this.hostName = "*";
                    try {
                        inetAddress = InetAddress.getLocalHost();
                        String string = inetAddress.getHostName();
                        if (string == null) {
                            string = inetAddress.getHostAddress();
                        }
                        this.hostAddrs = InetAddress.getAllByName(string);
                    }
                    catch (UnknownHostException unknownHostException) {
                        System.err.println("Unknown host address " + unknownHostException.getMessage());
                    }
                    try {
                        inetAddress = InetAddress.getByName("127.0.0.1");
                        boolean bl = false;
                        if (this.hostAddrs != null) {
                            int n = 0;
                            while (n < this.hostAddrs.length) {
                                if (this.hostAddrs[n].equals(inetAddress)) {
                                    bl = true;
                                    break;
                                }
                                ++n;
                            }
                            if (!bl) {
                                int n2 = this.hostAddrs.length;
                                InetAddress[] inetAddressArray = new InetAddress[n2 + 1];
                                System.arraycopy(this.hostAddrs, 0, inetAddressArray, 0, n2);
                                this.hostAddrs = inetAddressArray;
                                this.hostAddrs[this.hostAddrs.length - 1] = inetAddress;
                            }
                            break block20;
                        }
                        this.hostAddrs = new InetAddress[1];
                        this.hostAddrs[this.hostAddrs.length - 1] = inetAddress;
                    }
                    catch (UnknownHostException unknownHostException) {
                        System.err.println("Unknown loopback address " + unknownHostException.getMessage());
                    }
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer(this.hostName, " \t;");
                    Vector<InetAddress> vector = new Vector<InetAddress>();
                    while (stringTokenizer.hasMoreElements()) {
                        String string = stringTokenizer.nextToken();
                        try {
                            InetAddress inetAddress = InetAddress.getByName(string);
                            if (!vector.contains(inetAddress)) {
                                vector.addElement(inetAddress);
                            }
                        }
                        catch (UnknownHostException unknownHostException) {
                            System.err.println("Unknown host address " + string);
                        }
                        this.hostAddrs = new InetAddress[vector.size()];
                        vector.copyInto(this.hostAddrs);
                    }
                }
            }
        }
        this.port = this.serverProps.getProperty("httpserver.port", this.port);
        this.adminport = this.serverProps.getProperty("httpserver.admin.port", 8889);
        this.secureAdminPort = this.serverProps.getProperty("httpserver.ssl.admin.port", 6889);
        this.backlog = this.serverProps.getProperty("httpserver.backlog", this.backlog);
        this.maxHandlers = this.serverProps.getProperty("httpserver.max.handlers", this.maxHandlers);
        this.maxConnections = this.serverProps.getProperty("httpserver.max.connections", this.maxConnections);
        if (this.maxHandlers > this.maxConnections) {
            this.maxHandlers = this.maxConnections;
        }
        this.timeout = this.serverProps.getProperty("httpserver.timeout", this.timeout);
        this.name = this.serverProps.getProperty("httpserver.name", this.name);
        this.servletPropFile = this.serverProps.getProperty("httpserver.servlet.admin.propfile", System.getProperty("reporthome", ".") + File.separator + "bin" + File.separator + "admin.properties");
        this.loadServletProps();
    }

    public void initLoader() {
        this.setAttribute(ServerEnv.ID_SERVER, this.ID_ADMINSERVER);
        this.setAttribute(ServerEnv.ID_ADMINSERVER, this);
        this.loader = new ServletLoader(".");
        if (this.autoStartedServlets != null) {
            int n = 0;
            while (n < this.autoStartedServlets.length) {
                Servlet servlet = this.getServletEx(this.autoStartedServlets[n]);
                if (servlet instanceof RcServlet) {
                    this.I = (RcServlet)servlet;
                }
                ++n;
            }
        }
    }

    protected int getServicePort() {
        return this.adminport;
    }

    protected int getSecureServicePort() {
        return this.secureAdminPort;
    }

    protected String getThreadGroupName() {
        return "Admin Service";
    }

    public void startHandler() {
        HttpAdminServerHandler httpAdminServerHandler = new HttpAdminServerHandler(this);
        this.handlerThreads.addElement(httpAdminServerHandler);
        new Thread(this.handlers, httpAdminServerHandler).start();
    }
}

