/*
 * Decompiled with CFR 0.152.
 */
package server.servlet.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import jet.server.ServerEnv;
import jet.server.log.ServiceLogger;
import jet.server.servlets.RcServlet;
import jet.server.util.HtmlEncoder;
import jet.server.util.ServerUtil;
import server.servlet.http.HttpAdminServer;
import server.servlet.http.HttpRequest;
import server.servlet.http.HttpResponse;
import server.servlet.http.HttpServerHandlerBase;
import server.servlet.http.MessageBytes;

public class HttpAdminServerHandler
extends HttpServerHandlerBase {
    protected HttpAdminServerHandler(HttpAdminServer httpAdminServer) {
        super(httpAdminServer);
    }

    protected void service(HttpRequest httpRequest, HttpResponse httpResponse) throws ServletException, IOException {
        MessageBytes messageBytes = httpRequest.getRequestPath();
        String string = this.parsePath(messageBytes, httpRequest);
        String string2 = this.getValidPath(string);
        if (ServerEnv.isVirtualLicence() && ServerEnv.checkExpired() != null && (string2 == null || !string2.endsWith(".gif") && !string2.endsWith(".css"))) {
            string2 = "/admin/expired.jsp";
        }
        if (string2 == null) {
            httpResponse.sendError(404, "The requested resource (" + messageBytes.toString() + ") is not available.");
            return;
        }
        string = string2;
        httpRequest.setServletPath(string);
        boolean bl = false;
        if (string.startsWith("/jinfonet") || string.startsWith("/adhoc")) {
            httpResponse.sendError(403, "Please use http server port " + this.server.port + " to access it!");
            return;
        }
        if (string.toLowerCase().indexOf("<script>") != -1 || string.toLowerCase().indexOf("%3cscript%3e") != -1 || string.toLowerCase().indexOf("javascript:") != -1 || string.toLowerCase().indexOf("vbscript:") != -1) {
            httpResponse.sendError(404, "File not found!");
            return;
        }
        if (string.startsWith("/jradmin")) {
            httpRequest.setServletPath("/jradmin");
            String string3 = string.substring("/jradmin".length());
            if (string3.equals("") || string3.equals("/")) {
                string3 = null;
            }
            httpRequest.setPathInfo(string3);
            RcServlet rcServlet = ((HttpAdminServer)this.server).getRcServlet();
            if (rcServlet != null) {
                rcServlet.service((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            } else {
                httpResponse.sendError(404, "Cannot load jrservlet for serving request");
            }
            bl = true;
        } else if (string.toLowerCase().endsWith(".jsp")) {
            block21: {
                if (!new File(this.server.getRealPath(string)).exists()) {
                    httpResponse.sendError(404, "File not found: " + HtmlEncoder.encode(string));
                    return;
                }
                Servlet servlet = ((HttpAdminServer)this.server).getServer().getServlet("jspservlet");
                if (servlet == null) {
                    httpResponse.sendError(404, "Cannot load servlet jspservlet for serving request");
                    return;
                }
                try {
                    servlet.service((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                }
                catch (ServletException servletException) {
                    String string4 = servletException.getMessage();
                    if (string4 == null || string4.indexOf("can't mix text and binary input") >= 0) break block21;
                    throw servletException;
                }
            }
            bl = true;
        } else if (string.indexOf("/help/") != -1) {
            block22: {
                Servlet servlet = ((HttpAdminServer)this.server).getServer().getServlet("sendfile");
                if (servlet == null) {
                    httpResponse.sendError(404, "Cannot load sendfile jspservlet for serving request");
                    return;
                }
                try {
                    String string5 = "/servlet/sendfile";
                    httpRequest.setServletPath(string5);
                    String string6 = string.substring(string5.length());
                    if (string6.equals("") || string6.equals("/")) {
                        string6 = null;
                    }
                    httpRequest.setPathInfo(string6);
                    servlet.service((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                }
                catch (ServletException servletException) {
                    String string7 = servletException.getMessage();
                    if (string7 == null || string7.indexOf("can't mix text and binary input") >= 0) break block22;
                    throw servletException;
                }
            }
            bl = true;
        }
        if (!bl) {
            this.I(httpRequest, httpResponse, string);
        }
    }

    private void I(HttpRequest httpRequest, HttpResponse httpResponse, String string) throws IOException {
        Object object;
        ServiceLogger.logDebug(6680029, string, 6);
        if (string == null || string.equals("") || string.equals("/")) {
            string = "/admin/select.htm";
        }
        String string2 = string;
        String string3 = "";
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string3 = string2.substring(n);
        }
        String string4 = ServerEnv.getMimeTypeTable().getMimeType(string3);
        httpResponse.setContentType(string4);
        try {
            if (string.endsWith("/") || string.endsWith(File.separator) || string.startsWith("/..") || string.endsWith(".jsp.bak")) {
                httpResponse.sendError(404, "File " + string + " not found!");
                return;
            }
            if (string.indexOf("<script>") > 0 || string.indexOf("javascript:") > 0) {
                httpResponse.sendError(404, "File not found!");
                return;
            }
            object = new File(this.server.getRealPath(string));
            if (((File)object).isDirectory()) {
                httpResponse.sendError(404, "File " + string + " not found!");
                return;
            }
            if (ServerUtil.isFileNotModified((File)object, httpRequest, httpResponse)) {
                HttpSession httpSession = httpRequest.getSession(false);
                String string5 = httpSession == null ? null : httpSession.getId();
                ServiceLogger.logAccessSuccessEvent(ServerEnv.getActiveRealm(), httpRequest.getRemoteUser(), string5, 5680030, string, 5);
                return;
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        httpResponse.setStatus(200);
        object = httpResponse.getOutputStream();
        InputStream inputStream = this.server.getResourceAsStream(string);
        if (inputStream == null) {
            httpResponse.sendError(404, "File " + string + " not found!");
            return;
        }
        httpResponse.setContentLength(inputStream.available());
        byte[] byArray = new byte[8192];
        try {
            int n2 = inputStream.read(byArray);
            while (n2 > 0) {
                ((OutputStream)object).write(byArray, 0, n2);
                n2 = inputStream.read(byArray);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        inputStream.close();
        ((OutputStream)object).close();
        HttpSession httpSession = httpRequest.getSession(false);
        String string6 = httpSession == null ? null : httpSession.getId();
        ServiceLogger.logAccessSuccessEvent(ServerEnv.getActiveRealm(), httpRequest.getRemoteUser(), string6, 5680031, string, 6);
    }
}

