/*
 * Decompiled with CFR 0.152.
 */
package server.servlet.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import javax.servlet.ServletInputStream;
import server.servlet.http.MessageBytes;
import server.servlet.util.Ascii;

class HttpRequestLine
extends Ascii {
    private static final byte[] QOIV = new byte[]{72, 84, 84, 80, 47, 48, 46, 57};
    protected static final int MAXLINE = 32768;
    protected byte[] buf;
    protected int size;
    protected MessageBytes line = new MessageBytes();
    protected MessageBytes method = new MessageBytes();
    protected MessageBytes uri = new MessageBytes();
    protected MessageBytes path = new MessageBytes();
    protected MessageBytes query = new MessageBytes();
    protected MessageBytes protocol = new MessageBytes();
    protected Hashtable params;
    protected boolean proxy;

    public HttpRequestLine(int n) {
        this.buf = new byte[n];
    }

    public HttpRequestLine() {
        this(128);
    }

    public void reset() {
        this.line.reset();
        this.method.reset();
        this.uri.reset();
        this.path.reset();
        this.query.reset();
        this.protocol.reset();
        this.params = null;
        this.proxy = false;
    }

    public boolean parse(ServletInputStream servletInputStream) throws IOException, IllegalArgumentException {
        this.line.reset();
        int n = this.QOIV(servletInputStream);
        if (n == -1) {
            return false;
        }
        if (this.buf == null) {
            this.buf = new byte[this.size];
        }
        this.parse(this.buf, 0, n - 1);
        this.params = null;
        return true;
    }

    private int QOIV(ServletInputStream servletInputStream) throws IOException, IllegalArgumentException {
        int n = 0;
        byte[] byArray = this.buf;
        int n2;
        while ((n2 = servletInputStream.readLine(byArray, n, byArray.length - n)) != -1) {
            if (n == 0 && (n2 == 1 ? byArray[0] == 10 || byArray[0] == 13 : n2 == 2 && byArray[0] == 13 && byArray[1] == 10)) {
                return -1;
            }
            if (byArray[(n += n2) - 1] == 10) {
                if (n > 1 && byArray[n - 2] == 13) {
                    byArray[--n - 1] = 10;
                }
                return n;
            }
            if (n != byArray.length) continue;
            if (n == 32768) {
                throw new IllegalArgumentException("request line too long");
            }
            n2 = Math.min(this.buf.length * 2, 32768);
            this.buf = new byte[n2];
            System.arraycopy(byArray, 0, this.buf, 0, byArray.length);
            byArray = this.buf;
        }
        return -1;
    }

    protected void parse(byte[] byArray, int n, int n2) throws IllegalArgumentException {
        this.line.setBytes(byArray, n, n2);
        byte by = byArray[n++];
        if (!Ascii.isAlpha(by)) {
            throw new IllegalArgumentException("invalid request line");
        }
        while (Ascii.isAlpha(by = byArray[n++])) {
        }
        this.method.setBytes(byArray, 0, n - 1);
        if (by != 32) {
            throw new IllegalArgumentException("invalid request line");
        }
        while ((by = byArray[n++]) == 32) {
        }
        int n3 = n - 1;
        while (by != 63 && !Ascii.isWhite(by)) {
            if (by == 58) {
                this.proxy = true;
            }
            by = byArray[n++];
        }
        this.path.setBytes(byArray, n3, n - n3 - 1);
        if (by == 63) {
            int n4 = n;
            while (!Ascii.isWhite(by = byArray[n++])) {
            }
            this.query.setBytes(byArray, n4, n - n4 - 1);
        } else {
            this.query.reset();
        }
        this.uri.setBytes(byArray, n3, n - n3 - 1);
        while (by == 32) {
            by = byArray[n++];
        }
        if (by != 13) {
            n3 = n - 1;
            while (!Ascii.isWhite(by = byArray[n++])) {
            }
            this.protocol.setBytes(byArray, n3, n - n3 - 1);
        } else {
            this.protocol.setBytes(QOIV, 0, QOIV.length);
        }
    }

    public MessageBytes getMethod() {
        return this.method;
    }

    public MessageBytes getProtocol() {
        return this.protocol;
    }

    public MessageBytes getQueryString() {
        return this.query;
    }

    public MessageBytes getURI() {
        return this.uri;
    }

    public MessageBytes getRequestPath() {
        return this.path;
    }

    public MessageBytes getRequestLine() {
        return this.line;
    }

    public boolean isFullRequest() {
        return this.protocol.isSet() && this.protocol.getBytes() != QOIV;
    }

    public boolean isProxyRequest() {
        return this.proxy;
    }

    public String toString() {
        return this.line.toString();
    }

    public void write(OutputStream outputStream) throws IOException {
        this.line.write(outputStream);
    }

    public void dump(PrintStream printStream) {
        printStream.println("line   = \"" + this.line + "\"");
        printStream.println("method = \"" + this.method + "\"");
        printStream.println("path   = \"" + this.path + "\"");
        printStream.println("uri    = \"" + this.uri + "\"");
        printStream.println("query  = \"" + this.query + "\"");
        printStream.println("protocol = \"" + this.protocol + "\"");
    }
}

