/*
 * Decompiled with CFR 0.152.
 */
package server.servlet.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.log.ServiceLogger;
import jet.server.servlets.JRServlet;
import jet.server.util.SortExProperties;
import jet.util.AsciiProperties;
import server.servlet.ServletLoader;
import server.servlet.http.HttpAdminServer;
import server.servlet.http.HttpResponse;
import server.servlet.http.HttpServerBase;
import server.servlet.http.HttpServerHandler;
import server.servlet.http.JRequestDispatcherImpl;
import server.servlet.http.PreviewServerLocker;

public class HttpServer
extends HttpServerBase {
    private JRServlet I;
    private HttpAdminServer ID_ADMINSERVER;
    private static boolean ID_SERVER = false;
    private Properties QOIV = null;
    static boolean add;

    public HttpServer(ExProperties exProperties, boolean bl) throws Exception {
        super(exProperties);
        this.maxHandlers = 100;
        this.maxConnections = 150;
        this.loadProperties(exProperties, bl);
        this.maxHandlers = this.serverProps.getProperty("httpserver.max.handlers", 100);
        this.maxConnections = this.serverProps.getProperty("httpserver.max.connections", 150);
        if (this.maxHandlers > this.maxConnections) {
            this.maxHandlers = this.maxConnections;
        }
        this.mimeTypeTable = ServerEnv.getMimeTypeTable();
        this.shutdownTimeout = ServerEnv.getShutdownTimeout();
        this.htmlPath = ServerEnv.htmlPath;
        JRequestDispatcherImpl.I = ServerEnv.isUseOldForwardMethod();
        HttpResponse.outputEncoding = ServerEnv.getOutputEncoding();
    }

    public void setAdminServer(HttpAdminServer httpAdminServer) {
        this.ID_ADMINSERVER = httpAdminServer;
    }

    public HttpAdminServer getAdminServer() {
        return this.ID_ADMINSERVER;
    }

    public Properties getMappings() {
        if (this.QOIV == null) {
            this.QOIV = new AsciiProperties();
            try {
                String string = ServerEnv.homePath + "bin" + File.separator + "mapping.properties";
                this.QOIV.load(new FileInputStream(string));
            }
            catch (IOException iOException) {
                ServiceLogger.logError(2680075, 2);
                ServiceLogger.logError(iOException);
            }
        }
        return this.QOIV;
    }

    public void loadProperties(ExProperties exProperties, boolean bl) throws Exception {
        block20: {
            Object object;
            if (exProperties.size() > 0) {
                this.servPropName = ServerEnv.getServPropName();
                object = new SortExProperties();
                if (new File(this.servPropName).exists()) {
                    ((ExProperties)object).load(this.servPropName);
                }
                ((ExProperties)object).merge(exProperties);
                ((ExProperties)object).save(this.servPropName, "");
            }
            if (!bl) {
                ServerEnv.check();
            } else {
                ServerEnv.recheck();
            }
            this.servPropName = ServerEnv.getServPropName();
            this.serverProps = ServerEnv.getServerProps();
            this.useAllHosts = this.serverProps.getProperty("httpserver.host.all", true);
            this.hostName = this.serverProps.getProperty("httpserver.host.name");
            if (this.hostName == null) {
                this.hostName = "*";
            }
            if (this.useAllHosts || this.hostName.equals("*")) {
                try {
                    object = InetAddress.getLocalHost();
                    String string = ((InetAddress)object).getHostName();
                    if (string == null) {
                        string = ((InetAddress)object).getHostAddress();
                    }
                    this.hostAddrs = InetAddress.getAllByName(string);
                }
                catch (UnknownHostException unknownHostException) {
                    System.err.println("Unknown host address " + unknownHostException.getMessage());
                }
                try {
                    object = InetAddress.getByName("127.0.0.1");
                    if (this.hostAddrs != null) {
                        boolean bl2 = false;
                        int n = 0;
                        while (n < this.hostAddrs.length) {
                            if (this.hostAddrs[n].equals(object)) {
                                bl2 = true;
                                break;
                            }
                            ++n;
                        }
                        if (!bl2) {
                            int n2 = this.hostAddrs.length;
                            InetAddress[] inetAddressArray = new InetAddress[n2 + 1];
                            System.arraycopy(this.hostAddrs, 0, inetAddressArray, 0, n2);
                            this.hostAddrs = inetAddressArray;
                            this.hostAddrs[this.hostAddrs.length - 1] = object;
                        }
                        break block20;
                    }
                    this.hostAddrs = new InetAddress[1];
                    this.hostAddrs[this.hostAddrs.length - 1] = object;
                }
                catch (UnknownHostException unknownHostException) {
                    System.err.println("Unknown loopback address " + unknownHostException.getMessage());
                }
            } else {
                object = new StringTokenizer(this.hostName, " \t;");
                Vector<InetAddress> vector = new Vector<InetAddress>();
                while (((StringTokenizer)object).hasMoreElements()) {
                    String string = ((StringTokenizer)object).nextToken();
                    try {
                        InetAddress inetAddress = InetAddress.getByName(string);
                        if (!vector.contains(inetAddress)) {
                            vector.addElement(inetAddress);
                        }
                    }
                    catch (UnknownHostException unknownHostException) {
                        System.err.println("Unknown host address " + string);
                    }
                    this.hostAddrs = new InetAddress[vector.size()];
                    vector.copyInto(this.hostAddrs);
                }
            }
        }
        this.port = this.serverProps.getProperty("httpserver.port", this.port);
        this.securePort = this.serverProps.getProperty("httpserver.ssl.port", this.port);
        this.adminport = this.serverProps.getProperty("httpserver.admin.port", this.adminport);
        this.backlog = this.serverProps.getProperty("httpserver.backlog", this.backlog);
        this.maxHandlers = this.serverProps.getProperty("httpserver.max.handlers", this.maxHandlers);
        this.timeout = this.serverProps.getProperty("httpserver.timeout", this.timeout);
        this.name = this.serverProps.getProperty("httpserver.name", this.name);
        this.servletPropFile = this.serverProps.getProperty("httpserver.servlet.propfile", System.getProperty("reporthome", ".") + File.separator + "bin" + File.separator + "servlet.properties");
        this.loadServletProps();
        this.saveProperties();
    }

    public void initLoader() {
        this.setAttribute(ServerEnv.ID_SERVER, this);
        this.setAttribute(ServerEnv.ID_ADMINSERVER, this.ID_ADMINSERVER);
        this.loader = new ServletLoader(".");
        if (this.autoStartedServlets != null) {
            int n = 0;
            while (n < this.autoStartedServlets.length) {
                Servlet servlet = this.getServletEx(this.autoStartedServlets[n]);
                if (servlet instanceof JRServlet) {
                    this.I = (JRServlet)servlet;
                }
                ++n;
            }
        }
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        JRequestDispatcherImpl jRequestDispatcherImpl = new JRequestDispatcherImpl(string);
        jRequestDispatcherImpl.I(this);
        return jRequestDispatcherImpl;
    }

    protected int getServicePort() {
        return this.port;
    }

    protected int getSecureServicePort() {
        return this.securePort;
    }

    JRServlet I() {
        return this.I;
    }

    protected String getThreadGroupName() {
        return "Server Service";
    }

    public void startHandler() {
        HttpServerHandler httpServerHandler = new HttpServerHandler(this);
        this.handlerThreads.addElement(httpServerHandler);
        new Thread(this.handlers, httpServerHandler).start();
    }

    public void start() {
        super.start();
    }

    public void quit() {
        super.quit();
        ServiceLogger.closeAll();
        PreviewServerLocker.newInstance().destory();
        PreviewServerLocker.releaseInstance();
        System.exit(0);
    }

    public void quitWithoutExit() {
        super.quit();
        ServiceLogger.closeAll();
    }

    public void restart() {
        this.shutdown();
        ExProperties exProperties = new ExProperties();
        try {
            HttpServer httpServer = new HttpServer(exProperties, true);
            this.ID_ADMINSERVER.setServer(httpServer);
            httpServer.setAdminServer(this.ID_ADMINSERVER);
            httpServer.start();
            add = false;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public void needRestart() {
        add = true;
        RestartWaiter restartWaiter = new RestartWaiter(this, this);
        new Thread(restartWaiter).start();
    }

    public Set getResourcePaths(String string) {
        int n;
        String string2 = new String();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        String[] stringArray = new String[200];
        try {
            stringArray = new File(this.htmlPath).list();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (stringArray == null) {
            hashSet2.add("/jinfonet/");
            hashSet2.add("/admin/");
            hashSet2.add("/adhoc/");
            hashSet2.add("/dhtmljsp/");
        } else {
            n = 0;
            while (n < stringArray.length) {
                string2 = stringArray[n].indexOf(46) < 0 ? "/" + stringArray[n] + "/" : "/" + stringArray[n];
                hashSet2.add(string2);
                ++n;
            }
        }
        stringArray = new String[hashSet2.size()];
        hashSet2.toArray(stringArray);
        n = 0;
        while (n < stringArray.length) {
            int n2;
            if (stringArray[n].startsWith(string) && stringArray[n].compareTo(string) != 0 && !hashSet.contains(string2 = (n2 = (string2 = stringArray[n].substring(string.length())).indexOf(47)) < 0 ? string + string2 : string + string2.substring(0, n2) + "/")) {
                hashSet.add(string2);
            }
            ++n;
        }
        return hashSet;
    }

    public String getInitParameter(String string) {
        Hashtable hashtable = this.getAppInitParameters();
        String string2 = (String)hashtable.get(string);
        return string2;
    }

    public Enumeration getInitParameterNames() {
        Hashtable hashtable = this.getAppInitParameters();
        return hashtable.keys();
    }

    public void lockForPreviewServer() {
        PreviewServerLocker.newInstance().lock();
    }

    static {
        if (System.getProperty("awt.toolkit") != null && System.getProperty("awt.toolkit").equals("com.jinfonet.awt.JToolkit")) {
            try {
                Class.forName("com.jinfonet.awt.JToolkit");
                ID_SERVER = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        add = false;
    }

    class RestartWaiter
    implements Runnable {
        HttpServer QOIV;
        private final HttpServer this$0;

        RestartWaiter(HttpServer httpServer, HttpServer httpServer2) {
            this.this$0 = httpServer;
            this.QOIV = httpServer2;
        }

        public void run() {
            this.QOIV.restart();
        }
    }
}

