/*
 * Decompiled with CFR 0.152.
 */
package server.servlet.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import jet.JSRuntimeException;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.log.ServiceLogger;
import jet.server.util.MIMETypeTable;
import jet.server.util.TypeUtil;
import jet.util.AsciiProperties;
import server.servlet.ServletLoader;
import server.servlet.http.HttpServerHandlerBase;
import server.servlet.http.HttpServletConfig;
import server.servlet.http.ServerListener;
import server.servlet.http.ServerThread;
import server.servlet.http.ServiceHandler;
import server.servlet.http.SessionContextImpl;
import server.servlet.http.URLSH;
import server.servlet.util.Queue;
import server.servlet.util.QueueEmptyException;
import server.servlet.util.QueueFullException;

public abstract class HttpServerBase
implements Runnable,
ServletContext,
ServerListener {
    public static final String SERVER_NAME = "JRServer";
    public static final String SERVER_VERSION = "2.0 Technology Preview";
    protected Queue connections;
    protected ThreadGroup handlers;
    protected Vector handlerThreads = new Vector();
    protected int maxHandlers = 0;
    protected int maxConnections = 0;
    protected int aliveSockets = 0;
    public static byte[] busyHead = new byte[256];
    public static byte[] busyContent = new byte[512];
    protected int timeout = 500;
    protected int port = 8888;
    protected int securePort = 6888;
    protected int adminport = 8889;
    protected int secureAdminPort = 6889;
    protected int backlog = 50;
    protected int avail;
    protected int total;
    protected String name = "JRServer/2.0 Technology Preview";
    protected Properties servletProps = new AsciiProperties();
    protected String servletPropFile;
    protected ServletLoader loader;
    protected SessionContextImpl sessionContext = new SessionContextImpl();
    protected String[] autoStartedServlets;
    protected String servPropName;
    protected ExProperties serverProps;
    protected boolean useAllHosts;
    protected String hostName;
    protected boolean ssl = false;
    protected InetAddress[] hostAddrs;
    protected Vector serviceHandlers = new Vector();
    protected Vector sockets = new Vector();
    protected Thread serverThread;
    protected ThreadGroup serviceHandlerGroup;
    private Vector C = new Vector();
    protected int state = 0;
    protected Exception errMsg = null;
    boolean Z;
    private long accept = 15000L;
    public static final int ServerNotStarted = 0;
    public static final int ServerPreparetoStarting = 1;
    public static final int ServerStarted = 2;
    public static final int ServerStopped = 3;
    public static final int ServerStoppedWithError = 4;
    protected Hashtable htAttr = new Hashtable();
    private boolean activeCount = false;
    protected MIMETypeTable mimeTypeTable = null;
    protected int shutdownTimeout = 0;
    protected String htmlPath = null;

    private HttpServerBase() {
    }

    public HttpServerBase(ExProperties exProperties) {
        this.addServerListener(this);
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 1;
    }

    public ServletContext getContext(String string) {
        throw new JSRuntimeException(670018);
    }

    public URL getResource(String string) {
        try {
            String string2 = this.getRealPath(string);
            if (new File(string2).isDirectory()) {
                return null;
            }
            URL uRL = null;
            String string3 = System.getProperty("java.version");
            uRL = ServerEnv.getUseURLHandler() && string3 != null && string3.compareTo("1.4") < 0 ? new URL(null, "file:" + this.getRealPath(string), new URLSH()) : new URL("file:" + this.getRealPath(string));
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            ServiceLogger.logError(malformedURLException);
            return null;
        }
    }

    public InputStream getResourceAsStream(String string) {
        try {
            URL uRL = this.getResource(string);
            if (uRL == null) {
                return null;
            }
            return uRL.openStream();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        throw new JSRuntimeException(670018);
    }

    public void log(String string, Throwable throwable) {
        ServiceLogger.logError(throwable);
    }

    public Enumeration getAttributeNames() {
        return this.htAttr.keys();
    }

    public void setAttribute(String string, Object object) {
        this.htAttr.put(string, object);
    }

    public void removeAttribute(String string) {
        this.htAttr.remove(string);
    }

    public int getState() {
        return this.state;
    }

    public int getMaxHandlers() {
        return this.maxHandlers;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void addServerListener(ServerListener serverListener) {
        if (!this.C.contains(serverListener)) {
            this.C.addElement(serverListener);
        }
    }

    public void removeServerListener(ServerListener serverListener) {
        if (this.C.contains(serverListener)) {
            this.C.removeElement(serverListener);
        }
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public ExProperties getServerPorps() {
        return this.serverProps;
    }

    public String getServletPropFile() {
        return this.servletPropFile;
    }

    public SessionContextImpl getSessionContext() {
        return this.sessionContext;
    }

    public String getServPropName() {
        return this.servPropName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public Vector getServiceHandlers() {
        return this.serviceHandlers;
    }

    public InetAddress[] getHostAddrs() {
        return this.hostAddrs;
    }

    public boolean useAllHosts() {
        return this.useAllHosts;
    }

    protected void loadServletProps() {
        File file = new File(this.servletPropFile);
        if (file.exists() && file.canRead()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                try {
                    this.servletProps.load(new FileInputStream(file));
                    String string = this.servletProps.getProperty("autostart.servlet", null);
                    if (string != null) {
                        this.autoStartedServlets = TypeUtil.stringToArray(string, " ");
                    }
                }
                catch (IOException iOException) {
                    System.err.println("Could not load servlet properites file");
                }
                fileInputStream.close();
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
            }
        }
    }

    protected void loadDefProps() {
        this.serverProps.setProperty("httpserver.port", this.port);
        this.serverProps.setProperty("httpserver.admin.port", this.adminport);
        this.serverProps.setProperty("httpserver.backlog", this.backlog);
        this.serverProps.setProperty("httpserver.timeout", this.timeout);
        this.serverProps.setProperty("httpserver.name", this.name);
        this.serverProps.setProperty("httpserver.max.handlers", this.maxHandlers);
        this.serverProps.setProperty("server.realm.active", "defaultRealm");
        this.serverProps.setProperty("httpserver.host.all", "true");
        this.serverProps.setProperty("httpserver.servlet.propfile", System.getProperty("reporthome", ".") + File.separator + "bin" + File.separator + "servlet.properties");
        this.serverProps.setProperty("httpserver.servlet.admin.propfile", System.getProperty("reporthome", ".") + File.separator + "bin" + File.separator + "admin.properties");
    }

    public void saveProperties() {
        try {
            this.serverProps.save(this.servPropName, null);
        }
        catch (IOException iOException) {
            System.err.println("Could not save server propfile due to '" + iOException.getMessage() + "'");
            ServiceLogger.logError(2680032, iOException.getMessage(), 2);
        }
    }

    public void fireFatalError(Object object) {
        int n = 0;
        while (n < this.C.size()) {
            ((ServerListener)this.C.elementAt(n)).fatalError(this, object);
            ++n;
        }
    }

    public void fireError(Object object) {
        int n = 0;
        while (n < this.C.size()) {
            ((ServerListener)this.C.elementAt(n)).error(this, object);
            ++n;
        }
    }

    public void fireWarning(Object object) {
        int n = 0;
        while (n < this.C.size()) {
            ((ServerListener)this.C.elementAt(n)).warning(this, object);
            ++n;
        }
    }

    public void fireMessage(Object object) {
        int n = 0;
        while (n < this.C.size()) {
            ((ServerListener)this.C.elementAt(n)).message(this, object);
            ++n;
        }
    }

    public void fireServiceStarted(ServiceHandler serviceHandler, Object object) {
        int n = 0;
        while (n < this.C.size()) {
            ((ServerListener)this.C.elementAt(n)).serviceStarted(serviceHandler, object);
            ++n;
        }
    }

    public void fireServiceStopped(ServiceHandler serviceHandler, Object object) {
        int n = 0;
        while (n < this.C.size()) {
            ((ServerListener)this.C.elementAt(n)).serviceStopped(serviceHandler, object);
            ++n;
        }
    }

    public void fireServerStarted(Object object) {
        int n = 0;
        while (n < this.C.size()) {
            ((ServerListener)this.C.elementAt(n)).serverStarted(this, object);
            ++n;
        }
    }

    public void fireServerStopped(Object object) {
        int n = 0;
        while (n < this.C.size()) {
            ((ServerListener)this.C.elementAt(n)).serverStopped(this, object);
            ++n;
        }
    }

    public abstract void initLoader();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Runnable runnable;
        this.errMsg = null;
        this.state = 1;
        this.connections = new Queue(this.maxHandlers);
        this.handlers = new ThreadGroup("JRServer-");
        this.serviceHandlerGroup = new ThreadGroup(this.getThreadGroupName());
        this.serviceHandlers.removeAllElements();
        this.Z = false;
        String string = "";
        boolean bl = false;
        try {
            bl = ServerEnv.getSSLEnable();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        int n = 0;
        while (n < this.hostAddrs.length) {
            runnable = null;
            try {
                runnable = new ServiceHandler(this, this.getServicePort(), this.backlog, this.hostAddrs[n]);
                this.serviceHandlers.addElement(runnable);
                new Thread(this.serviceHandlerGroup, runnable).start();
                if (bl) {
                    runnable = new ServiceHandler(this, this.getSecureServicePort(), this.backlog, this.hostAddrs[n], bl);
                    this.serviceHandlers.addElement(runnable);
                    new Thread(this.serviceHandlerGroup, runnable).start();
                }
            }
            catch (IOException iOException) {
                string = string + "FAILURE on starting service at address:" + this.hostAddrs[n] + " port:" + this.getServicePort() + ", Error:" + iOException.getMessage() + "\n";
            }
            if (runnable != null) {
                this.fireServiceStarted((ServiceHandler)runnable, null);
            }
            ++n;
        }
        if (!"".equals(string)) {
            this.errMsg = new Exception(string);
            this.fireError(this.errMsg);
        }
        if (this.serviceHandlers.size() == 0 || this.serviceHandlerGroup.activeCount() == 0) {
            this.fireError("No host address is available.");
            this.processStop();
            return;
        }
        this.errMsg = null;
        this.state = 2;
        this.fireServerStarted(null);
        while (!this.Z) {
            runnable = this;
            synchronized (runnable) {
                while (this.avail <= 0) {
                    if (this.total < this.maxHandlers) {
                        this.startHandler();
                        ++this.total;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                --this.avail;
            }
            Socket socket = null;
            try {
                socket = this.accept();
                this.putConnection(socket);
            }
            catch (IOException iOException) {
                if (this.Z) continue;
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
                this.fireError(iOException);
                this.errMsg = iOException;
            }
        }
        if (this.Z) {
            this.errMsg = null;
        }
        this.processStop();
    }

    protected abstract int getServicePort();

    protected abstract int getSecureServicePort();

    protected abstract String getThreadGroupName();

    public abstract void startHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void I(Socket socket) {
        HttpServerBase httpServerBase = this;
        synchronized (httpServerBase) {
            int n = this.total + this.aliveSockets;
            if (n < this.maxConnections) {
                this.sockets.addElement(socket);
                ++this.aliveSockets;
                this.notifyAll();
            } else {
                try {
                    OutputStream outputStream = socket.getOutputStream();
                    outputStream.write(busyHead);
                    outputStream.write(busyContent);
                    outputStream.close();
                    socket.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ServiceLogger.logError(2680033, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Socket accept() throws IOException {
        HttpServerBase httpServerBase = this;
        synchronized (httpServerBase) {
            while (!this.Z) {
                if (this.sockets.size() > 0) {
                    Socket socket = (Socket)this.sockets.lastElement();
                    this.sockets.removeElementAt(this.sockets.size() - 1);
                    --this.aliveSockets;
                    this.notifyAll();
                    return socket;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public void start() {
        this.initLoader();
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void C() {
        long l = this.accept;
        long l2 = System.currentTimeMillis();
        while (this.state == 2 || this.serviceHandlers.size() > 0) {
            HttpServerBase httpServerBase = this;
            synchronized (httpServerBase) {
                try {
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            l = this.accept - (System.currentTimeMillis() - l2);
            if (l < 0L) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        Runnable runnable;
        Object object;
        int n;
        Vector vector;
        String string = "";
        this.Z = true;
        ServerThread serverThread = null;
        if (this.shutdownTimeout > 0) {
            serverThread = new ServerThread(this, this.shutdownTimeout);
            serverThread.start();
        }
        if (this.state == 2) {
            vector = (Vector)this.serviceHandlers.clone();
            n = 0;
            while (n < vector.size()) {
                this.errMsg = null;
                object = (ServiceHandler)vector.elementAt(n);
                try {
                    ((ServiceHandler)object).I.close();
                }
                catch (IOException iOException) {
                    this.errMsg = iOException;
                    string = string + "Close " + ((ServiceHandler)object).C + " failed due to '" + iOException.getMessage() + "'. ";
                }
                runnable = this;
                synchronized (runnable) {
                    this.notifyAll();
                }
                this.fireServiceStopped((ServiceHandler)object, this.errMsg);
                ++n;
            }
        }
        vector = this.sockets;
        synchronized (vector) {
            n = this.sockets.size() - 1;
            while (n >= 0) {
                object = (Socket)this.sockets.elementAt(n);
                this.sockets.removeElementAt(n);
                try {
                    ((Socket)object).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                --n;
            }
        }
        Vector vector2 = this.handlerThreads;
        synchronized (vector2) {
            int n2 = this.handlerThreads.size() - 1;
            while (n2 >= 0) {
                runnable = (HttpServerHandlerBase)this.handlerThreads.elementAt(n2);
                try {
                    ((HttpServerHandlerBase)runnable).socket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.handlerThreads.removeElement(runnable);
                --n2;
            }
        }
        this.errMsg = !"".equals(string) ? new Exception(string) : null;
        if (this.shutdownTimeout > 0) {
            serverThread.I(true);
            ServerThread serverThread2 = serverThread;
            synchronized (serverThread2) {
                serverThread.notifyAll();
            }
        }
        this.C();
        this.removeServerListener(this);
        while (!this.activeCount) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void quit() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processStop() {
        Enumeration enumeration = this.loader.getServlets();
        while (enumeration.hasMoreElements()) {
            try {
                Servlet servlet = (Servlet)enumeration.nextElement();
                servlet.destroy();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        int n = 0;
        while (n < this.sockets.size()) {
            try {
                ((Socket)this.sockets.elementAt(n)).close();
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
            }
            ++n;
        }
        this.sockets.removeAllElements();
        System.gc();
        this.state = this.errMsg != null ? 4 : 3;
        this.fireServerStopped(this.errMsg);
        HttpServerBase httpServerBase = this;
        synchronized (httpServerBase) {
            this.notifyAll();
        }
        ServiceLogger.logDebug(6680034, 6);
        this.activeCount = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putConnection(Object object) {
        try {
            Queue queue = this.connections;
            synchronized (queue) {
                this.connections.add(object);
                this.connections.notify();
                return;
            }
        }
        catch (QueueFullException queueFullException) {
            throw new InternalError("putConnection, connection queue overflow");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConnection() {
        long l;
        HttpServerBase httpServerBase = this;
        synchronized (httpServerBase) {
            l = this.timeout;
            ++this.avail;
            this.notify();
        }
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        Queue queue = this.connections;
        synchronized (queue) {
            while (l3 < l) {
                if (!this.connections.empty()) break;
                try {
                    this.connections.wait(l - l3);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l3 = System.currentTimeMillis() - l2;
            }
            try {
                Object object = this.connections.remove();
                return object;
            }
            catch (QueueEmptyException queueEmptyException) {
                // MONITOREXIT @DISABLED, blocks:[1, 4, 6, 9] lbl32 : MonitorExitStatement: MONITOREXIT : var8_6
            }
            --this.total;
            --this.avail;
            return null;
        }
    }

    public Servlet getServletByClassName(String string) {
        Enumeration<?> enumeration = this.servletProps.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3 = (String)enumeration.nextElement();
            if (!string3.startsWith("servlet.") || !string3.endsWith(".code") || !(string2 = this.servletProps.getProperty(string3)).equals(string)) continue;
            String string4 = string3.substring(8, string3.length() - 5);
            return this.getServlet(string4);
        }
        return null;
    }

    public Servlet getServlet(String string) {
        String string2 = this.servletProps.getProperty("servlet." + string + ".code");
        String string3 = this.servletProps.getProperty("servlet." + string + ".initArgs");
        try {
            if (string2 == null) {
                return this.loader.loadServlet(string, new HttpServletConfig((ServletContext)this, string3, string));
            }
            return this.loader.loadServlet(string2, new HttpServletConfig((ServletContext)this, string3, string2));
        }
        catch (ServletException servletException) {
            servletException.printStackTrace();
            return null;
        }
    }

    public Servlet getServletEx(String string) {
        return this.getServlet(string);
    }

    public Enumeration getServlets() {
        return this.loader.getServlets();
    }

    public Enumeration getServletsEx() {
        return this.getServlets();
    }

    public Enumeration getServletNames() {
        return this.loader.getServletNames();
    }

    public Enumeration getServletNamesEx() {
        return this.getServletNames();
    }

    public void log(String string) {
        ServiceLogger.logEvent(string);
    }

    public void log(Exception exception, String string) {
    }

    public String getRealPath(String string) {
        String string2 = this.htmlPath;
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        if ((string = string.replace('/', File.separatorChar)).startsWith(File.separator)) {
            string = string.substring(1);
        }
        return string2 + string;
    }

    public String getServerInfo() {
        return this.name;
    }

    public Object getAttribute(String string) {
        return this.htAttr.get(string);
    }

    protected void printSettings() {
        PrintStream printStream = System.err;
        printStream.println("JRServer starting with settings:");
        printStream.println("  port = " + this.port);
        printStream.println("  max handlers = " + this.maxHandlers);
        printStream.println("  backlog = " + this.backlog);
        printStream.println("  timeout = " + this.timeout);
        printStream.println("  servlet propfile = " + this.servletPropFile);
    }

    public void serviceStarted(ServiceHandler serviceHandler, Object object) {
        ServiceLogger.logEvent(4680035, new Object[]{serviceHandler.getHostAddr(), String.valueOf(this.port), object != null ? object : ""}, 4);
    }

    public void serviceStopped(ServiceHandler serviceHandler, Object object) {
        ServiceLogger.logEvent(4680036, new Object[]{serviceHandler.getHostAddr(), String.valueOf(this.port), object != null ? object : ""}, 4);
    }

    public void serverStarted(HttpServerBase httpServerBase, Object object) {
        ServiceLogger.logEvent(4680037, object != null ? object : "", 4);
    }

    public void serverStopped(HttpServerBase httpServerBase, Object object) {
        ServiceLogger.logEvent(4680038, object != null ? object : "", 4);
    }

    public void fatalError(HttpServerBase httpServerBase, Object object) {
        if (object instanceof Exception) {
            ServiceLogger.logError((Exception)object);
            ((Exception)object).printStackTrace(System.err);
        }
    }

    public void error(HttpServerBase httpServerBase, Object object) {
        if (object instanceof Exception) {
            ServiceLogger.logError((Exception)object);
            ((Exception)object).printStackTrace(System.err);
        }
    }

    public void warning(HttpServerBase httpServerBase, Object object) {
        if (object instanceof Exception) {
            ServiceLogger.logError((Exception)object, 5);
            ((Exception)object).printStackTrace(System.err);
        }
    }

    public void message(HttpServerBase httpServerBase, Object object) {
        if (object instanceof Exception) {
            ServiceLogger.logError((Exception)object, 6);
            ((Exception)object).printStackTrace(System.err);
        }
    }

    public String getMimeType(String string) {
        if (string == null) {
            return null;
        }
        String string2 = "";
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string2 = string.substring(n);
        }
        if (this.mimeTypeTable == null) {
            this.mimeTypeTable = MIMETypeTable.getDefaultMIMETypeTable();
        }
        return this.mimeTypeTable.getMimeType(string2);
    }

    private String QOIV(String string) {
        String string2 = ServerEnv.htmlPath;
        String string3 = File.separator;
        if (!string.startsWith("/")) {
            return string2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            if (!string2.endsWith(string3)) {
                string2 = string2 + string3;
            }
            string2 = string2 + stringTokenizer.nextToken();
        }
        File file = new File(string2);
        if (file.exists()) {
            return string2;
        }
        return ServerEnv.htmlPath;
    }

    public Set getResoucePaths(String string) {
        String string2 = string;
        String string3 = "/";
        if (!string2.endsWith(string3)) {
            string2 = string2 + string3;
        }
        String string4 = this.QOIV(string);
        HashSet<String> hashSet = new HashSet<String>();
        File file = new File(string4);
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length > 0) {
            int n = 0;
            while (n < fileArray.length) {
                file = fileArray[n];
                string2 = file.isDirectory() ? string2 + file.getName() + string3 : string2 + file.getName();
                hashSet.add(string2);
                ++n;
            }
        }
        return hashSet;
    }

    public Hashtable getAppInitParameters() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = "context-param.";
        String string2 = "";
        String string3 = "";
        Enumeration<?> enumeration = this.servletProps.propertyNames();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            string3 = this.servletProps.getProperty(string2).trim();
            string2 = string2.substring(string.length()).trim();
            hashtable.put(string2, string3);
        }
        return hashtable;
    }

    public Set getResourcePaths(String string) {
        return null;
    }

    public RequestDispatcher getNamedDispatcher(String string) {
        return null;
    }

    public String getInitParameter(String string) {
        Hashtable hashtable = this.getAppInitParameters();
        String string2 = (String)hashtable.get(this.name);
        return string2;
    }

    public Enumeration getInitParameterNames() {
        Hashtable hashtable = this.getAppInitParameters();
        return hashtable.keys();
    }

    public String getServletContextName() {
        return null;
    }

    static {
        String string = "503 Service Unavailable";
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("<html><head><title>");
        stringBuffer.append(string);
        stringBuffer.append("</title></head>\n");
        stringBuffer.append("<h1>");
        stringBuffer.append(string);
        stringBuffer.append("</h1><body>\n");
        stringBuffer.append("<pre>\n");
        stringBuffer.append("Server is busy now, please try again later!");
        stringBuffer.append("\n</pre>\n");
        stringBuffer.append("<p>");
        stringBuffer.append("</body></html>\n");
        int n = stringBuffer.length();
        StringBuffer stringBuffer2 = new StringBuffer(100);
        stringBuffer2.append("HTTP/1.0 " + string);
        stringBuffer2.append("\nServer: JRServer/2.0 Technology Preview");
        stringBuffer2.append("\nContent-Type: text/html");
        stringBuffer2.append("\nContent-Length: " + n);
        stringBuffer2.append("\nConnection: close");
        stringBuffer2.append("\nDate: " + new Date());
        stringBuffer2.append("\n");
        try {
            busyHead = stringBuffer2.toString().getBytes();
            busyContent = stringBuffer.toString().getBytes();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

