/*
 * Decompiled with CFR 0.152.
 */
package server.servlet.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import jet.JSRuntimeException;
import jet.cs.CSUtil;
import jet.server.log.ServiceLogger;
import jet.util.Base64;
import server.servlet.ServletConnection;
import server.servlet.http.HttpRequest;
import server.servlet.http.HttpResponse;
import server.servlet.http.HttpServerBase;
import server.servlet.http.HttpSessionImpl;
import server.servlet.http.MessageBytes;
import server.servlet.util.Ascii;

public abstract class HttpServerHandlerBase
implements Runnable,
ServletConnection {
    protected HttpServerBase server;
    protected final HttpRequest req = new HttpRequest(this);
    protected final HttpResponse res = new HttpResponse();
    protected Socket socket;
    protected byte[] buf = new byte[512];
    protected static String PREFIX = "";
    protected static int PREFIX_LEN = PREFIX.length();

    protected HttpServerHandlerBase(HttpServerBase httpServerBase) {
        this.server = httpServerBase;
        this.req.setSessionContext(httpServerBase.getSessionContext());
        this.req.setResponse(this.res);
    }

    public void run() {
        Socket socket;
        while ((socket = (Socket)this.server.getConnection()) != null) {
            try {
                this.socket = socket;
                this.handleConnection(socket);
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException, 6);
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable, 5);
            }
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.server.handlerThreads.removeElement(this);
    }

    protected void handleConnection(Socket socket) throws IOException {
        this.req.init(this);
        this.res.init(this);
        while (this.req.next()) {
            this.res.next();
            if (this.req.getMajorVersion() < 1) {
                this.res.printKeepAlive();
            } else if (this.req.getMajorVersion() == 1) {
                this.res.printKeepAlive();
                this.res.setProtocol("HTTP/1.1");
                this.res.setHeader("Server", this.server.name);
            } else {
                this.res.setProtocol("HTTP/1.0");
                this.res.setHeader("Server", this.server.name);
                this.res.sendError(505);
                return;
            }
            this.res.setKeepAlive(this.req.getKeepAlive());
            try {
                this.PREFIX(this.req);
                HttpSession httpSession = this.req.getSession();
                if (httpSession != null) {
                    if (!((HttpSessionImpl)httpSession).isValid()) {
                        this.res.sendError(401);
                    } else {
                        this.service(this.req, this.res);
                    }
                } else {
                    this.service(this.req, this.res);
                }
            }
            catch (Exception exception) {
                if (this.res.getTotalBytes() == 0) {
                    try {
                        this.res.sendError(500);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                exception.printStackTrace();
            }
            this.req.finish();
            this.res.finish();
            if (this.res.getKeepAlive()) continue;
            return;
        }
    }

    private void PREFIX(HttpRequest httpRequest) {
        String string = httpRequest.getHeader("Authorization");
        if (string == null) {
            return;
        }
        String string2 = null;
        if (string.startsWith("Basic")) {
            string = string.substring(string.indexOf(32) + 1, string.length());
            try {
                string = CSUtil.getUrlEncoding() != null ? new String(Base64.decode((String)string), CSUtil.getUrlEncoding()) : new String(Base64.decode((String)string), "ISO-8859-1");
            }
            catch (IOException iOException) {
                return;
            }
            string2 = string.substring(0, string.indexOf(58));
        } else if (string.startsWith("Digest")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,=\"");
            stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (!string3.equals("username")) continue;
                string2 = stringTokenizer.nextToken();
                break;
            }
        }
        if (string2 != null) {
            httpRequest.setRemoteUser(string2);
        }
    }

    protected abstract void service(HttpRequest var1, HttpResponse var2) throws ServletException, IOException;

    protected String parsePath(MessageBytes messageBytes, HttpRequest httpRequest) {
        byte[] byArray = messageBytes.getBytes();
        httpRequest.setPathInfo(byArray, messageBytes.getOffset(), messageBytes.getLength());
        httpRequest.setServletPath(byArray, messageBytes.getOffset(), messageBytes.getLength());
        return CSUtil.convertEscapes(messageBytes.toString());
    }

    public String getServerName() {
        throw new JSRuntimeException(670018);
    }

    public int getServerPort() {
        return this.server.getServicePort();
    }

    public String getRemoteHost() {
        return this.socket.getInetAddress().getHostName();
    }

    public String getRemoteAddr() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public String getRealPath(String string) {
        return this.server.getRealPath(string);
    }

    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    protected String getValidPath(String string) {
        String string2 = string;
        int n = -1;
        if (string2 == null || string2.indexOf("%") > 0) {
            string2 = null;
        } else {
            n = string2.indexOf(".jsp");
            if (n > 0 && !string2.endsWith(".jsp")) {
                char c = string2.charAt(n + 4);
                if (!Ascii.isAlpha(c) && !Ascii.isDigit(c)) {
                    string2 = null;
                }
            } else {
                if (string2.equals("/.")) {
                    string2 = "/";
                }
                if (string2.indexOf(92) >= 0) {
                    string2 = string2.replace('\\', '/');
                }
                if (!string2.startsWith("/")) {
                    string2 = "/" + string2;
                }
                while ((n = string2.indexOf("//")) >= 0) {
                    string2 = string2.substring(0, n) + string2.substring(n + 1);
                }
                while ((n = string2.indexOf("/./")) >= 0) {
                    string2 = string2.substring(0, n) + string2.substring(n + 2);
                }
                while ((n = string2.indexOf("/../")) > 0) {
                    int n2 = string2.lastIndexOf(47, n - 1);
                    string2 = string2.substring(0, n2) + string2.substring(n + 3);
                }
                if (n == 0) {
                    string2 = string2.indexOf("#") < 0 || !"Enable".equals(this.req.getParameter("support.Anchor")) || Boolean.getBoolean("http.anchor.disable") ? null : "/." + string2;
                } else if (string2.indexOf("#") > 0 && !"Enable".equals(this.req.getParameter("support.Anchor"))) {
                    string2 = null;
                } else {
                    n = string2.indexOf("/servlet/sendfile/folderTree");
                    if (n > 0) {
                        string2 = string2.substring(n);
                    }
                }
            }
        }
        return string2;
    }
}

