/*
 * Decompiled with CFR 0.152.
 */
package server.servlet.http;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import server.servlet.http.SessionContextImpl;

public class HttpSessionImpl
implements HttpSession {
    private String QOIV;
    private long currentTimeMillis;
    private long get;
    private Hashtable getValue = new Hashtable();
    private SessionContextImpl hasMoreElements;
    private boolean keys;
    private boolean nextElement;
    private Cookie put;
    private boolean putValue;
    private boolean remove;
    private int removeSession;

    public HttpSessionImpl(SessionContextImpl sessionContextImpl, Cookie cookie) {
        this.get = this.currentTimeMillis = System.currentTimeMillis();
        this.hasMoreElements = sessionContextImpl;
        this.keys = false;
        this.put = cookie;
        this.QOIV = sessionContextImpl.setSession(this);
        cookie.setValue(this.QOIV);
        this.putValue = true;
        this.remove = true;
    }

    public void setNew(boolean bl) {
        this.putValue = bl;
    }

    public void setCookieSupported(boolean bl) {
        this.keys = true;
        this.nextElement = bl;
    }

    public void setLastAccessedTime() {
        this.get = System.currentTimeMillis();
    }

    public Cookie getCookie() {
        return this.put;
    }

    public boolean isCookieSupportDetermined() {
        if (this.remove) {
            new IllegalStateException("Attempt to access an invalidated session");
        }
        return this.keys;
    }

    public boolean isUsingCookies() {
        if (!this.remove) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return true;
    }

    public boolean isNew() {
        if (!this.remove) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return this.putValue;
    }

    public boolean isUsingUrlRewriting() {
        if (!this.remove) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return false;
    }

    public String getId() {
        if (!this.remove) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return this.QOIV;
    }

    public HttpSessionContext getSessionContext() {
        if (!this.remove) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return this.hasMoreElements;
    }

    public long getCreationTime() {
        if (!this.remove) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return this.currentTimeMillis;
    }

    public long getLastAccessedTime() {
        if (!this.remove) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return this.get;
    }

    public void invalidate() {
        if (!this.remove) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        this.hasMoreElements.removeSession(this.QOIV);
        this.remove = false;
    }

    public void putValue(String string, Object object) {
        if (!this.remove) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        this.removeValue(string);
        this.getValue.put(string, object);
        if (object instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)object).valueBound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
    }

    public Object getValue(String string) {
        if (!this.remove) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return this.getValue.get(string);
    }

    public void removeValue(String string) {
        if (!this.remove) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        Object v = this.getValue.get(string);
        if (v != null) {
            this.getValue.remove(string);
        }
        if (v instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)v).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
    }

    public String[] getValueNames() {
        if (!this.remove) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        String[] stringArray = new String[this.getValue.size()];
        int n = 0;
        Enumeration enumeration = this.getValue.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public boolean isValid() {
        return this.remove;
    }

    public int getMaxInactiveInterval() {
        return this.removeSession;
    }

    public void setMaxInactiveInterval(int n) {
        this.removeSession = n;
    }

    public Object getAttribute(String string) {
        return this.getValue(string);
    }

    public Enumeration getAttributeNames() {
        if (!this.remove) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return this.getValue.keys();
    }

    public void setAttribute(String string, Object object) {
        this.putValue(string, object);
    }

    public void removeAttribute(String string) {
        this.removeValue(string);
    }

    public ServletContext getServletContext() {
        return null;
    }
}

