/*
 * Decompiled with CFR 0.152.
 */
package server.servlet.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import jet.cs.CSUtil;
import server.servlet.http.HttpDate;
import server.servlet.util.Ascii;

public class MessageBytes
extends Ascii {
    protected byte[] bytes;
    protected int offset;
    protected int length;

    public MessageBytes() {
    }

    public MessageBytes(byte[] byArray, int n, int n2) {
        this.setBytes(byArray, n, n2);
    }

    public void reset() {
        this.bytes = null;
    }

    public void setBytes(byte[] byArray, int n, int n2) {
        this.bytes = byArray;
        this.offset = n;
        this.length = n2;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getBytes(byte[] byArray, int n) {
        if (this.bytes != null) {
            System.arraycopy(this.bytes, this.offset, byArray, n, this.length);
        }
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isSet() {
        return this.bytes != null;
    }

    public String toString() {
        if (this.bytes != null) {
            try {
                if (CSUtil.getUrlEncoding() != null) {
                    return new String(this.bytes, this.offset, this.length, CSUtil.getUrlEncoding());
                }
                return new String(this.bytes, this.offset, this.length, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(this.bytes, this.offset, this.length);
            }
        }
        return null;
    }

    public int toInteger() throws NumberFormatException {
        return Ascii.parseInt(this.bytes, this.offset, this.length);
    }

    public long toDate(HttpDate httpDate) throws IllegalArgumentException {
        if (this.bytes != null) {
            httpDate.parse(this.bytes, this.offset, this.length);
            return httpDate.getTime();
        }
        throw new IllegalArgumentException("invalid date format");
    }

    public boolean equals(String string) {
        byte[] byArray = this.bytes;
        int n = this.length;
        if (byArray == null || n != string.length()) {
            return false;
        }
        int n2 = this.offset;
        int n3 = 0;
        while (n3 < n) {
            if (byArray[n2++] != string.charAt(n3)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String string) {
        byte[] byArray = this.bytes;
        int n = this.length;
        if (byArray == null || n != string.length()) {
            return false;
        }
        int n2 = this.offset;
        int n3 = 0;
        while (n3 < n) {
            if (Ascii.toLower(byArray[n2++]) != Ascii.toLower(string.charAt(n3))) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public boolean equals(byte[] byArray, int n, int n2) {
        byte[] byArray2 = this.bytes;
        int n3 = this.length;
        if (byArray2 == null || n3 != n2) {
            return false;
        }
        int n4 = this.offset + n3;
        int n5 = this.offset;
        while (n5 < n4) {
            if (byArray2[n5] != byArray[n++]) {
                return false;
            }
            ++n5;
        }
        return true;
    }

    public boolean equalsIgnoreCase(byte[] byArray, int n, int n2) {
        byte[] byArray2 = this.bytes;
        int n3 = this.length;
        if (byArray2 == null || n3 != n2) {
            return false;
        }
        int n4 = this.offset + n3;
        int n5 = this.offset;
        while (n5 < n4) {
            if (Ascii.toLower(byArray2[n5]) != Ascii.toLower(byArray[n++])) {
                return false;
            }
            ++n5;
        }
        return true;
    }

    public boolean startsWith(String string) {
        byte[] byArray = this.bytes;
        int n = string.length();
        if (byArray == null || n > this.length) {
            return false;
        }
        int n2 = this.offset;
        int n3 = 0;
        while (n3 < n) {
            if (byArray[n2++] != string.charAt(n3)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.bytes == null) {
            return;
        }
        outputStream.write(this.bytes, this.offset, this.length);
    }

    public int length() {
        if (this.bytes == null) {
            return 0;
        }
        return this.length;
    }
}

