/*
 * Decompiled with CFR 0.152.
 */
package server.servlet.http;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import server.servlet.http.MimeHeaderField;
import server.servlet.http.MimeHeadersEnumerator;

public class MimeHeaders {
    private MimeHeaderField[] QOIV = new MimeHeaderField[8];
    private int addElement;
    private byte[] append = new byte[512];

    public MimeHeaders(int n) {
    }

    public MimeHeaders() {
        this(512);
    }

    public void clear() {
        int n = 0;
        while (n < this.addElement) {
            this.QOIV[n].reset();
            ++n;
        }
        this.addElement = 0;
    }

    public int size() {
        return this.addElement;
    }

    public Enumeration names() {
        return new MimeHeadersEnumerator(this);
    }

    public void putHeader(String string, String string2) {
        this.putHeader(string).setValue(string2);
    }

    public void putIntHeader(String string, int n) {
        this.putHeader(string).setIntValue(n);
    }

    public void putDateHeader(String string, long l) {
        this.putHeader(string).setDateValue(l);
    }

    public void putDateHeader(String string) {
        this.putHeader(string).setDateValue();
    }

    public String getHeader(String string) {
        MimeHeaderField mimeHeaderField = this.find(string);
        if (mimeHeaderField != null) {
            return mimeHeaderField.getValue();
        }
        return null;
    }

    public String[] getHeaders(String string) {
        Vector<String> vector = new Vector<String>();
        Object[] objectArray = null;
        int n = 0;
        while (n < this.addElement) {
            if (this.QOIV[n].nameEquals(string)) {
                vector.addElement(this.QOIV[n].getValue());
            }
            ++n;
        }
        if (vector.size() > 0) {
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public int getIntHeader(String string) throws NumberFormatException {
        MimeHeaderField mimeHeaderField = this.find(string);
        if (mimeHeaderField != null) {
            return mimeHeaderField.getIntValue();
        }
        return -1;
    }

    public long getDateHeader(String string) throws IllegalArgumentException {
        MimeHeaderField mimeHeaderField = this.find(string);
        if (mimeHeaderField != null) {
            return mimeHeaderField.getDateValue();
        }
        return 0L;
    }

    public String getHeaderName(int n) {
        if (n >= 0 && n < this.addElement) {
            return this.QOIV[n].getName();
        }
        return null;
    }

    public String getHeader(int n) {
        if (n >= 0 && n < this.addElement) {
            return this.QOIV[n].getValue();
        }
        return null;
    }

    protected MimeHeaderField getField(int n) {
        if (n >= 0 && n < this.addElement) {
            return this.QOIV[n];
        }
        return null;
    }

    public int getFieldCount(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.addElement) {
            if (this.QOIV[n2].nameEquals(string)) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    protected MimeHeaderField find(String string) {
        int n = 0;
        while (n < this.addElement) {
            if (this.QOIV[n].nameEquals(string)) {
                return this.QOIV[n];
            }
            ++n;
        }
        return null;
    }

    public void removeHeader(String string) {
        int n = 0;
        while (n < this.addElement) {
            if (this.QOIV[n].nameEquals(string)) {
                MimeHeaderField mimeHeaderField = this.QOIV[n];
                mimeHeaderField.reset();
                this.QOIV[n] = this.QOIV[--this.addElement];
                this.QOIV[this.addElement] = mimeHeaderField;
            }
            ++n;
        }
    }

    public boolean containsHeader(String string) {
        return this.find(string) != null;
    }

    public void read(ServletInputStream servletInputStream) throws IOException {
        byte[] byArray = this.addElement == 0 ? this.append : new byte[this.append.length];
        int n = 0;
        while (true) {
            int n2 = n;
            while (true) {
                int n3;
                if ((n3 = byArray.length - n) > 0 && (n3 = servletInputStream.readLine(byArray, n, n3)) == -1) {
                    throw new IOException("Connection reset.");
                }
                if (n3 == 0 || byArray[(n += n3) - 1] == 10) break;
                byte[] byArray2 = new byte[byArray.length * 2];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray = byArray2;
            }
            if (--n > n2 && byArray[n - 1] == 13) {
                --n;
            }
            if (n == n2) {
                return;
            }
            this.putHeader().parse(byArray, n2, n - n2);
        }
    }

    public void write(ServletOutputStream servletOutputStream) throws IOException {
        int n = 0;
        while (n < this.addElement) {
            this.QOIV[n].write(servletOutputStream);
            ++n;
        }
        servletOutputStream.println();
    }

    protected MimeHeaderField putHeader(String string) {
        MimeHeaderField mimeHeaderField = this.find(string);
        if (mimeHeaderField == null) {
            mimeHeaderField = this.putHeader();
            mimeHeaderField.setName(string);
        }
        return mimeHeaderField;
    }

    void I(String string, String string2) {
        MimeHeaderField mimeHeaderField = this.putHeader();
        mimeHeaderField.setName(string);
        mimeHeaderField.setValue(string2);
    }

    protected MimeHeaderField putHeader() {
        MimeHeaderField mimeHeaderField;
        int n = this.QOIV.length;
        if (this.addElement == n) {
            MimeHeaderField[] mimeHeaderFieldArray = new MimeHeaderField[this.addElement * 2];
            System.arraycopy(this.QOIV, 0, mimeHeaderFieldArray, 0, n);
            this.QOIV = mimeHeaderFieldArray;
        }
        if ((mimeHeaderField = this.QOIV[this.addElement]) == null) {
            this.QOIV[this.addElement] = mimeHeaderField = new MimeHeaderField();
        }
        ++this.addElement;
        return mimeHeaderField;
    }

    public int getAll(byte[] byArray, int n) {
        int n2 = n;
        int n3 = 0;
        while (n3 < this.addElement) {
            n += this.QOIV[n3].getBytes(byArray, n);
            ++n3;
        }
        return n - n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n = 0;
        while (n < this.addElement) {
            stringBuffer.append("{");
            stringBuffer.append(this.QOIV[n].toString());
            stringBuffer.append("}");
            if (n < this.addElement - 1) {
                stringBuffer.append(",");
            }
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void dump(PrintStream printStream) {
        int n = 0;
        while (n < this.addElement) {
            printStream.println(this.QOIV[n]);
            ++n;
        }
    }
}

