/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ClassParser;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.Unknown;

public class Play {
    public static void printBytes(byte[] bs) {
        StringBuilder sb = new StringBuilder("Bytes:" + bs.length + "[");
        int i = 0;
        while (i < bs.length) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(bs[i]);
            ++i;
        }
        sb.append("]");
        System.out.println(sb);
    }

    public static void main(String[] args) throws Exception {
        int n;
        if (args == null || args.length == 0) {
            System.out.println("Specify a file");
            return;
        }
        if (!args[0].endsWith(".class")) {
            args[0] = String.valueOf(args[0]) + ".class";
        }
        FileInputStream fis = new FileInputStream(new File(args[0]));
        ClassParser cp = new ClassParser(fis, args[0]);
        JavaClass jc = cp.parse();
        Attribute[] attributes = jc.getAttributes();
        Play.printUsefulAttributes(attributes);
        System.out.println("Fields");
        Field[] fs = jc.getFields();
        if (fs != null) {
            Field[] fieldArray = fs;
            n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                System.out.println(f);
                Play.printUsefulAttributes(f.getAttributes());
                ++n2;
            }
        }
        System.out.println("Methods");
        Method[] ms = jc.getMethods();
        if (ms != null) {
            Method[] methodArray = ms;
            int n3 = ms.length;
            n = 0;
            while (n < n3) {
                Method m = methodArray[n];
                System.out.println(m);
                Play.printUsefulAttributes(m.getAttributes());
                System.out.println("Code attributes:");
                Play.printUsefulAttributes(m.getCode().getAttributes());
                ++n;
            }
        }
    }

    private static void printUsefulAttributes(Attribute[] attributes) {
        Attribute[] attributeArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            String n3 = attribute.getName();
            if (n3.equals("RuntimeInvisibleTypeAnnotations") || n3.equals("RuntimeVisibleTypeAnnotations")) {
                Unknown unknown = (Unknown)attribute;
                byte[] bs = unknown.getBytes();
                Play.printBytes(bs);
            }
            ++n2;
        }
    }
}

