/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.TimeoutMap;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.support.TimeoutMapEntry;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTimeoutMap<K, V>
extends ServiceSupport
implements TimeoutMap<K, V>,
Runnable {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<K, TimeoutMapEntry<K, V>> map = new ConcurrentHashMap<K, TimeoutMapEntry<K, V>>();
    private final ScheduledExecutorService executor;
    private final long purgePollTime;
    private final Lock lock = new ReentrantLock();
    private boolean useLock = true;

    public DefaultTimeoutMap(ScheduledExecutorService executor) {
        this(executor, 1000L);
    }

    public DefaultTimeoutMap(ScheduledExecutorService executor, long requestMapPollTimeMillis) {
        this(executor, requestMapPollTimeMillis, true);
    }

    public DefaultTimeoutMap(ScheduledExecutorService executor, long requestMapPollTimeMillis, boolean useLock) {
        ObjectHelper.notNull(executor, "ScheduledExecutorService");
        this.executor = executor;
        this.purgePollTime = requestMapPollTimeMillis;
        this.useLock = useLock;
        this.schedulePoll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        TimeoutMapEntry entry;
        if (this.useLock) {
            this.lock.lock();
        }
        try {
            entry = (TimeoutMapEntry)this.map.get(key);
            if (entry == null) {
                V v = null;
                return v;
            }
            this.updateExpireTime(entry);
        }
        finally {
            if (this.useLock) {
                this.lock.unlock();
            }
        }
        return entry.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value, long timeoutMillis) {
        TimeoutMapEntry<K, V> entry = new TimeoutMapEntry<K, V>(key, value, timeoutMillis);
        if (this.useLock) {
            this.lock.lock();
        }
        try {
            this.map.put(key, entry);
            this.updateExpireTime(entry);
        }
        finally {
            if (this.useLock) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key) {
        TimeoutMapEntry entry;
        if (this.useLock) {
            this.lock.lock();
        }
        try {
            entry = (TimeoutMapEntry)this.map.remove(key);
        }
        finally {
            if (this.useLock) {
                this.lock.unlock();
            }
        }
        return entry != null ? (V)entry.getValue() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getKeys() {
        Object[] keys;
        if (this.useLock) {
            this.lock.lock();
        }
        try {
            Set keySet = this.map.keySet();
            keys = new Object[keySet.size()];
            keySet.toArray(keys);
        }
        finally {
            if (this.useLock) {
                this.lock.unlock();
            }
        }
        return keys;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void run() {
        if (!this.isRunAllowed()) {
            this.log.trace("Purge task not allowed to run");
            return;
        }
        this.log.trace("Running purge task to see if any entries has been timed out");
        try {
            this.purge();
        }
        catch (Throwable t) {
            this.log.warn("Exception occurred during purge task. This exception will be ignored.", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge() {
        this.log.trace("There are {} in the timeout map", (Object)this.map.size());
        long now = this.currentTime();
        ArrayList expired = new ArrayList();
        if (this.useLock) {
            this.lock.lock();
        }
        try {
            for (Map.Entry entry : this.map.entrySet()) {
                if (((TimeoutMapEntry)entry.getValue()).getExpireTime() >= now || !this.isValidForEviction((TimeoutMapEntry)entry.getValue())) continue;
                this.log.debug("Evicting inactive entry ID: {}", entry.getValue());
                expired.add(entry.getValue());
            }
            if (!expired.isEmpty()) {
                Collections.sort(expired, new Comparator<TimeoutMapEntry<K, V>>(){

                    @Override
                    public int compare(TimeoutMapEntry<K, V> a, TimeoutMapEntry<K, V> b) {
                        long diff = a.getExpireTime() - b.getExpireTime();
                        if (diff == 0L) {
                            return 0;
                        }
                        return diff > 0L ? 1 : -1;
                    }
                });
                ArrayList evicts = new ArrayList(expired.size());
                try {
                    for (TimeoutMapEntry entry : expired) {
                        boolean evict = this.onEviction(entry.getKey(), entry.getValue());
                        if (!evict) continue;
                        evicts.add(entry.getKey());
                    }
                }
                finally {
                    for (Object key : evicts) {
                        this.map.remove(key);
                    }
                }
            }
        }
        finally {
            if (this.useLock) {
                this.lock.unlock();
            }
        }
    }

    public long getPurgePollTime() {
        return this.purgePollTime;
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    protected void schedulePoll() {
        this.executor.scheduleWithFixedDelay(this, 0L, this.purgePollTime, TimeUnit.MILLISECONDS);
    }

    protected boolean isValidForEviction(TimeoutMapEntry<K, V> entry) {
        return true;
    }

    @Override
    public boolean onEviction(K key, V value) {
        return true;
    }

    protected void updateExpireTime(TimeoutMapEntry<K, V> entry) {
        long now = this.currentTime();
        entry.setExpireTime(entry.getTimeout() + now);
    }

    protected long currentTime() {
        return System.currentTimeMillis();
    }

    @Override
    protected void doStart() throws Exception {
        if (this.executor.isShutdown()) {
            throw new IllegalStateException("The ScheduledExecutorService is shutdown");
        }
    }

    @Override
    protected void doStop() throws Exception {
        this.map.clear();
    }
}

