/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.spi;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.objectweb.carol.jndi.spi.MultiContext;
import org.objectweb.carol.util.configuration.CarolDefaultValues;
import org.objectweb.carol.util.configuration.ConfigurationRepository;
import org.objectweb.carol.util.configuration.Protocol;
import org.objectweb.carol.util.configuration.TraceCarol;

public class MultiOrbInitialContextFactory
implements InitialContextFactory {
    public Context getInitialContext(Hashtable env) throws NamingException {
        String initFactory;
        String providerURL = null;
        if (env != null) {
            providerURL = (String)env.get("java.naming.provider.url");
        }
        if (providerURL == null) {
            if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("No provider URL, use multiprotocol context");
            }
            return new MultiContext(env);
        }
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("Use provider URL of the environment '" + providerURL + "'.");
        }
        if ((initFactory = (String)env.get("java.naming.factory.initial")) != null && initFactory.equals("org.objectweb.carol.jndi.spi.MultiOrbInitialContextFactory")) {
            initFactory = null;
        }
        if (initFactory == null) {
            String protocolName = CarolDefaultValues.getRMIProtocol(providerURL);
            Protocol protocol = ConfigurationRepository.getProtocol(protocolName);
            if (protocol == null) {
                throw new NamingException("The protocol '" + protocolName + "' is not available within carol.");
            }
            initFactory = protocol.getInitialContextFactoryClassName();
            env.put("java.naming.factory.initial", initFactory);
            if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("No INITIAL_CONTEXT_FACTORY, use '" + initFactory + "' as InitialContext factory.");
            }
        }
        return new InitialContext(env);
    }
}

