/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import antlr.collections.AST;
import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import java.util.Deque;

public abstract class AbstractSuperCheck
extends Check {
    public static final String MSG_KEY = "missing.super.call";
    private final Deque<MethodNode> methodStack = Lists.newLinkedList();

    @Override
    public int[] getDefaultTokens() {
        return new int[]{9, 79};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9, 79};
    }

    protected abstract String getMethodName();

    @Override
    public void beginTree(DetailAST rootAST) {
        this.methodStack.clear();
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (this.isOverridingMethod(ast)) {
            this.methodStack.add(new MethodNode(ast));
        } else if (this.isSuperCall(ast)) {
            MethodNode methodNode = this.methodStack.getLast();
            methodNode.setCallingSuper();
        }
    }

    private boolean isSuperCall(DetailAST ast) {
        if (ast.getType() != 79) {
            return false;
        }
        DetailAST parent = ast.getParent();
        if (parent == null || parent.getType() != 59) {
            return false;
        }
        AST sibling = ast.getNextSibling();
        if (sibling != null && sibling.getType() == 163) {
            sibling = sibling.getNextSibling();
        }
        if (sibling == null || sibling.getType() != 58) {
            return false;
        }
        String name = sibling.getText();
        if (!this.getMethodName().equals(name)) {
            return false;
        }
        DetailAST args = parent.getNextSibling();
        if (args == null || args.getType() != 34) {
            return false;
        }
        if (args.getChildCount() != 0) {
            return false;
        }
        while (parent != null) {
            if (parent.getType() == 9) {
                return this.isOverridingMethod(parent);
            }
            if (parent.getType() == 8 || parent.getType() == 11) {
                return false;
            }
            parent = parent.getParent();
        }
        return false;
    }

    @Override
    public void leaveToken(DetailAST ast) {
        MethodNode methodNode;
        if (this.isOverridingMethod(ast) && !(methodNode = this.methodStack.removeLast()).isCallingSuper()) {
            DetailAST methodAST = methodNode.getMethod();
            DetailAST nameAST = methodAST.findFirstToken(58);
            this.log(nameAST.getLineNo(), nameAST.getColumnNo(), MSG_KEY, nameAST.getText());
        }
    }

    private boolean isOverridingMethod(DetailAST ast) {
        if (ast.getType() != 9 || ScopeUtils.inInterfaceOrAnnotationBlock(ast)) {
            return false;
        }
        DetailAST nameAST = ast.findFirstToken(58);
        String name = nameAST.getText();
        if (!this.getMethodName().equals(name)) {
            return false;
        }
        DetailAST params = ast.findFirstToken(20);
        return params.getChildCount() == 0;
    }

    private static class MethodNode {
        private final DetailAST method;
        private boolean callingSuper;

        public MethodNode(DetailAST ast) {
            this.method = ast;
            this.callingSuper = false;
        }

        public void setCallingSuper() {
            this.callingSuper = true;
        }

        public boolean isCallingSuper() {
            return this.callingSuper;
        }

        public DetailAST getMethod() {
            return this.method;
        }
    }
}

