/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cmsmetrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.codahale.metrics.servlet.InstrumentedFilterContextListener;
import com.ericsson.cmsmetrics.CMSMetricRegistry;
import com.ericsson.cmsmetrics.metrics.CMSMetricRecorder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContextEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSMetricsContextListener
extends InstrumentedFilterContextListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CMSMetricsContextListener.class);
    private static String CMS_METRICS_NAME_PARAM = "cms-metricsname-prefix";
    private static String JVM_METRICS_REQUIRED = "jvm.metrics.required";

    public MetricRegistry getMetricRegistry() {
        return CMSMetricRegistry.getRegistry();
    }

    public void contextInitialized(ServletContextEvent sce) {
        String initParamValue = sce.getServletContext().getInitParameter(CMS_METRICS_NAME_PARAM);
        if (initParamValue == null || initParamValue.trim().length() == 0) {
            initParamValue = sce.getServletContext().getServletContextName();
        }
        String jvmMetricsParamValue = sce.getServletContext().getInitParameter(JVM_METRICS_REQUIRED);
        super.contextInitialized(sce);
        MetricRegistry registry = this.getMetricRegistry();
        if (jvmMetricsParamValue == null) {
            this.registerJVMMetrics(registry);
            LOGGER.info("JVM Metrics Collection Configured Successfully...");
        } else {
            LOGGER.info("JVM Metrics Collection Not Configured...");
        }
        this.reportToGraphitePort(registry, initParamValue);
        LOGGER.info("CMS Graphite Reporting Configured Successfully...");
        LOGGER.info("CMSMetricsContextListener is initialized successfully...");
    }

    private void registerJVMMetrics(MetricRegistry registry) {
        BufferPoolMetricSet bufferPoolMetricSet = new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer());
        ClassLoadingGaugeSet classLoadingGaugeSet = new ClassLoadingGaugeSet();
        FileDescriptorRatioGauge fileDescriptorRatioGauge = new FileDescriptorRatioGauge();
        GarbageCollectorMetricSet garbageCollectorMetricSet = new GarbageCollectorMetricSet();
        MemoryUsageGaugeSet memoryUsageGaugeSet = new MemoryUsageGaugeSet();
        ThreadStatesGaugeSet threadStatesGaugeSet = new ThreadStatesGaugeSet();
        for (Map.Entry entry : bufferPoolMetricSet.getMetrics().entrySet()) {
            registry.register("bufferpool." + (String)entry.getKey(), (Metric)entry.getValue());
        }
        for (Map.Entry entry : classLoadingGaugeSet.getMetrics().entrySet()) {
            registry.register("classes." + (String)entry.getKey(), (Metric)entry.getValue());
        }
        registry.registerAll((MetricSet)garbageCollectorMetricSet);
        registry.registerAll((MetricSet)memoryUsageGaugeSet);
        for (Map.Entry entry : threadStatesGaugeSet.getMetrics().entrySet()) {
            registry.register("threads." + (String)entry.getKey(), (Metric)entry.getValue());
        }
        registry.register("file.descriptor.ratio", (Metric)fileDescriptorRatioGauge);
    }

    private void reportToGraphitePort(MetricRegistry registry, String initParamValue) {
        Properties props = this.loadMetricsProperties();
        String graphiteHost = props.getProperty("graphite.host");
        Integer graphitePort = Integer.parseInt(props.getProperty("graphite.port"));
        Long graphiteInterval = Long.parseLong(props.getProperty("graphite.minutes.interval"));
        Graphite graphite = new Graphite(new InetSocketAddress(graphiteHost, (int)graphitePort));
        registry.register("CMSMetricRecorder", (Metric)new CMSMetricRecorder(graphite, initParamValue));
        GraphiteReporter graphiteReporter = GraphiteReporter.forRegistry((MetricRegistry)registry).prefixedWith(initParamValue).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build(graphite);
        graphiteReporter.start(graphiteInterval.longValue(), TimeUnit.MINUTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadMetricsProperties() {
        Properties prop = new Properties();
        InputStream input = null;
        try {
            input = CMSMetricsContextListener.class.getClassLoader().getResourceAsStream("metrics.properties");
            prop.load(input);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return prop;
    }
}

