/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test;

import com.ericsson.cms.test.RunStatus;
import com.ericsson.cms.test.TestResult;
import com.ericsson.cms.test.TestResults;

public class ResultNotifier {
    private String testClassName;
    private String testRunId;
    private RunStatus status;
    private boolean dbBackupRequired = false;
    private TestResults testResults;

    public ResultNotifier(String testClassName, String testRunId) {
        this.testClassName = testClassName;
        this.testRunId = testRunId;
        this.status = RunStatus.RUNNING;
        this.testResults = new TestResults(testClassName);
    }

    public void logTestCaseResult(TestResult result) {
        this.testResults.getResults().add(result);
    }

    public TestResults getTestResults() {
        return this.testResults;
    }

    public String getTestClassName() {
        return this.testClassName;
    }

    public String getTestRunId() {
        return this.testRunId;
    }

    public synchronized void setReady() {
        this.status = RunStatus.READY;
    }

    public synchronized RunStatus getStatus() {
        return this.status;
    }

    public void setDbBackupRequired(boolean dbBackupRequired) {
        this.dbBackupRequired = dbBackupRequired;
    }

    public boolean isDbBackupRequired() {
        return this.dbBackupRequired;
    }
}

