/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test.client;

import com.ericsson.cms.test.client.CommandException;
import com.ericsson.cms.test.client.TestClientConfig;
import java.io.IOException;
import java.io.InputStream;

public class RemoteCommadExecuter {
    private static final String ERROR_WHILE_RUNNING = "Error while running: ";
    private TestClientConfig config;

    public RemoteCommadExecuter(TestClientConfig config) {
        this.config = config;
    }

    public void restartJboss() throws CommandException {
        System.out.println("Restarting JBoss. command: " + this.config.getServerConfig().getReStartJbossCmd());
        this.runCmdScript(this.config.getServerConfig().getReStartJbossCmd(), false);
        System.out.println("Finished restarting jboss.");
    }

    public void stopJboss() throws CommandException {
        System.out.println("stopping JBoss. command: " + this.config.getServerConfig().getStopJbossCmd());
        this.runCmdScript(this.config.getServerConfig().getStopJbossCmd(), true);
        System.out.println("Finished stopping jboss.");
    }

    private void runCmdScript(String command, boolean wait) throws CommandException {
        try {
            Process p = Runtime.getRuntime().exec(command);
            if (!wait) {
                return;
            }
            p.waitFor();
            String output = this.getStream(p.getInputStream());
            System.out.println(output);
            if (p.exitValue() != 0 || this.containsKnownErrorPattern(output)) {
                System.out.println(this.getStream(p.getErrorStream()));
                throw new CommandException(ERROR_WHILE_RUNNING + command);
            }
        }
        catch (Exception e) {
            throw new CommandException(ERROR_WHILE_RUNNING + command, e);
        }
    }

    private boolean containsKnownErrorPattern(String output) {
        return (output = output.toLowerCase()).contains("error") || output.contains("cms: unrecognized service");
    }

    private String getStream(InputStream in) throws IOException {
        int result;
        StringBuilder sb = new StringBuilder();
        int bytesToRead = 1024;
        byte[] input = new byte[bytesToRead];
        for (int bytesRead = 0; bytesRead < bytesToRead; bytesRead += result) {
            result = in.read(input, bytesRead, bytesToRead - bytesRead);
            sb.append(new String(input));
            if (result == -1) break;
        }
        in.close();
        return sb.toString();
    }
}

