/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test.client;

import com.ericsson.cms.test.StandardUnitTestEntry;
import com.ericsson.cms.test.client.Command;
import com.ericsson.cms.test.client.EmailConfig;
import com.ericsson.cms.test.client.RunTestCommand;
import com.ericsson.cms.test.client.RunWOTestsCommand;
import com.ericsson.cms.test.client.TestClientConfig;
import com.ericsson.cms.test.client.TestClientException;
import com.ericsson.cms.test.client.TestCommandImpl;
import com.ericsson.cms.test.client.TestResultsCache;
import com.ericsson.cms.test.client.TestRunResults;
import com.ericsson.cms.test.client.report.junit.JunitReportJaxbService;
import com.ericsson.cms.test.util.DateUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class TestClient {
    private static Logger logger = Logger.getLogger(TestClient.class);
    private TestClientConfig config = new TestClientConfig();
    private EmailConfig emailConfig = new EmailConfig();
    private String testRunId = DateUtil.getUTCTimestamp();

    public void run(File commandFile) throws TestClientException {
        this.readConfigFile(new File("TestClient.cfg"));
        this.readEmailConfig(new File("emails.cfg"));
        List<Command> commands = this.readCommands(commandFile);
        this.runCommands(commands);
        this.generateReports();
    }

    private void readConfigFile(File configFile) throws TestClientException {
        logger.info((Object)("Reading config file " + configFile.getAbsolutePath()));
        this.config.load(configFile);
    }

    private void readEmailConfig(File file) {
        logger.info((Object)("Reading email config file " + file.getAbsolutePath()));
        try {
            this.emailConfig.load(file);
        }
        catch (Exception ex) {
            logger.warn((Object)"Could not read email configuration file");
        }
    }

    private List<Command> readCommands(File commandFile) {
        logger.info((Object)("Reading command file " + commandFile.getAbsolutePath()));
        ArrayList<Command> list = new ArrayList<Command>();
        try {
            String line;
            BufferedReader rd = new BufferedReader(new FileReader(commandFile));
            while ((line = rd.readLine()) != null) {
                String msg;
                TestCommandImpl cmd;
                String[] tokens;
                String tmp = line.toLowerCase();
                if (tmp.startsWith("runtest")) {
                    tokens = line.split(" ");
                    if (tokens.length == 3) {
                        cmd = new RunTestCommand(tokens[1], null, tokens[2], this.testRunId, this.config);
                        list.add(cmd);
                        continue;
                    }
                    msg = "Invalid number of arguments. Expected 'RunTest <class name> <component name>', but got '" + line + "'";
                    throw new RuntimeException(msg);
                }
                if (tmp.startsWith("runjunittest")) {
                    tokens = line.split(" ");
                    if (tokens.length == 3) {
                        cmd = new RunTestCommand(StandardUnitTestEntry.class.getSimpleName(), tokens[1], tokens[2], this.testRunId, this.config);
                        list.add(cmd);
                        continue;
                    }
                    msg = "Invalid number of arguments. Expected 'RunJUnitTest <package name> <component name>', but got '" + line + "'";
                    throw new RuntimeException(msg);
                }
                if (!tmp.startsWith("runwotest")) continue;
                tokens = line.split(" ");
                if (tokens.length == 3) {
                    cmd = new RunWOTestsCommand(tokens[1], tokens[2], this.testRunId, this.config);
                    list.add(cmd);
                    continue;
                }
                msg = "Invalid number of arguments. Expected 'RunWOTest <workorder test file> <component name>', but got '" + line + "'";
                throw new RuntimeException(msg);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        return list;
    }

    private void runCommands(List<Command> commands) {
        int len = commands.size();
        for (int i = 0; i < commands.size(); ++i) {
            logger.info((Object)("Running command " + (i + 1) + " of " + len + "..."));
            try {
                Command cmd = commands.get(i);
                cmd.run();
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void generateReports() {
        logger.info((Object)"Generating reports...");
        TestRunResults results = TestResultsCache.getInstance().getTestRunResults();
        try {
            File reportFile = new File("TestReport.xml");
            FileWriter writer = new FileWriter(reportFile);
            JunitReportJaxbService service = new JunitReportJaxbService();
            service.marshalTestRunResults(results, writer);
            writer.close();
            logger.info((Object)"Done");
        }
        catch (Exception ex) {
            logger.error((Object)"Could not generate report", (Throwable)ex);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            TestClient.printUsage();
            return;
        }
        String commandFileName = args[0].trim();
        TestClient client = new TestClient();
        client.run(new File(commandFileName));
    }

    private static void printUsage() {
        System.out.println("USAGE: TestClient <command file path>");
    }
}

