/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test.client.report;

import com.ericsson.cms.test.TestResult;
import com.ericsson.cms.test.TestResults;
import com.ericsson.cms.test.client.TestRunResults;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class HtmlReportGenerator {
    private static final String CSS_FILE = "report-style.css";

    public static void writeSummaryReport(TestRunResults results, Writer writer) throws IOException {
        writer.write("<html>\n");
        writer.write("<head>\n");
        HtmlReportGenerator.writeStyleElement(writer);
        writer.write("</head>\n");
        writer.write("<body>\n");
        for (String componentName : results.getComponentNames()) {
            HtmlReportGenerator._writeComponentReport(componentName, results.getResultsByComponentName(componentName), writer);
            writer.write("<br><br>");
        }
        writer.write("\n</body>\n");
        writer.write("\n</html>\n");
    }

    public static void writeComponentReport(String componentName, List<TestResults> resultsList, Writer writer) throws IOException {
        HtmlReportGenerator.writeStyleElement(writer);
        HtmlReportGenerator._writeComponentReport(componentName, resultsList, writer);
    }

    private static void _writeComponentReport(String componentName, List<TestResults> resultsList, Writer writer) throws IOException {
        writer.write("<span class=\"componentName\">" + componentName + "</span><br>");
        for (TestResults results : resultsList) {
            writer.write("<span class=\"testerName\">" + results.getClassName() + "</span><br>" + HtmlReportGenerator.formatAsHTMLTable(results.getResults()) + "<br>");
        }
        writer.flush();
    }

    private static void writeStyleElement(Writer writer) throws IOException {
        String line;
        writer.write("\n<style type=\"text/css\">\n");
        BufferedReader reader = new BufferedReader(new FileReader(CSS_FILE));
        while ((line = reader.readLine()) != null) {
            writer.write(line);
            writer.write(10);
        }
        writer.write("</style>\n");
    }

    private static String formatAsHTMLTable(List<TestResult> results) {
        StringBuilder sb = new StringBuilder(1000);
        sb.append("\n");
        sb.append("<table class=\"resultsTable\">");
        sb.append("\n");
        sb.append("<tr class=\"headerRow\"><th>Test Case</th><th>Status</th><th>Error Message</th></tr>");
        for (TestResult tr : results) {
            sb.append("\n");
            sb.append("<tr class=\"").append(tr.getTestStatus().name().toLowerCase()).append("Row\">");
            sb.append("<td>").append(tr.getTestCaseName()).append("</td>");
            sb.append("<td>").append((Object)tr.getTestStatus()).append("</td>");
            sb.append("<td>").append(tr.getErrorMsg() == null ? "" : tr.getErrorMsg()).append("</td>");
            sb.append("</tr>");
        }
        sb.append("\n");
        sb.append("</table>");
        return sb.toString();
    }
}

