/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test.client.report.junit;

import com.ericsson.cms.test.TestResult;
import com.ericsson.cms.test.TestResults;
import com.ericsson.cms.test.TestStatus;
import com.ericsson.cms.test.client.TestRunResults;
import com.ericsson.cms.test.client.report.junit.gen.Error;
import com.ericsson.cms.test.client.report.junit.gen.Testcase;
import com.ericsson.cms.test.client.report.junit.gen.Testsuite;
import com.ericsson.cms.test.client.report.junit.gen.Testsuites;
import java.util.List;

public class JunitReportFactory {
    public Testsuites createTestsuites(TestRunResults results) {
        if (results == null) {
            return null;
        }
        Testsuites suites = new Testsuites();
        for (String componentName : results.getComponentNames()) {
            Testsuite suite = new Testsuite();
            suite.setName(componentName);
            List<TestResults> list = results.getResultsByComponentName(componentName);
            this.addResults(suite, list);
            suites.getTestsuite().add(suite);
        }
        return suites;
    }

    private void addResults(Testsuite suite, List<TestResults> list) {
        if (list == null) {
            return;
        }
        for (TestResults results : list) {
            String className = results.getClassName();
            for (TestResult result : results.getResults()) {
                Testcase tc = new Testcase();
                tc.setClassname(className);
                tc.setName(result.getTestCaseName());
                if (result.getTestStatus() == TestStatus.FAILURE) {
                    Error err = new Error();
                    err.setContent(result.getErrorMsg());
                    tc.getError().add(err);
                }
                suite.getTestcase().add(tc);
            }
        }
    }
}

