/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test.client.report.junit;

import com.ericsson.cms.test.client.TestRunResults;
import com.ericsson.cms.test.client.report.junit.JunitReportFactory;
import com.ericsson.cms.test.client.report.junit.gen.Testsuites;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.log4j.Logger;

public class JunitReportJaxbService {
    private final String JAXB_CONTEXT_PATH = "com.ericsson.cms.test.client.report.junit.gen";
    private static Logger logger = Logger.getLogger(JunitReportJaxbService.class);

    public String marshalTestRunResults(TestRunResults results) throws Exception {
        if (results == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        this.marshalTestRunResults(results, writer);
        return writer.toString();
    }

    public void marshalTestRunResults(TestRunResults results, Writer writer) throws Exception {
        try {
            JunitReportFactory jaxbFactory = new JunitReportFactory();
            Testsuites ts = jaxbFactory.createTestsuites(results);
            Marshaller mar = this.createMarshaller();
            mar.marshal((Object)ts, writer);
        }
        catch (Exception ex) {
            String msg = "Unable to marshal test results";
            logger.error((Object)msg, (Throwable)ex);
            throw new Exception(msg, ex);
        }
    }

    private Marshaller createMarshaller() throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)"com.ericsson.cms.test.client.report.junit.gen");
        Marshaller mar = jc.createMarshaller();
        mar.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        return mar;
    }
}

