/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test.jaxb;

import com.ericsson.cms.test.TestResult;
import com.ericsson.cms.test.TestResults;
import com.ericsson.cms.test.TestStatus;
import com.ericsson.cms.test.jaxb.model.TestCaseResultsListType;
import com.ericsson.cms.test.jaxb.model.TestCaseResultsType;
import com.ericsson.cms.test.jaxb.model.TestResultsType;
import java.util.List;

public class TesterJaxbFactory {
    public TestResultsType createTestResultsType(TestResults results) {
        if (results == null) {
            return null;
        }
        TestResultsType type = new TestResultsType();
        type.setClassName(results.getClassName());
        List<TestResult> list = results.getResults();
        if (list != null && !list.isEmpty()) {
            type.setTestCases(new TestCaseResultsListType());
            for (TestResult tr : list) {
                TestCaseResultsType tcType = new TestCaseResultsType();
                tcType.setName(tr.getTestCaseName());
                tcType.setStatus(tr.getTestStatus().toString());
                tcType.setMessage(tr.getErrorMsg());
                type.getTestCases().getTestCase().add(tcType);
            }
        }
        return type;
    }

    public TestResults createTestResults(TestResultsType type) {
        if (type == null) {
            return null;
        }
        TestResults results = new TestResults(type.getClassName());
        if (type.getTestCases() != null) {
            List<TestCaseResultsType> list = type.getTestCases().getTestCase();
            for (TestCaseResultsType tcrType : list) {
                TestResult res = new TestResult();
                res.setErrorMsg(tcrType.getMessage());
                res.setTestCaseName(tcrType.getName());
                TestStatus status = "SUCCESS".equalsIgnoreCase(tcrType.getStatus()) ? TestStatus.SUCCESS : TestStatus.FAILURE;
                res.setTestStatus(status);
                results.getResults().add(res);
            }
        }
        return results;
    }
}

