/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test.jaxb;

import com.ericsson.cms.test.TestResults;
import com.ericsson.cms.test.jaxb.TesterJaxbFactory;
import com.ericsson.cms.test.jaxb.model.ObjectFactory;
import com.ericsson.cms.test.jaxb.model.TestResultsType;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;

public class TesterJaxbService {
    private final String JAXB_CONTEXT_PATH = "com.ericsson.cms.test.jaxb.model";
    private static Logger logger = Logger.getLogger(TesterJaxbService.class);

    public String marshalTestResults(TestResults results) throws Exception {
        if (results == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        this.marshalTestResults(results, writer);
        return writer.toString();
    }

    public void marshalTestResults(TestResults results, Writer writer) throws Exception {
        try {
            TesterJaxbFactory jaxbFactory = new TesterJaxbFactory();
            TestResultsType type = jaxbFactory.createTestResultsType(results);
            ObjectFactory factory = new ObjectFactory();
            JAXBElement<TestResultsType> root = factory.createTestResults(type);
            Marshaller mar = this.createMarshaller();
            mar.marshal(root, writer);
        }
        catch (Exception ex) {
            String msg = "Unable to marshal test results";
            logger.error((Object)msg, (Throwable)ex);
            throw new Exception(msg, ex);
        }
    }

    public TestResults unmarshalTestResults(Reader reader) throws Exception {
        try {
            Unmarshaller umar = this.createUnmarshaller();
            JAXBElement root = (JAXBElement)umar.unmarshal(reader);
            TestResultsType results = (TestResultsType)root.getValue();
            TesterJaxbFactory jaxbFactory = new TesterJaxbFactory();
            return jaxbFactory.createTestResults(results);
        }
        catch (Exception ex) {
            String msg = "Unable to unmarshal test results: " + ex.getMessage();
            logger.error((Object)msg, (Throwable)ex);
            throw new Exception(msg, ex);
        }
    }

    public TestResults unmarshalTestResults(String xml) throws Exception {
        if (xml == null) {
            return null;
        }
        StringReader reader = new StringReader(xml);
        return this.unmarshalTestResults(reader);
    }

    private Marshaller createMarshaller() throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)"com.ericsson.cms.test.jaxb.model");
        Marshaller mar = jc.createMarshaller();
        mar.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        return mar;
    }

    private Unmarshaller createUnmarshaller() throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)"com.ericsson.cms.test.jaxb.model");
        return jc.createUnmarshaller();
    }
}

