/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.test.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Logger;

public class ResourceLoader {
    private static final Logger logger = Logger.getLogger(ResourceLoader.class);

    public static URL getResource(String metaInfPath, String woTestFile) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        URL resource = null;
        Enumeration<URL> resources = classLoader.getResources("META-INF/" + woTestFile);
        logger.debug((Object)("getResource for META-INF/" + woTestFile));
        while (resources.hasMoreElements()) {
            resource = resources.nextElement();
            String fileName = resource.getFile();
            String fileNameDecoded = URLDecoder.decode(fileName, "UTF-8");
            logger.info((Object)("resourceFile in classloader=" + fileNameDecoded + "    path=" + resource.getPath()));
        }
        return resource;
    }

    public static List<String> getAllCommandsFromJarFile() throws IOException {
        ArrayList<String> componentCmds = new ArrayList<String>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        Enumeration<URL> resources = classLoader.getResources("META-INF/Commands.cfg");
        while (resources.hasMoreElements()) {
            String inputLine;
            URL resource = resources.nextElement();
            String fileName = resource.getFile();
            String fileNameDecoded = URLDecoder.decode(fileName, "UTF-8");
            logger.debug((Object)("resourceFile in classloader=" + fileNameDecoded + "    path=" + resource.getPath()));
            BufferedReader in = new BufferedReader(new InputStreamReader(resource.openStream()));
            while ((inputLine = in.readLine()) != null) {
                String cmd;
                if (inputLine.trim().startsWith("#") || (cmd = inputLine.trim()).isEmpty() || componentCmds.contains(cmd)) continue;
                componentCmds.add(cmd);
            }
            in.close();
        }
        return componentCmds;
    }
}

