/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.page;

import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Field
implements Serializable {
    private static final long serialVersionUID = 7600402103239677060L;
    private Map<String, String> attributesMap = new HashMap<String, String>();
    private Map<String, String> valuesMap = new HashMap<String, String>();

    public Map<String, String> getAttributesMap() {
        return this.attributesMap;
    }

    public void setAttributesMap(Map<String, String> attributesMap) {
        this.attributesMap = attributesMap;
    }

    public String getAttribute(String name) {
        return this.attributesMap.get(name);
    }

    public Map<String, String> getValuesMap() {
        return this.valuesMap;
    }

    public void setValuesMap(Map<String, String> valuesMap) {
        this.valuesMap = valuesMap;
    }

    public String getEntity() {
        return this.getAttribute("entity");
    }

    public String getProperty() {
        String property = this.getAttribute("property");
        if (property != null) {
            return property;
        }
        return this.getName();
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public String getLabel() {
        return this.getAttribute("label");
    }

    public String getColumn() {
        return this.getAttribute("column");
    }

    public String getType() {
        return this.getAttribute("type");
    }

    public boolean getIsTextbox() {
        return this.getType().equals("textbox");
    }

    public boolean getIsSingleSelect() {
        return this.getType().equals("dropdown");
    }

    public boolean getIsMultiSelect() {
        return this.getType().equals("list");
    }

    public boolean getIsDateRange() {
        return this.getType().equals("dateRange");
    }

    public String getStyle() {
        return this.getAttribute("style");
    }

    public boolean getIsResource() {
        String value = this.getAttribute("isResource");
        boolean isResource = true;
        if (value != null && value.trim().length() > 0) {
            isResource = Boolean.parseBoolean(value);
        }
        return isResource;
    }

    public SearchType getSearchType() {
        String type = this.getAttribute("dataType");
        if (type == null || type.length() == 0) {
            return SearchType.STRING;
        }
        return SearchType.valueOf((String)type);
    }

    public SearchOperator getSearchOperator() {
        String operator = this.getAttribute("operator");
        if (operator == null || operator.length() == 0) {
            return SearchOperator.EQUAL;
        }
        return SearchOperator.valueOf((String)operator);
    }

    public String getParameterType() {
        return this.getAttribute("paramType");
    }

    public boolean getIsValueParameter() {
        return "value".equals(this.getParameterType());
    }

    public boolean getIsListParameter() {
        return "list".equals(this.getParameterType());
    }

    public boolean getIsRangeParameter() {
        return "range".equals(this.getParameterType());
    }

    public boolean hasValues(String ... values) {
        if (values == null) {
            return false;
        }
        if (this.getIsValueParameter() && values[0].length() == 0) {
            return false;
        }
        if (this.getIsRangeParameter()) {
            if (values.length < 2) {
                return false;
            }
            String from = values[0];
            String to = values[1];
            return from.length() > 0 || to.length() > 0;
        }
        if (this.getIsListParameter()) {
            return values.length > 0;
        }
        return true;
    }

    public String getDefaultStyle() {
        String type = this.getType();
        if (type.equals("dropdown")) {
            return "width: 280px; max-height: 140px;";
        }
        if (type.equals("list")) {
            return "width: 280px; max-height: 140px;";
        }
        if (type.equals("textbox")) {
            return "";
        }
        if (type.equals("dateRange")) {
            return "";
        }
        return "";
    }
}

