/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.web.util;

import com.n2bb.web.util.ReportWriter;
import com.tandbergtv.workflow.web.formbeans.BaseForm;
import com.tandbergtv.workflow.web.table.Column;
import com.tandbergtv.workflow.web.table.Table;
import com.tandbergtv.workflow.web.table.TableConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ExportUtility {
    private static final Logger log = Logger.getLogger(ExportUtility.class);
    private static final String DEFAULT_HEADER = "Default";

    public boolean exportDataToExcel(HttpServletRequest request, HttpServletResponse response, BaseForm baseForm, Collection<?> dataBeans, File configFile, String propertiesFileName) {
        String tableName = request.getParameter("tableName") == null ? "NO TABLE FOUND" : request.getParameter("tableName").toString();
        Table table = TableConfig.getInstance().getTable(tableName, configFile);
        return this.exportDataToExcel(request, response, table, baseForm, dataBeans, propertiesFileName);
    }

    public boolean exportDataToExcel(HttpServletRequest request, HttpServletResponse response, Table table, BaseForm baseForm, Collection<?> dataBeans, String propertiesFileName) {
        try {
            String header = request.getParameter("headerName") == null ? DEFAULT_HEADER : request.getParameter("headerName").toString();
            log.debug((Object)("Header Name:" + header));
            String sortBy = baseForm.getSortingColumnName() == null || baseForm.getSortingColumnName().equals("") ? null : baseForm.getSortingColumnName();
            log.debug((Object)("Sort By:" + sortBy));
            log.debug((Object)("records :" + dataBeans));
            List<Column> columns = table.getColumns();
            ArrayList<String> columnDisplayNamesList = new ArrayList<String>();
            ArrayList<String> methodNamesList = new ArrayList<String>();
            ArrayList<String> parameterList = new ArrayList<String>();
            ResourceBundle rbPaginationConstants = ResourceBundle.getBundle(propertiesFileName);
            for (Column column : columns) {
                if (column.getIsCheckBox()) continue;
                HashMap<String, String> map = column.getColumnAttributesMap();
                String columnDisplayName = map.get("ColumnName").toString();
                if (columnDisplayName == null) {
                    columnDisplayName = "";
                }
                try {
                    columnDisplayName = rbPaginationConstants.getString(columnDisplayName);
                }
                catch (Exception ex) {
                    log.debug((Object)("Key : " + columnDisplayName + " not found in resource bundle. Using the column name as-is."), (Throwable)ex);
                }
                columnDisplayNamesList.add(columnDisplayName);
                if (map.get("MethodName") == null) {
                    if (map.get("ParmValue") == null) continue;
                    methodNamesList.add("paramValue");
                    parameterList.add(map.get("ParmValue").toString());
                    continue;
                }
                methodNamesList.add(map.get("MethodName").toString());
                parameterList.add("");
            }
            String[] columnDisplayNames = columnDisplayNamesList.toArray(new String[0]);
            String[] methodNames = methodNamesList.toArray(new String[0]);
            String[] parameterNames = parameterList.toArray(new String[0]);
            ReportWriter.generateReport(response, "Excel", header, null, sortBy, columnDisplayNames, methodNames, parameterNames, dataBeans);
            return true;
        }
        catch (Exception ex) {
            log.error((Object)("Exception happened while exporting to Excel :" + ex), (Throwable)ex);
            return false;
        }
    }
}

