/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util;

import com.tandbergtv.watchpoint.pmm.util.LocalizedMessageUtil;
import com.tandbergtv.workflow.web.table.Column;
import com.tandbergtv.workflow.web.table.Table;
import com.tandbergtv.workflow.web.table.TableExtensionBuilder;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableConfigExt
implements Serializable {
    private static TableConfigExt tableCofig;
    private static final long serialVersionUID = 1L;
    private static final Logger logger;
    private static String TABLE_TAG_NAME;
    private static String TABLE_ID;
    private LocalizedMessageUtil localizedMessageUtil;

    public static synchronized TableConfigExt getInstance() {
        if (tableCofig == null) {
            tableCofig = new TableConfigExt();
        }
        return tableCofig;
    }

    public Table getTable(String tableId, File tableConfigFile) {
        return this.getTable(tableId, tableConfigFile, null);
    }

    private LocalizedMessageUtil getLocalizedMessageUtil() {
        if (this.localizedMessageUtil == null) {
            this.localizedMessageUtil = new LocalizedMessageUtil("table-config");
        }
        return this.localizedMessageUtil;
    }

    public Table getTable(String tableId, File tableConfigFile, Map<String, String> runtimeProperties) {
        Map<String, Table> tables = this.getTables(tableConfigFile);
        Table table = tables.get(tableId);
        LocalizedMessageUtil messageUtil = this.getLocalizedMessageUtil();
        table.getColumns().forEach(c -> {
            String nameKey = c.getColumnAttribute("ColumnName");
            if (nameKey != null) {
                String localizedName = messageUtil.getMessageValue(nameKey);
                c.setColumnAttribute("ColumnName", localizedName);
            }
        });
        TableExtensionBuilder extensionBuilder = new TableExtensionBuilder();
        extensionBuilder.buildTable(table, runtimeProperties);
        return table;
    }

    private Map<String, Table> getTables(File tableConfigFile) {
        HashMap<String, Table> tables = new HashMap<String, Table>();
        NodeList nodes = this.getNodes(tableConfigFile);
        if (nodes == null) {
            return tables;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Table table = this.getTable(nodes.item(i));
            tables.put(table.getId(), table);
        }
        if (logger.isDebugEnabled()) {
            tables.keySet().stream().forEach(tableId -> {
                logger.debug((Object)("Table Name-->" + tableId));
                ((Table)tables.get(tableId)).getColumns().forEach(column -> logger.debug((Object)("maps-->" + column.getColumnAttributesMap())));
            });
        }
        return tables;
    }

    private NodeList getNodes(File tableConfigFile) {
        NodeList nodes = null;
        try {
            Document arg31 = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(tableConfigFile);
            nodes = arg31.getDocumentElement().getElementsByTagName(TABLE_TAG_NAME);
        }
        catch (Exception arg3) {
            logger.warn((Object)"Failed to read the table configuration file", (Throwable)arg3);
        }
        return nodes;
    }

    private String getNodeValue(NamedNodeMap attributes, String name) {
        return attributes.getNamedItem(name).getNodeValue();
    }

    private Table getTable(Node node) {
        Table table = new Table();
        NamedNodeMap attributes = node.getAttributes();
        table.setId(attributes.getNamedItem(TABLE_ID).getNodeValue());
        table.setDefaultSortingColumn(this.getNodeValue(attributes, "defaultSortingColumn"));
        table.setDefaultSortingOrder(this.getNodeValue(attributes, "defaultSortingOrder"));
        table.setActionPath(this.getNodeValue(attributes, "actionPath"));
        table.setDefaultColumnWidth(this.getNodeValue(attributes, "defaultColumnWidth"));
        ArrayList<Column> columns = new ArrayList<Column>();
        if (node.hasChildNodes()) {
            NodeList columnNodeList = node.getChildNodes();
            for (int j = 0; j < columnNodeList.getLength(); ++j) {
                NodeList columnParams = columnNodeList.item(j).getChildNodes();
                if (columnParams.getLength() <= 0) continue;
                Column column = new Column();
                HashMap<String, String> map = new HashMap<String, String>();
                for (int k = 0; k < columnParams.getLength(); ++k) {
                    Node n = columnParams.item(k);
                    NodeList children = n.getChildNodes();
                    for (int l = 0; l < children.getLength(); ++l) {
                        map.put(n.getNodeName(), children.item(l).getNodeValue());
                    }
                }
                column.setColumnAttributesMap(map);
                columns.add(column);
            }
            table.setColumns(columns);
        }
        return table;
    }

    static {
        logger = Logger.getLogger(TableConfigExt.class);
        TABLE_TAG_NAME = "table";
        TABLE_ID = "id";
    }
}

