/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.message;

import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.routing.CommunicationException;
import com.tandbergtv.workflow.comm.routing.IRoutingService;
import com.tandbergtv.workflow.comm.routing.RoutingServiceFactory;
import com.tandbergtv.workflow.core.AbstractTaskNode;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ResourceGroupAware;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.exe.AbstractAction;
import com.tandbergtv.workflow.exe.ActionException;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.command.ICommandExecutor;
import com.tandbergtv.workflow.message.event.WorkflowMessageLogEvent;
import com.tandbergtv.workflow.resourcemanager.IInternalResourceService;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceConnectionType;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.util.ResourceFailureLogWriter;
import com.tandbergtv.workflow.util.DeviceTypeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.def.Task;

public abstract class AbstractMessageEmitter
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    protected String send;
    protected Map<?, ?> map;
    private static final Logger LOGGER = Logger.getLogger(AbstractMessageEmitter.class);

    protected AbstractMessageEmitter() {
    }

    protected void start(ExecutionContext context) {
        WorkflowMessage request = this.createRequest(context);
        WorkflowMessage response = this.send(request, context);
        this.validate(response);
        this.copy(response, context);
        ICommandExecutor executor = (ICommandExecutor)ServiceRegistry.getDefault().lookup(ICommandExecutor.class);
        executor.execute(response);
    }

    protected WorkflowMessage send(WorkflowMessage request, ExecutionContext context) {
        Resource resource = this.getResource(context);
        Token token = context.getToken();
        Node node = context.getNode();
        this.saveRequest(request, token, node, resource);
        final IDestination destination = (IDestination)DeviceTypeUtil.createDevice((Resource)resource);
        LOGGER.info((Object)("[Process] " + token + " calling " + resource + " (" + destination + ")" + " [" + this.send + "]"));
        WorkflowMessage response = null;
        try {
            IRoutingService service = RoutingServiceFactory.newInstance().createRoutingService();
            response = service.send(request, (List)new ArrayList<IDestination>(){
                {
                    this.add(destination);
                }
            });
            response.setKey(request.getKey());
        }
        catch (CommunicationException e) {
            throw new ActionException((Throwable)e);
        }
        finally {
            if (response == null || response.getType() == WorkflowMessage.MessageType.nack) {
                ResourceFailureLogWriter.getInstance().writeLog(((AbstractTaskNode)node).getResourceGroupID().longValue(), resource);
            }
        }
        this.saveResponse(response, token, node, resource);
        return response;
    }

    protected WorkflowMessage createRequest(ExecutionContext context) {
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)this.send, (ExecutionContext)context);
        Map<String, Object> parameters = this.getProcessParameters(context);
        for (String key : parameters.keySet()) {
            Object value = parameters.get(key);
            LOGGER.debug((Object)("Global variable " + key + " value " + value));
            if (value == null) continue;
            message.putValue(key, value);
        }
        if (this.map != null) {
            for (String key : this.map.keySet()) {
                message.putValue(key.toString(), this.map.get(key).toString());
                LOGGER.debug((Object)("Local variable " + key + " value " + this.map.get(key)));
            }
        }
        return message;
    }

    protected void validate(WorkflowMessage response) {
        if (response.getType() == WorkflowMessage.MessageType.nack) {
            ActionException e = null;
            Object o = response.getParameterValue("error-message");
            e = o instanceof String ? new ActionException(ErrorCategory.NACK.name(), (Throwable)new Exception((String)o)) : new ActionException(ErrorCategory.NACK.name());
            e.setProperty("message", (Object)response);
            throw e;
        }
    }

    protected Resource getResource(ExecutionContext context) {
        if (!this.needsResource(context)) {
            return this.autoGenerateResource();
        }
        ContextInstance c = context.getContextInstance();
        Resource resource = (Resource)c.getTransientVariable("_resource_" + context.getToken().getId());
        if (resource == null) {
            throw new ActionException(context.getToken() + ", resource unavailable");
        }
        return resource;
    }

    protected Resource autoGenerateResource() {
        Resource resource = new Resource();
        ResourceType rt = new ResourceType();
        rt.setConnectionType(ResourceConnectionType.URL);
        String name = UUID.randomUUID().toString();
        resource.setConnectionString("resource:///" + name);
        resource.setName(name);
        resource.setResourceType(rt);
        return resource;
    }

    protected void saveRequest(WorkflowMessage request, Token token, Node node, Resource resource) {
        DefaultMediator.getInstance().send((WorkflowEvent)new WorkflowMessageLogEvent(token, node, false, resource, request));
    }

    protected void saveResponse(WorkflowMessage response, Token token, Node node, Resource resource) {
        DefaultMediator.getInstance().send((WorkflowEvent)new WorkflowMessageLogEvent(token, node, true, resource, response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> getProcessParameters(ExecutionContext context) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Collection<TaskVariable> variables = this.getVariables(context);
        WorkflowProcess process = (WorkflowProcess)context.getProcessInstance();
        process.lock();
        try {
            for (TaskVariable variable : variables) {
                if (!variable.isReadable()) continue;
                String name = variable.getVariableName();
                Object value = context.getVariable(name);
                if (variable.getMappedName() != null) {
                    name = variable.getMappedName();
                }
                map.put(name, value);
            }
        }
        finally {
            process.unlock();
        }
        return map;
    }

    protected Collection<TaskVariable> getVariables(ExecutionContext context) {
        Task task = context.getTask();
        if (task != null) {
            return task.getTaskController().getVariableAccesses();
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(WorkflowMessage response, ExecutionContext context) {
        Collection<TaskVariable> variables = this.getVariables(context);
        WorkflowProcess process = (WorkflowProcess)context.getToken().getProcessInstance();
        process.lock();
        try {
            for (TaskVariable variable : variables) {
                if (!variable.isWritable()) continue;
                String name = variable.getVariableName();
                Object value = response.getParameterValue(variable.getMappedName());
                if (value == null && response.getCommand() != null) {
                    value = response.getCommand().getParameterValue(variable.getMappedName());
                }
                LOGGER.debug((Object)("Writing variable " + name + " value " + value));
                this.setContextVariable(context, variable, name, value);
            }
        }
        finally {
            process.unlock();
        }
    }

    private boolean needsResource(ExecutionContext context) {
        CustomToken token = (CustomToken)context.getToken();
        Node node = token.getCurrentNode();
        Long resourceGroupId = ((ResourceGroupAware)node).getResourceGroupID();
        IInternalResourceService service = (IInternalResourceService)ServiceRegistry.getDefault().lookup(IInternalResourceService.class);
        return service.needsResource(resourceGroupId.longValue()) && !Boolean.getBoolean("com.tandbergtv.workflow.resourcemanager.consumertrace.disable");
    }
}

