/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.util;

import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.Member;
import com.tandbergtv.workflow.core.service.cluster.IClusterService;
import com.tandbergtv.workflow.core.service.thread.DistributedCallable;
import com.tandbergtv.workflow.core.service.thread.DistributedLocalCallable;
import com.tandbergtv.workflow.core.service.thread.DistributedMasterCallable;
import java.net.InetSocketAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.lang.Validate;

public final class SchedulerUtils {
    private SchedulerUtils() {
    }

    public static <T> Future<T> submitTask(Callable<T> callable, IExecutorService executorService, IClusterService clusterService) {
        Validate.notNull(callable);
        Validate.notNull((Object)executorService);
        Validate.notNull((Object)clusterService);
        if (callable instanceof DistributedCallable) {
            Object key = ((DistributedCallable)DistributedCallable.class.cast(callable)).getKey();
            if (key == null) {
                throw new RejectedExecutionException("Cannot perform the DistributedCallable without a key on this schedule method");
            }
            if (key instanceof InetSocketAddress) {
                InetSocketAddress address = (InetSocketAddress)InetSocketAddress.class.cast(key);
                Member target = clusterService.getMemberByAddress(address);
                if (target == null) {
                    throw new RejectedExecutionException("Address unavailable: " + address);
                }
                return executorService.submitToMember(callable, target);
            }
            return executorService.submitToKeyOwner(callable, key);
        }
        if (callable instanceof DistributedMasterCallable) {
            return executorService.submitToMember(callable, clusterService.getMaster());
        }
        if (callable instanceof DistributedLocalCallable) {
            return executorService.submitToMember(callable, clusterService.getLocalMember());
        }
        return executorService.submit(callable);
    }
}

